// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatch.model



public class PutMetricStreamRequest private constructor(builder: Builder) {
    /**
     * If you specify this parameter, the stream sends metrics from all metric namespaces except for the namespaces that you specify here.
     *
     * You cannot include `ExcludeFilters` and `IncludeFilters` in the same operation.
     */
    public val excludeFilters: List<MetricStreamFilter>? = builder.excludeFilters
    /**
     * The ARN of the Amazon Kinesis Firehose delivery stream to use for this metric stream. This Amazon Kinesis Firehose delivery stream must already exist and must be in the same account as the metric stream.
     */
    public val firehoseArn: kotlin.String? = builder.firehoseArn
    /**
     * If you specify this parameter, the stream sends only the metrics from the metric namespaces that you specify here.
     *
     * You cannot include `IncludeFilters` and `ExcludeFilters` in the same operation.
     */
    public val includeFilters: List<MetricStreamFilter>? = builder.includeFilters
    /**
     * If you are creating a new metric stream, this is the name for the new stream. The name must be different than the names of other metric streams in this account and Region.
     *
     * If you are updating a metric stream, specify the name of that stream here.
     *
     * Valid characters are A-Z, a-z, 0-9, "-" and "_".
     */
    public val name: kotlin.String? = builder.name
    /**
     * The output format for the stream. Valid values are `json` and `opentelemetry0.7`. For more information about metric stream output formats, see [ Metric streams output formats](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-metric-streams-formats.html).
     */
    public val outputFormat: aws.sdk.kotlin.services.cloudwatch.model.MetricStreamOutputFormat? = builder.outputFormat
    /**
     * The ARN of an IAM role that this metric stream will use to access Amazon Kinesis Firehose resources. This IAM role must already exist and must be in the same account as the metric stream. This IAM role must include the following permissions:
     * + firehose:PutRecord
     * + firehose:PutRecordBatch
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * By default, a metric stream always sends the `MAX`, `MIN`, `SUM`, and `SAMPLECOUNT` statistics for each metric that is streamed. You can use this parameter to have the metric stream also send additional statistics in the stream. This array can have up to 100 members.
     *
     * For each entry in this array, you specify one or more metrics and the list of additional statistics to stream for those metrics. The additional statistics that you can stream depend on the stream's `OutputFormat`. If the `OutputFormat` is `json`, you can stream any additional statistic that is supported by CloudWatch, listed in [ CloudWatch statistics definitions](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Statistics-definitions.html.html). If the `OutputFormat` is `opentelemetry0.7`, you can stream percentile statistics such as p95, p99.9 and so on.
     */
    public val statisticsConfigurations: List<MetricStreamStatisticsConfiguration>? = builder.statisticsConfigurations
    /**
     * A list of key-value pairs to associate with the metric stream. You can associate as many as 50 tags with a metric stream.
     *
     * Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.
     *
     * You can use this parameter only when you are creating a new metric stream. If you are using this operation to update an existing metric stream, any tags you specify in this parameter are ignored. To change the tags of an existing metric stream, use [TagResource](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_TagResource.html) or [UntagResource](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_UntagResource.html).
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatch.model.PutMetricStreamRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutMetricStreamRequest(")
        append("excludeFilters=$excludeFilters,")
        append("firehoseArn=$firehoseArn,")
        append("includeFilters=$includeFilters,")
        append("name=$name,")
        append("outputFormat=$outputFormat,")
        append("roleArn=$roleArn,")
        append("statisticsConfigurations=$statisticsConfigurations,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = excludeFilters?.hashCode() ?: 0
        result = 31 * result + (firehoseArn?.hashCode() ?: 0)
        result = 31 * result + (includeFilters?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (outputFormat?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (statisticsConfigurations?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutMetricStreamRequest

        if (excludeFilters != other.excludeFilters) return false
        if (firehoseArn != other.firehoseArn) return false
        if (includeFilters != other.includeFilters) return false
        if (name != other.name) return false
        if (outputFormat != other.outputFormat) return false
        if (roleArn != other.roleArn) return false
        if (statisticsConfigurations != other.statisticsConfigurations) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatch.model.PutMetricStreamRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * If you specify this parameter, the stream sends metrics from all metric namespaces except for the namespaces that you specify here.
         *
         * You cannot include `ExcludeFilters` and `IncludeFilters` in the same operation.
         */
        public var excludeFilters: List<MetricStreamFilter>? = null
        /**
         * The ARN of the Amazon Kinesis Firehose delivery stream to use for this metric stream. This Amazon Kinesis Firehose delivery stream must already exist and must be in the same account as the metric stream.
         */
        public var firehoseArn: kotlin.String? = null
        /**
         * If you specify this parameter, the stream sends only the metrics from the metric namespaces that you specify here.
         *
         * You cannot include `IncludeFilters` and `ExcludeFilters` in the same operation.
         */
        public var includeFilters: List<MetricStreamFilter>? = null
        /**
         * If you are creating a new metric stream, this is the name for the new stream. The name must be different than the names of other metric streams in this account and Region.
         *
         * If you are updating a metric stream, specify the name of that stream here.
         *
         * Valid characters are A-Z, a-z, 0-9, "-" and "_".
         */
        public var name: kotlin.String? = null
        /**
         * The output format for the stream. Valid values are `json` and `opentelemetry0.7`. For more information about metric stream output formats, see [ Metric streams output formats](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-metric-streams-formats.html).
         */
        public var outputFormat: aws.sdk.kotlin.services.cloudwatch.model.MetricStreamOutputFormat? = null
        /**
         * The ARN of an IAM role that this metric stream will use to access Amazon Kinesis Firehose resources. This IAM role must already exist and must be in the same account as the metric stream. This IAM role must include the following permissions:
         * + firehose:PutRecord
         * + firehose:PutRecordBatch
         */
        public var roleArn: kotlin.String? = null
        /**
         * By default, a metric stream always sends the `MAX`, `MIN`, `SUM`, and `SAMPLECOUNT` statistics for each metric that is streamed. You can use this parameter to have the metric stream also send additional statistics in the stream. This array can have up to 100 members.
         *
         * For each entry in this array, you specify one or more metrics and the list of additional statistics to stream for those metrics. The additional statistics that you can stream depend on the stream's `OutputFormat`. If the `OutputFormat` is `json`, you can stream any additional statistic that is supported by CloudWatch, listed in [ CloudWatch statistics definitions](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Statistics-definitions.html.html). If the `OutputFormat` is `opentelemetry0.7`, you can stream percentile statistics such as p95, p99.9 and so on.
         */
        public var statisticsConfigurations: List<MetricStreamStatisticsConfiguration>? = null
        /**
         * A list of key-value pairs to associate with the metric stream. You can associate as many as 50 tags with a metric stream.
         *
         * Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.
         *
         * You can use this parameter only when you are creating a new metric stream. If you are using this operation to update an existing metric stream, any tags you specify in this parameter are ignored. To change the tags of an existing metric stream, use [TagResource](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_TagResource.html) or [UntagResource](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_UntagResource.html).
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatch.model.PutMetricStreamRequest) : this() {
            this.excludeFilters = x.excludeFilters
            this.firehoseArn = x.firehoseArn
            this.includeFilters = x.includeFilters
            this.name = x.name
            this.outputFormat = x.outputFormat
            this.roleArn = x.roleArn
            this.statisticsConfigurations = x.statisticsConfigurations
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatch.model.PutMetricStreamRequest = PutMetricStreamRequest(this)
    }
}
