// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatch.paginators

import aws.sdk.kotlin.services.cloudwatch.CloudWatchClient
import aws.sdk.kotlin.services.cloudwatch.model.AlarmHistoryItem
import aws.sdk.kotlin.services.cloudwatch.model.DashboardEntry
import aws.sdk.kotlin.services.cloudwatch.model.DescribeAlarmHistoryRequest
import aws.sdk.kotlin.services.cloudwatch.model.DescribeAlarmHistoryResponse
import aws.sdk.kotlin.services.cloudwatch.model.DescribeAlarmsRequest
import aws.sdk.kotlin.services.cloudwatch.model.DescribeAlarmsResponse
import aws.sdk.kotlin.services.cloudwatch.model.DescribeInsightRulesRequest
import aws.sdk.kotlin.services.cloudwatch.model.DescribeInsightRulesResponse
import aws.sdk.kotlin.services.cloudwatch.model.GetMetricDataRequest
import aws.sdk.kotlin.services.cloudwatch.model.GetMetricDataResponse
import aws.sdk.kotlin.services.cloudwatch.model.ListDashboardsRequest
import aws.sdk.kotlin.services.cloudwatch.model.ListDashboardsResponse
import aws.sdk.kotlin.services.cloudwatch.model.ListMetricStreamsRequest
import aws.sdk.kotlin.services.cloudwatch.model.ListMetricStreamsResponse
import aws.sdk.kotlin.services.cloudwatch.model.ListMetricsRequest
import aws.sdk.kotlin.services.cloudwatch.model.ListMetricsResponse
import aws.sdk.kotlin.services.cloudwatch.model.Metric
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [DescribeAlarmHistoryResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeAlarmHistoryRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeAlarmHistoryResponse]
 */
public fun CloudWatchClient.describeAlarmHistoryPaginated(initialRequest: DescribeAlarmHistoryRequest): Flow<DescribeAlarmHistoryResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeAlarmHistoryPaginated.describeAlarmHistory(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeAlarmHistoryResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeAlarmHistoryResponse]
 */
public fun CloudWatchClient.describeAlarmHistoryPaginated(block: DescribeAlarmHistoryRequest.Builder.() -> Unit): Flow<DescribeAlarmHistoryResponse> =
    describeAlarmHistoryPaginated(DescribeAlarmHistoryRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeAlarmHistoryPaginated]
 * to access the nested member [AlarmHistoryItem]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AlarmHistoryItem]
 */
@JvmName("describeAlarmHistoryResponseAlarmHistoryItem")
public fun Flow<DescribeAlarmHistoryResponse>.alarmHistoryItems(): Flow<AlarmHistoryItem> =
    transform() { response ->
        response.alarmHistoryItems?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeAlarmsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeAlarmsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeAlarmsResponse]
 */
public fun CloudWatchClient.describeAlarmsPaginated(initialRequest: DescribeAlarmsRequest): Flow<DescribeAlarmsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeAlarmsPaginated.describeAlarms(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeAlarmsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeAlarmsResponse]
 */
public fun CloudWatchClient.describeAlarmsPaginated(block: DescribeAlarmsRequest.Builder.() -> Unit): Flow<DescribeAlarmsResponse> =
    describeAlarmsPaginated(DescribeAlarmsRequest.Builder().apply(block).build())

/**
 * Paginate over [DescribeInsightRulesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeInsightRulesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeInsightRulesResponse]
 */
public fun CloudWatchClient.describeInsightRulesPaginated(initialRequest: DescribeInsightRulesRequest): Flow<DescribeInsightRulesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeInsightRulesPaginated.describeInsightRules(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeInsightRulesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeInsightRulesResponse]
 */
public fun CloudWatchClient.describeInsightRulesPaginated(block: DescribeInsightRulesRequest.Builder.() -> Unit): Flow<DescribeInsightRulesResponse> =
    describeInsightRulesPaginated(DescribeInsightRulesRequest.Builder().apply(block).build())

/**
 * Paginate over [GetMetricDataResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetMetricDataRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetMetricDataResponse]
 */
public fun CloudWatchClient.getMetricDataPaginated(initialRequest: GetMetricDataRequest): Flow<GetMetricDataResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getMetricDataPaginated.getMetricData(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [GetMetricDataResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetMetricDataResponse]
 */
public fun CloudWatchClient.getMetricDataPaginated(block: GetMetricDataRequest.Builder.() -> Unit): Flow<GetMetricDataResponse> =
    getMetricDataPaginated(GetMetricDataRequest.Builder().apply(block).build())

/**
 * Paginate over [ListDashboardsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDashboardsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDashboardsResponse]
 */
public fun CloudWatchClient.listDashboardsPaginated(initialRequest: ListDashboardsRequest): Flow<ListDashboardsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDashboardsPaginated.listDashboards(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListDashboardsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDashboardsResponse]
 */
public fun CloudWatchClient.listDashboardsPaginated(block: ListDashboardsRequest.Builder.() -> Unit): Flow<ListDashboardsResponse> =
    listDashboardsPaginated(ListDashboardsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listDashboardsPaginated]
 * to access the nested member [DashboardEntry]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DashboardEntry]
 */
@JvmName("listDashboardsResponseDashboardEntry")
public fun Flow<ListDashboardsResponse>.dashboardEntries(): Flow<DashboardEntry> =
    transform() { response ->
        response.dashboardEntries?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListMetricsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListMetricsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMetricsResponse]
 */
public fun CloudWatchClient.listMetricsPaginated(initialRequest: ListMetricsRequest): Flow<ListMetricsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listMetricsPaginated.listMetrics(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListMetricsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMetricsResponse]
 */
public fun CloudWatchClient.listMetricsPaginated(block: ListMetricsRequest.Builder.() -> Unit): Flow<ListMetricsResponse> =
    listMetricsPaginated(ListMetricsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listMetricsPaginated]
 * to access the nested member [Metric]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Metric]
 */
@JvmName("listMetricsResponseMetric")
public fun Flow<ListMetricsResponse>.metrics(): Flow<Metric> =
    transform() { response ->
        response.metrics?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListMetricStreamsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListMetricStreamsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMetricStreamsResponse]
 */
public fun CloudWatchClient.listMetricStreamsPaginated(initialRequest: ListMetricStreamsRequest): Flow<ListMetricStreamsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listMetricStreamsPaginated.listMetricStreams(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListMetricStreamsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMetricStreamsResponse]
 */
public fun CloudWatchClient.listMetricStreamsPaginated(block: ListMetricStreamsRequest.Builder.() -> Unit): Flow<ListMetricStreamsResponse> =
    listMetricStreamsPaginated(ListMetricStreamsRequest.Builder().apply(block).build())
