// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatch.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.cloudwatch.model.CloudWatchException
import aws.sdk.kotlin.services.cloudwatch.model.CompositeAlarm
import aws.sdk.kotlin.services.cloudwatch.model.DescribeAlarmsResponse
import aws.sdk.kotlin.services.cloudwatch.model.MetricAlarm
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class DescribeAlarmsOperationDeserializer: HttpDeserialize<DescribeAlarmsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeAlarmsResponse {
        if (!response.status.isSuccess()) {
            throwDescribeAlarmsError(context, response)
        }
        val builder = DescribeAlarmsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeAlarmsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeAlarmsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw CloudWatchException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidNextToken" -> InvalidNextTokenDeserializer().deserialize(context, wrappedResponse)
        else -> CloudWatchException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeAlarmsOperationBody(builder: DescribeAlarmsResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("DescribeAlarmsResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("DescribeAlarmsResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap DescribeAlarms response")
    }
    // end unwrap response wrapper

    val COMPOSITEALARMS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("CompositeAlarms"))
    val METRICALARMS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("MetricAlarms"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("NextToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://monitoring.amazonaws.com/doc/2010-08-01/"))
        trait(XmlSerialName("DescribeAlarmsResult"))
        field(COMPOSITEALARMS_DESCRIPTOR)
        field(METRICALARMS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                COMPOSITEALARMS_DESCRIPTOR.index -> builder.compositeAlarms =
                    deserializer.deserializeList(COMPOSITEALARMS_DESCRIPTOR) {
                        val col0 = mutableListOf<CompositeAlarm>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeCompositeAlarmDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                METRICALARMS_DESCRIPTOR.index -> builder.metricAlarms =
                    deserializer.deserializeList(METRICALARMS_DESCRIPTOR) {
                        val col0 = mutableListOf<MetricAlarm>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeMetricAlarmDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
