// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatch.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.cloudwatch.model.CloudWatchException
import aws.sdk.kotlin.services.cloudwatch.model.GetDashboardResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class GetDashboardOperationDeserializer: HttpDeserialize<GetDashboardResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetDashboardResponse {
        if (!response.status.isSuccess()) {
            throwGetDashboardError(context, response)
        }
        val builder = GetDashboardResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetDashboardOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetDashboardError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw CloudWatchException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFound" -> DashboardNotFoundErrorDeserializer().deserialize(context, wrappedResponse)
        "InternalServiceError" -> InternalServiceFaultDeserializer().deserialize(context, wrappedResponse)
        "InvalidParameterValue" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CloudWatchException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetDashboardOperationBody(builder: GetDashboardResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("GetDashboardResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("GetDashboardResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap GetDashboard response")
    }
    // end unwrap response wrapper

    val DASHBOARDARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("DashboardArn"))
    val DASHBOARDBODY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("DashboardBody"))
    val DASHBOARDNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("DashboardName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://monitoring.amazonaws.com/doc/2010-08-01/"))
        trait(XmlSerialName("GetDashboardResult"))
        field(DASHBOARDARN_DESCRIPTOR)
        field(DASHBOARDBODY_DESCRIPTOR)
        field(DASHBOARDNAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DASHBOARDARN_DESCRIPTOR.index -> builder.dashboardArn = deserializeString()
                DASHBOARDBODY_DESCRIPTOR.index -> builder.dashboardBody = deserializeString()
                DASHBOARDNAME_DESCRIPTOR.index -> builder.dashboardName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
