// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatch.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.cloudwatch.model.CloudWatchException
import aws.sdk.kotlin.services.cloudwatch.model.Datapoint
import aws.sdk.kotlin.services.cloudwatch.model.GetMetricStatisticsResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class GetMetricStatisticsOperationDeserializer: HttpDeserialize<GetMetricStatisticsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetMetricStatisticsResponse {
        if (!response.status.isSuccess()) {
            throwGetMetricStatisticsError(context, response)
        }
        val builder = GetMetricStatisticsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetMetricStatisticsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetMetricStatisticsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw CloudWatchException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServiceError" -> InternalServiceFaultDeserializer().deserialize(context, wrappedResponse)
        "InvalidParameterCombination" -> InvalidParameterCombinationExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidParameterValue" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedResponse)
        "MissingParameter" -> MissingRequiredParameterExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CloudWatchException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetMetricStatisticsOperationBody(builder: GetMetricStatisticsResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("GetMetricStatisticsResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("GetMetricStatisticsResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap GetMetricStatistics response")
    }
    // end unwrap response wrapper

    val DATAPOINTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("Datapoints"))
    val LABEL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("Label"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://monitoring.amazonaws.com/doc/2010-08-01/"))
        trait(XmlSerialName("GetMetricStatisticsResult"))
        field(DATAPOINTS_DESCRIPTOR)
        field(LABEL_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DATAPOINTS_DESCRIPTOR.index -> builder.datapoints =
                    deserializer.deserializeList(DATAPOINTS_DESCRIPTOR) {
                        val col0 = mutableListOf<Datapoint>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeDatapointDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                LABEL_DESCRIPTOR.index -> builder.label = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
