// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatch.transform

import aws.sdk.kotlin.services.cloudwatch.model.ComparisonOperator
import aws.sdk.kotlin.services.cloudwatch.model.Dimension
import aws.sdk.kotlin.services.cloudwatch.model.MetricDataQuery
import aws.sdk.kotlin.services.cloudwatch.model.PutMetricAlarmRequest
import aws.sdk.kotlin.services.cloudwatch.model.StandardUnit
import aws.sdk.kotlin.services.cloudwatch.model.Statistic
import aws.sdk.kotlin.services.cloudwatch.model.Tag
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerialName
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerializer
import aws.smithy.kotlin.runtime.serde.formurl.QueryLiteral
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class PutMetricAlarmOperationSerializer: HttpSerialize<PutMetricAlarmRequest> {
    override suspend fun serialize(context: ExecutionContext, input: PutMetricAlarmRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/"
        }

        val payload = serializePutMetricAlarmOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-www-form-urlencoded")
        }
        return builder
    }
}

private fun serializePutMetricAlarmOperationBody(context: ExecutionContext, input: PutMetricAlarmRequest): ByteArray {
    val serializer = FormUrlSerializer()
    val ACTIONSENABLED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, FormUrlSerialName("ActionsEnabled"))
    val ALARMACTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("AlarmActions"))
    val ALARMDESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("AlarmDescription"))
    val ALARMNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("AlarmName"))
    val COMPARISONOPERATOR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("ComparisonOperator"))
    val DATAPOINTSTOALARM_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, FormUrlSerialName("DatapointsToAlarm"))
    val DIMENSIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("Dimensions"))
    val EVALUATELOWSAMPLECOUNTPERCENTILE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("EvaluateLowSampleCountPercentile"))
    val EVALUATIONPERIODS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, FormUrlSerialName("EvaluationPeriods"))
    val EXTENDEDSTATISTIC_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("ExtendedStatistic"))
    val INSUFFICIENTDATAACTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("InsufficientDataActions"))
    val METRICNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("MetricName"))
    val METRICS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("Metrics"))
    val NAMESPACE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("Namespace"))
    val OKACTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("OKActions"))
    val PERIOD_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, FormUrlSerialName("Period"))
    val STATISTIC_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("Statistic"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("Tags"))
    val THRESHOLD_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Double, FormUrlSerialName("Threshold"))
    val THRESHOLDMETRICID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("ThresholdMetricId"))
    val TREATMISSINGDATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("TreatMissingData"))
    val UNIT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("Unit"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(FormUrlSerialName("PutMetricAlarmInput"))
        trait(QueryLiteral("Action", "PutMetricAlarm"))
        trait(QueryLiteral("Version", "2010-08-01"))
        field(ACTIONSENABLED_DESCRIPTOR)
        field(ALARMACTIONS_DESCRIPTOR)
        field(ALARMDESCRIPTION_DESCRIPTOR)
        field(ALARMNAME_DESCRIPTOR)
        field(COMPARISONOPERATOR_DESCRIPTOR)
        field(DATAPOINTSTOALARM_DESCRIPTOR)
        field(DIMENSIONS_DESCRIPTOR)
        field(EVALUATELOWSAMPLECOUNTPERCENTILE_DESCRIPTOR)
        field(EVALUATIONPERIODS_DESCRIPTOR)
        field(EXTENDEDSTATISTIC_DESCRIPTOR)
        field(INSUFFICIENTDATAACTIONS_DESCRIPTOR)
        field(METRICNAME_DESCRIPTOR)
        field(METRICS_DESCRIPTOR)
        field(NAMESPACE_DESCRIPTOR)
        field(OKACTIONS_DESCRIPTOR)
        field(PERIOD_DESCRIPTOR)
        field(STATISTIC_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(THRESHOLD_DESCRIPTOR)
        field(THRESHOLDMETRICID_DESCRIPTOR)
        field(TREATMISSINGDATA_DESCRIPTOR)
        field(UNIT_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.actionsEnabled?.let { field(ACTIONSENABLED_DESCRIPTOR, it) }
        if (input.alarmActions != null) {
            listField(ALARMACTIONS_DESCRIPTOR) {
                for (el0 in input.alarmActions) {
                    serializeString(el0)
                }
            }
        }
        input.alarmDescription?.let { field(ALARMDESCRIPTION_DESCRIPTOR, it) }
        input.alarmName?.let { field(ALARMNAME_DESCRIPTOR, it) }
        input.comparisonOperator?.let { field(COMPARISONOPERATOR_DESCRIPTOR, it.value) }
        input.datapointsToAlarm?.let { field(DATAPOINTSTOALARM_DESCRIPTOR, it) }
        if (input.dimensions != null) {
            listField(DIMENSIONS_DESCRIPTOR) {
                for (el0 in input.dimensions) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeDimensionDocument))
                }
            }
        }
        input.evaluateLowSampleCountPercentile?.let { field(EVALUATELOWSAMPLECOUNTPERCENTILE_DESCRIPTOR, it) }
        input.evaluationPeriods?.let { field(EVALUATIONPERIODS_DESCRIPTOR, it) }
        input.extendedStatistic?.let { field(EXTENDEDSTATISTIC_DESCRIPTOR, it) }
        if (input.insufficientDataActions != null) {
            listField(INSUFFICIENTDATAACTIONS_DESCRIPTOR) {
                for (el0 in input.insufficientDataActions) {
                    serializeString(el0)
                }
            }
        }
        input.metricName?.let { field(METRICNAME_DESCRIPTOR, it) }
        if (input.metrics != null) {
            listField(METRICS_DESCRIPTOR) {
                for (el0 in input.metrics) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeMetricDataQueryDocument))
                }
            }
        }
        input.namespace?.let { field(NAMESPACE_DESCRIPTOR, it) }
        if (input.okActions != null) {
            listField(OKACTIONS_DESCRIPTOR) {
                for (el0 in input.okActions) {
                    serializeString(el0)
                }
            }
        }
        input.period?.let { field(PERIOD_DESCRIPTOR, it) }
        input.statistic?.let { field(STATISTIC_DESCRIPTOR, it.value) }
        if (input.tags != null) {
            listField(TAGS_DESCRIPTOR) {
                for (el0 in input.tags) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagDocument))
                }
            }
        }
        input.threshold?.let { field(THRESHOLD_DESCRIPTOR, it) }
        input.thresholdMetricId?.let { field(THRESHOLDMETRICID_DESCRIPTOR, it) }
        input.treatMissingData?.let { field(TREATMISSINGDATA_DESCRIPTOR, it) }
        input.unit?.let { field(UNIT_DESCRIPTOR, it.value) }
    }
    return serializer.toByteArray()
}
