// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatch.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.cloudwatch.model.CloudWatchException
import aws.sdk.kotlin.services.cloudwatch.model.PutMetricStreamResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class PutMetricStreamOperationDeserializer: HttpDeserialize<PutMetricStreamResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): PutMetricStreamResponse {
        if (!response.status.isSuccess()) {
            throwPutMetricStreamError(context, response)
        }
        val builder = PutMetricStreamResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializePutMetricStreamOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwPutMetricStreamError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw CloudWatchException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ConcurrentModificationException" -> ConcurrentModificationExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServiceError" -> InternalServiceFaultDeserializer().deserialize(context, wrappedResponse)
        "InvalidParameterCombination" -> InvalidParameterCombinationExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidParameterValue" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedResponse)
        "MissingParameter" -> MissingRequiredParameterExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CloudWatchException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializePutMetricStreamOperationBody(builder: PutMetricStreamResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("PutMetricStreamResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("PutMetricStreamResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap PutMetricStream response")
    }
    // end unwrap response wrapper

    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("Arn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://monitoring.amazonaws.com/doc/2010-08-01/"))
        trait(XmlSerialName("PutMetricStreamResult"))
        field(ARN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
