// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatch.transform

import aws.sdk.kotlin.services.cloudwatch.model.MetricStreamFilter
import aws.sdk.kotlin.services.cloudwatch.model.MetricStreamOutputFormat
import aws.sdk.kotlin.services.cloudwatch.model.MetricStreamStatisticsConfiguration
import aws.sdk.kotlin.services.cloudwatch.model.PutMetricStreamRequest
import aws.sdk.kotlin.services.cloudwatch.model.Tag
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerialName
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerializer
import aws.smithy.kotlin.runtime.serde.formurl.QueryLiteral
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class PutMetricStreamOperationSerializer: HttpSerialize<PutMetricStreamRequest> {
    override suspend fun serialize(context: ExecutionContext, input: PutMetricStreamRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/"
        }

        val payload = serializePutMetricStreamOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-www-form-urlencoded")
        }
        return builder
    }
}

private fun serializePutMetricStreamOperationBody(context: ExecutionContext, input: PutMetricStreamRequest): ByteArray {
    val serializer = FormUrlSerializer()
    val EXCLUDEFILTERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("ExcludeFilters"))
    val FIREHOSEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("FirehoseArn"))
    val INCLUDEFILTERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("IncludeFilters"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("Name"))
    val OUTPUTFORMAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("OutputFormat"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("RoleArn"))
    val STATISTICSCONFIGURATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("StatisticsConfigurations"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("Tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(FormUrlSerialName("PutMetricStreamInput"))
        trait(QueryLiteral("Action", "PutMetricStream"))
        trait(QueryLiteral("Version", "2010-08-01"))
        field(EXCLUDEFILTERS_DESCRIPTOR)
        field(FIREHOSEARN_DESCRIPTOR)
        field(INCLUDEFILTERS_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(OUTPUTFORMAT_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
        field(STATISTICSCONFIGURATIONS_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.excludeFilters != null) {
            listField(EXCLUDEFILTERS_DESCRIPTOR) {
                for (el0 in input.excludeFilters) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeMetricStreamFilterDocument))
                }
            }
        }
        input.firehoseArn?.let { field(FIREHOSEARN_DESCRIPTOR, it) }
        if (input.includeFilters != null) {
            listField(INCLUDEFILTERS_DESCRIPTOR) {
                for (el0 in input.includeFilters) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeMetricStreamFilterDocument))
                }
            }
        }
        input.name?.let { field(NAME_DESCRIPTOR, it) }
        input.outputFormat?.let { field(OUTPUTFORMAT_DESCRIPTOR, it.value) }
        input.roleArn?.let { field(ROLEARN_DESCRIPTOR, it) }
        if (input.statisticsConfigurations != null) {
            listField(STATISTICSCONFIGURATIONS_DESCRIPTOR) {
                for (el0 in input.statisticsConfigurations) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeMetricStreamStatisticsConfigurationDocument))
                }
            }
        }
        if (input.tags != null) {
            listField(TAGS_DESCRIPTOR) {
                for (el0 in input.tags) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagDocument))
                }
            }
        }
    }
    return serializer.toByteArray()
}
