// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeartifact

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.codeartifact.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.codeartifact.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * CodeArtifact is a fully managed artifact repository compatible with language-native package managers and build tools such as npm, Apache Maven, pip, and dotnet. You can use CodeArtifact to share packages with development teams and pull packages. Packages can be pulled from both public and CodeArtifact repositories. You can also create an upstream relationship between a CodeArtifact repository and another repository, which effectively merges their contents from the point of view of a package manager client.
 *
 * **CodeArtifact Components**
 *
 * Use the information in this guide to help you work with the following CodeArtifact components:
 * + **Repository**: A CodeArtifact repository contains a set of [package versions](https://docs.aws.amazon.com/codeartifact/latest/ug/welcome.html#welcome-concepts-package-version), each of which maps to a set of assets, or files. Repositories are polyglot, so a single repository can contain packages of any supported type. Each repository exposes endpoints for fetching and publishing packages using tools like the **`npm`** CLI, the Maven CLI (**`mvn`**), Python CLIs (**`pip`** and `twine`), and NuGet CLIs (`nuget` and `dotnet`).
 * + **Domain**: Repositories are aggregated into a higher-level entity known as a *domain*. All package assets and metadata are stored in the domain, but are consumed through repositories. A given package asset, such as a Maven JAR file, is stored once per domain, no matter how many repositories it's present in. All of the assets and metadata in a domain are encrypted with the same customer master key (CMK) stored in Key Management Service (KMS).Each repository is a member of a single domain and can't be moved to a different domain.The domain allows organizational policy to be applied across multiple repositories, such as which accounts can access repositories in the domain, and which public repositories can be used as sources of packages.Although an organization can have multiple domains, we recommend a single production domain that contains all published artifacts so that teams can find and share packages across their organization.
 * + **Package**: A *package* is a bundle of software and the metadata required to resolve dependencies and install the software. CodeArtifact supports [npm](https://docs.aws.amazon.com/codeartifact/latest/ug/using-npm.html), [PyPI](https://docs.aws.amazon.com/codeartifact/latest/ug/using-python.html), [Maven](https://docs.aws.amazon.com/codeartifact/latest/ug/using-maven), and [NuGet](https://docs.aws.amazon.com/codeartifact/latest/ug/using-nuget) package formats.In CodeArtifact, a package consists of:
 *    + A *name* (for example, `webpack` is the name of a popular npm package)
 *    + An optional namespace (for example, `@types` in `@types/node`)
 *    + A set of versions (for example, `1.0.0`, `1.0.1`, `1.0.2`, etc.)
 *    +  Package-level metadata (for example, npm tags)
 * + **Package version**: A version of a package, such as `@types/node 12.6.9`. The version number format and semantics vary for different package formats. For example, npm package versions must conform to the [Semantic Versioning specification](https://semver.org/). In CodeArtifact, a package version consists of the version identifier, metadata at the package version level, and a set of assets.
 * + **Upstream repository**: One repository is *upstream* of another when the package versions in it can be accessed from the repository endpoint of the downstream repository, effectively merging the contents of the two repositories from the point of view of a client. CodeArtifact allows creating an upstream relationship between two repositories.
 * + **Asset**: An individual file stored in CodeArtifact associated with a package version, such as an npm `.tgz` file or Maven POM and JAR files.
 *
 * CodeArtifact supports these operations:
 * + `AssociateExternalConnection`: Adds an existing external connection to a repository.
 * + `CopyPackageVersions`: Copies package versions from one repository to another repository in the same domain.
 * + `CreateDomain`: Creates a domain
 * + `CreateRepository`: Creates a CodeArtifact repository in a domain.
 * + `DeleteDomain`: Deletes a domain. You cannot delete a domain that contains repositories.
 * + `DeleteDomainPermissionsPolicy`: Deletes the resource policy that is set on a domain.
 * + `DeletePackageVersions`: Deletes versions of a package. After a package has been deleted, it can be republished, but its assets and metadata cannot be restored because they have been permanently removed from storage.
 * + `DeleteRepository`: Deletes a repository.
 * + `DeleteRepositoryPermissionsPolicy`: Deletes the resource policy that is set on a repository.
 * + `DescribeDomain`: Returns a `DomainDescription` object that contains information about the requested domain.
 * + `DescribePackageVersion`: Returns a [PackageVersionDescription](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionDescription.html) object that contains details about a package version.
 * + `DescribeRepository`: Returns a `RepositoryDescription` object that contains detailed information about the requested repository.
 * + `DisposePackageVersions`: Disposes versions of a package. A package version with the status `Disposed` cannot be restored because they have been permanently removed from storage.
 * + `DisassociateExternalConnection`: Removes an existing external connection from a repository.
 * + `GetAuthorizationToken`: Generates a temporary authorization token for accessing repositories in the domain. The token expires the authorization period has passed. The default authorization period is 12 hours and can be customized to any length with a maximum of 12 hours.
 * + `GetDomainPermissionsPolicy`: Returns the policy of a resource that is attached to the specified domain.
 * + `GetPackageVersionAsset`: Returns the contents of an asset that is in a package version.
 * + `GetPackageVersionReadme`: Gets the readme file or descriptive text for a package version.
 * + `GetRepositoryEndpoint`: Returns the endpoint of a repository for a specific package format. A repository has one endpoint for each package format:
 *    + `maven`
 *    + `npm`
 *    + `nuget`
 *    + `pypi`
 * + `GetRepositoryPermissionsPolicy`: Returns the resource policy that is set on a repository.
 * + `ListDomains`: Returns a list of `DomainSummary` objects. Each returned `DomainSummary` object contains information about a domain.
 * + `ListPackages`: Lists the packages in a repository.
 * + `ListPackageVersionAssets`: Lists the assets for a given package version.
 * + `ListPackageVersionDependencies`: Returns a list of the direct dependencies for a package version.
 * + `ListPackageVersions`: Returns a list of package versions for a specified package in a repository.
 * + `ListRepositories`: Returns a list of repositories owned by the Amazon Web Services account that called this method.
 * + `ListRepositoriesInDomain`: Returns a list of the repositories in a domain.
 * + `PutDomainPermissionsPolicy`: Attaches a resource policy to a domain.
 * + `PutRepositoryPermissionsPolicy`: Sets the resource policy on a repository that specifies permissions to access it.
 * + `UpdatePackageVersionsStatus`: Updates the status of one or more versions of a package.
 * + `UpdateRepository`: Updates the properties of a repository.
 */
interface CodeartifactClient : SdkClient {

    override val serviceName: String
        get() = "codeartifact"
    /**
     * CodeartifactClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): CodeartifactClient {
            val config = Config.Builder().apply(block).build()
            return DefaultCodeartifactClient(config)
        }

        operator fun invoke(config: Config): CodeartifactClient = DefaultCodeartifactClient(config)

        /**
         * Construct a [CodeartifactClient] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): CodeartifactClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultCodeartifactClient(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Adds an existing external connection to a repository. One external connection is allowed per repository.
     *
     * A repository can have one or more upstream repositories, or an external connection.
     */
    suspend fun associateExternalConnection(input: AssociateExternalConnectionRequest): AssociateExternalConnectionResponse

    /**
     * Adds an existing external connection to a repository. One external connection is allowed per repository.
     *
     * A repository can have one or more upstream repositories, or an external connection.
     */
    suspend fun associateExternalConnection(block: AssociateExternalConnectionRequest.Builder.() -> Unit) = associateExternalConnection(AssociateExternalConnectionRequest.Builder().apply(block).build())

    /**
     * Copies package versions from one repository to another repository in the same domain.
     *
     *  You must specify `versions` or `versionRevisions`. You cannot specify both.
     */
    suspend fun copyPackageVersions(input: CopyPackageVersionsRequest): CopyPackageVersionsResponse

    /**
     * Copies package versions from one repository to another repository in the same domain.
     *
     *  You must specify `versions` or `versionRevisions`. You cannot specify both.
     */
    suspend fun copyPackageVersions(block: CopyPackageVersionsRequest.Builder.() -> Unit) = copyPackageVersions(CopyPackageVersionsRequest.Builder().apply(block).build())

    /**
     * Creates a domain. CodeArtifact *domains* make it easier to manage multiple repositories across an organization. You can use a domain to apply permissions across many repositories owned by different Amazon Web Services accounts. An asset is stored only once in a domain, even if it's in multiple repositories.
     *
     * Although you can have multiple domains, we recommend a single production domain that contains all published artifacts so that your development teams can find and share packages. You can use a second pre-production domain to test changes to the production domain configuration.
     */
    suspend fun createDomain(input: CreateDomainRequest): CreateDomainResponse

    /**
     * Creates a domain. CodeArtifact *domains* make it easier to manage multiple repositories across an organization. You can use a domain to apply permissions across many repositories owned by different Amazon Web Services accounts. An asset is stored only once in a domain, even if it's in multiple repositories.
     *
     * Although you can have multiple domains, we recommend a single production domain that contains all published artifacts so that your development teams can find and share packages. You can use a second pre-production domain to test changes to the production domain configuration.
     */
    suspend fun createDomain(block: CreateDomainRequest.Builder.() -> Unit) = createDomain(CreateDomainRequest.Builder().apply(block).build())

    /**
     * Creates a repository.
     */
    suspend fun createRepository(input: CreateRepositoryRequest): CreateRepositoryResponse

    /**
     * Creates a repository.
     */
    suspend fun createRepository(block: CreateRepositoryRequest.Builder.() -> Unit) = createRepository(CreateRepositoryRequest.Builder().apply(block).build())

    /**
     * Deletes a domain. You cannot delete a domain that contains repositories. If you want to delete a domain with repositories, first delete its repositories.
     */
    suspend fun deleteDomain(input: DeleteDomainRequest): DeleteDomainResponse

    /**
     * Deletes a domain. You cannot delete a domain that contains repositories. If you want to delete a domain with repositories, first delete its repositories.
     */
    suspend fun deleteDomain(block: DeleteDomainRequest.Builder.() -> Unit) = deleteDomain(DeleteDomainRequest.Builder().apply(block).build())

    /**
     * Deletes the resource policy set on a domain.
     */
    suspend fun deleteDomainPermissionsPolicy(input: DeleteDomainPermissionsPolicyRequest): DeleteDomainPermissionsPolicyResponse

    /**
     * Deletes the resource policy set on a domain.
     */
    suspend fun deleteDomainPermissionsPolicy(block: DeleteDomainPermissionsPolicyRequest.Builder.() -> Unit) = deleteDomainPermissionsPolicy(DeleteDomainPermissionsPolicyRequest.Builder().apply(block).build())

    /**
     * Deletes one or more versions of a package. A deleted package version cannot be restored in your repository. If you want to remove a package version from your repository and be able to restore it later, set its status to `Archived`. Archived packages cannot be downloaded from a repository and don't show up with list package APIs (for example, [ListackageVersions](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_ListPackageVersions.html)), but you can restore them using [UpdatePackageVersionsStatus](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_UpdatePackageVersionsStatus.html).
     */
    suspend fun deletePackageVersions(input: DeletePackageVersionsRequest): DeletePackageVersionsResponse

    /**
     * Deletes one or more versions of a package. A deleted package version cannot be restored in your repository. If you want to remove a package version from your repository and be able to restore it later, set its status to `Archived`. Archived packages cannot be downloaded from a repository and don't show up with list package APIs (for example, [ListackageVersions](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_ListPackageVersions.html)), but you can restore them using [UpdatePackageVersionsStatus](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_UpdatePackageVersionsStatus.html).
     */
    suspend fun deletePackageVersions(block: DeletePackageVersionsRequest.Builder.() -> Unit) = deletePackageVersions(DeletePackageVersionsRequest.Builder().apply(block).build())

    /**
     * Deletes a repository.
     */
    suspend fun deleteRepository(input: DeleteRepositoryRequest): DeleteRepositoryResponse

    /**
     * Deletes a repository.
     */
    suspend fun deleteRepository(block: DeleteRepositoryRequest.Builder.() -> Unit) = deleteRepository(DeleteRepositoryRequest.Builder().apply(block).build())

    /**
     * Deletes the resource policy that is set on a repository. After a resource policy is deleted, the permissions allowed and denied by the deleted policy are removed. The effect of deleting a resource policy might not be immediate.
     *
     *  Use `DeleteRepositoryPermissionsPolicy` with caution. After a policy is deleted, Amazon Web Services users, roles, and accounts lose permissions to perform the repository actions granted by the deleted policy.
     */
    suspend fun deleteRepositoryPermissionsPolicy(input: DeleteRepositoryPermissionsPolicyRequest): DeleteRepositoryPermissionsPolicyResponse

    /**
     * Deletes the resource policy that is set on a repository. After a resource policy is deleted, the permissions allowed and denied by the deleted policy are removed. The effect of deleting a resource policy might not be immediate.
     *
     *  Use `DeleteRepositoryPermissionsPolicy` with caution. After a policy is deleted, Amazon Web Services users, roles, and accounts lose permissions to perform the repository actions granted by the deleted policy.
     */
    suspend fun deleteRepositoryPermissionsPolicy(block: DeleteRepositoryPermissionsPolicyRequest.Builder.() -> Unit) = deleteRepositoryPermissionsPolicy(DeleteRepositoryPermissionsPolicyRequest.Builder().apply(block).build())

    /**
     * Returns a [DomainDescription](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_DomainDescription.html) object that contains information about the requested domain.
     */
    suspend fun describeDomain(input: DescribeDomainRequest): DescribeDomainResponse

    /**
     * Returns a [DomainDescription](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_DomainDescription.html) object that contains information about the requested domain.
     */
    suspend fun describeDomain(block: DescribeDomainRequest.Builder.() -> Unit) = describeDomain(DescribeDomainRequest.Builder().apply(block).build())

    /**
     * Returns a [PackageVersionDescription](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionDescription.html) object that contains information about the requested package version.
     */
    suspend fun describePackageVersion(input: DescribePackageVersionRequest): DescribePackageVersionResponse

    /**
     * Returns a [PackageVersionDescription](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionDescription.html) object that contains information about the requested package version.
     */
    suspend fun describePackageVersion(block: DescribePackageVersionRequest.Builder.() -> Unit) = describePackageVersion(DescribePackageVersionRequest.Builder().apply(block).build())

    /**
     * Returns a `RepositoryDescription` object that contains detailed information about the requested repository.
     */
    suspend fun describeRepository(input: DescribeRepositoryRequest): DescribeRepositoryResponse

    /**
     * Returns a `RepositoryDescription` object that contains detailed information about the requested repository.
     */
    suspend fun describeRepository(block: DescribeRepositoryRequest.Builder.() -> Unit) = describeRepository(DescribeRepositoryRequest.Builder().apply(block).build())

    /**
     * Removes an existing external connection from a repository.
     */
    suspend fun disassociateExternalConnection(input: DisassociateExternalConnectionRequest): DisassociateExternalConnectionResponse

    /**
     * Removes an existing external connection from a repository.
     */
    suspend fun disassociateExternalConnection(block: DisassociateExternalConnectionRequest.Builder.() -> Unit) = disassociateExternalConnection(DisassociateExternalConnectionRequest.Builder().apply(block).build())

    /**
     * Deletes the assets in package versions and sets the package versions' status to `Disposed`. A disposed package version cannot be restored in your repository because its assets are deleted.
     *
     *  To view all disposed package versions in a repository, use [ListPackageVersions](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_ListPackageVersions.html) and set the [status](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_ListPackageVersions.html#API_ListPackageVersions_RequestSyntax) parameter to `Disposed`.
     *
     *  To view information about a disposed package version, use [DescribePackageVersion](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_DescribePackageVersion.html).
     */
    suspend fun disposePackageVersions(input: DisposePackageVersionsRequest): DisposePackageVersionsResponse

    /**
     * Deletes the assets in package versions and sets the package versions' status to `Disposed`. A disposed package version cannot be restored in your repository because its assets are deleted.
     *
     *  To view all disposed package versions in a repository, use [ListPackageVersions](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_ListPackageVersions.html) and set the [status](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_ListPackageVersions.html#API_ListPackageVersions_RequestSyntax) parameter to `Disposed`.
     *
     *  To view information about a disposed package version, use [DescribePackageVersion](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_DescribePackageVersion.html).
     */
    suspend fun disposePackageVersions(block: DisposePackageVersionsRequest.Builder.() -> Unit) = disposePackageVersions(DisposePackageVersionsRequest.Builder().apply(block).build())

    /**
     * Generates a temporary authorization token for accessing repositories in the domain. This API requires the `codeartifact:GetAuthorizationToken` and `sts:GetServiceBearerToken` permissions. For more information about authorization tokens, see [CodeArtifact authentication and tokens](https://docs.aws.amazon.com/codeartifact/latest/ug/tokens-authentication.html).
     *
     * CodeArtifact authorization tokens are valid for a period of 12 hours when created with the `login` command. You can call `login` periodically to refresh the token. When you create an authorization token with the `GetAuthorizationToken` API, you can set a custom authorization period, up to a maximum of 12 hours, with the `durationSeconds` parameter.
     *
     * The authorization period begins after `login` or `GetAuthorizationToken` is called. If `login` or `GetAuthorizationToken` is called while assuming a role, the token lifetime is independent of the maximum session duration of the role. For example, if you call `sts assume-role` and specify a session duration of 15 minutes, then generate a CodeArtifact authorization token, the token will be valid for the full authorization period even though this is longer than the 15-minute session duration.
     *
     * See [Using IAM Roles](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use.html) for more information on controlling session duration.
     */
    suspend fun getAuthorizationToken(input: GetAuthorizationTokenRequest): GetAuthorizationTokenResponse

    /**
     * Generates a temporary authorization token for accessing repositories in the domain. This API requires the `codeartifact:GetAuthorizationToken` and `sts:GetServiceBearerToken` permissions. For more information about authorization tokens, see [CodeArtifact authentication and tokens](https://docs.aws.amazon.com/codeartifact/latest/ug/tokens-authentication.html).
     *
     * CodeArtifact authorization tokens are valid for a period of 12 hours when created with the `login` command. You can call `login` periodically to refresh the token. When you create an authorization token with the `GetAuthorizationToken` API, you can set a custom authorization period, up to a maximum of 12 hours, with the `durationSeconds` parameter.
     *
     * The authorization period begins after `login` or `GetAuthorizationToken` is called. If `login` or `GetAuthorizationToken` is called while assuming a role, the token lifetime is independent of the maximum session duration of the role. For example, if you call `sts assume-role` and specify a session duration of 15 minutes, then generate a CodeArtifact authorization token, the token will be valid for the full authorization period even though this is longer than the 15-minute session duration.
     *
     * See [Using IAM Roles](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use.html) for more information on controlling session duration.
     */
    suspend fun getAuthorizationToken(block: GetAuthorizationTokenRequest.Builder.() -> Unit) = getAuthorizationToken(GetAuthorizationTokenRequest.Builder().apply(block).build())

    /**
     * Returns the resource policy attached to the specified domain.
     *
     *  The policy is a resource-based policy, not an identity-based policy. For more information, see [Identity-based policies and resource-based policies ](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_identity-vs-resource.html) in the *IAM User Guide*.
     */
    suspend fun getDomainPermissionsPolicy(input: GetDomainPermissionsPolicyRequest): GetDomainPermissionsPolicyResponse

    /**
     * Returns the resource policy attached to the specified domain.
     *
     *  The policy is a resource-based policy, not an identity-based policy. For more information, see [Identity-based policies and resource-based policies ](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_identity-vs-resource.html) in the *IAM User Guide*.
     */
    suspend fun getDomainPermissionsPolicy(block: GetDomainPermissionsPolicyRequest.Builder.() -> Unit) = getDomainPermissionsPolicy(GetDomainPermissionsPolicyRequest.Builder().apply(block).build())

    /**
     * Returns an asset (or file) that is in a package. For example, for a Maven package version, use `GetPackageVersionAsset` to download a `JAR` file, a `POM` file, or any other assets in the package version.
     */
    suspend fun <T> getPackageVersionAsset(input: GetPackageVersionAssetRequest, block: suspend (GetPackageVersionAssetResponse) -> T): T

    /**
     * Gets the readme file or descriptive text for a package version.
     *
     *  The returned text might contain formatting. For example, it might contain formatting for Markdown or reStructuredText.
     */
    suspend fun getPackageVersionReadme(input: GetPackageVersionReadmeRequest): GetPackageVersionReadmeResponse

    /**
     * Gets the readme file or descriptive text for a package version.
     *
     *  The returned text might contain formatting. For example, it might contain formatting for Markdown or reStructuredText.
     */
    suspend fun getPackageVersionReadme(block: GetPackageVersionReadmeRequest.Builder.() -> Unit) = getPackageVersionReadme(GetPackageVersionReadmeRequest.Builder().apply(block).build())

    /**
     * Returns the endpoint of a repository for a specific package format. A repository has one endpoint for each package format:
     * + `maven`
     * + `npm`
     * + `nuget`
     * + `pypi`
     */
    suspend fun getRepositoryEndpoint(input: GetRepositoryEndpointRequest): GetRepositoryEndpointResponse

    /**
     * Returns the endpoint of a repository for a specific package format. A repository has one endpoint for each package format:
     * + `maven`
     * + `npm`
     * + `nuget`
     * + `pypi`
     */
    suspend fun getRepositoryEndpoint(block: GetRepositoryEndpointRequest.Builder.() -> Unit) = getRepositoryEndpoint(GetRepositoryEndpointRequest.Builder().apply(block).build())

    /**
     * Returns the resource policy that is set on a repository.
     */
    suspend fun getRepositoryPermissionsPolicy(input: GetRepositoryPermissionsPolicyRequest): GetRepositoryPermissionsPolicyResponse

    /**
     * Returns the resource policy that is set on a repository.
     */
    suspend fun getRepositoryPermissionsPolicy(block: GetRepositoryPermissionsPolicyRequest.Builder.() -> Unit) = getRepositoryPermissionsPolicy(GetRepositoryPermissionsPolicyRequest.Builder().apply(block).build())

    /**
     * Returns a list of [DomainSummary](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionDescription.html) objects for all domains owned by the Amazon Web Services account that makes this call. Each returned `DomainSummary` object contains information about a domain.
     */
    suspend fun listDomains(input: ListDomainsRequest = ListDomainsRequest {}): ListDomainsResponse

    /**
     * Returns a list of [DomainSummary](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionDescription.html) objects for all domains owned by the Amazon Web Services account that makes this call. Each returned `DomainSummary` object contains information about a domain.
     */
    suspend fun listDomains(block: ListDomainsRequest.Builder.() -> Unit) = listDomains(ListDomainsRequest.Builder().apply(block).build())

    /**
     * Returns a list of [AssetSummary](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_AssetSummary.html) objects for assets in a package version.
     */
    suspend fun listPackageVersionAssets(input: ListPackageVersionAssetsRequest): ListPackageVersionAssetsResponse

    /**
     * Returns a list of [AssetSummary](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_AssetSummary.html) objects for assets in a package version.
     */
    suspend fun listPackageVersionAssets(block: ListPackageVersionAssetsRequest.Builder.() -> Unit) = listPackageVersionAssets(ListPackageVersionAssetsRequest.Builder().apply(block).build())

    /**
     * Returns the direct dependencies for a package version. The dependencies are returned as [PackageDependency](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageDependency.html) objects. CodeArtifact extracts the dependencies for a package version from the metadata file for the package format (for example, the `package.json` file for npm packages and the `pom.xml` file for Maven). Any package version dependencies that are not listed in the configuration file are not returned.
     */
    suspend fun listPackageVersionDependencies(input: ListPackageVersionDependenciesRequest): ListPackageVersionDependenciesResponse

    /**
     * Returns the direct dependencies for a package version. The dependencies are returned as [PackageDependency](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageDependency.html) objects. CodeArtifact extracts the dependencies for a package version from the metadata file for the package format (for example, the `package.json` file for npm packages and the `pom.xml` file for Maven). Any package version dependencies that are not listed in the configuration file are not returned.
     */
    suspend fun listPackageVersionDependencies(block: ListPackageVersionDependenciesRequest.Builder.() -> Unit) = listPackageVersionDependencies(ListPackageVersionDependenciesRequest.Builder().apply(block).build())

    /**
     * Returns a list of [PackageVersionSummary](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionSummary.html) objects for package versions in a repository that match the request parameters.
     */
    suspend fun listPackageVersions(input: ListPackageVersionsRequest): ListPackageVersionsResponse

    /**
     * Returns a list of [PackageVersionSummary](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionSummary.html) objects for package versions in a repository that match the request parameters.
     */
    suspend fun listPackageVersions(block: ListPackageVersionsRequest.Builder.() -> Unit) = listPackageVersions(ListPackageVersionsRequest.Builder().apply(block).build())

    /**
     * Returns a list of [PackageSummary](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageSummary.html) objects for packages in a repository that match the request parameters.
     */
    suspend fun listPackages(input: ListPackagesRequest): ListPackagesResponse

    /**
     * Returns a list of [PackageSummary](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageSummary.html) objects for packages in a repository that match the request parameters.
     */
    suspend fun listPackages(block: ListPackagesRequest.Builder.() -> Unit) = listPackages(ListPackagesRequest.Builder().apply(block).build())

    /**
     * Returns a list of [RepositorySummary](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_RepositorySummary.html) objects. Each `RepositorySummary` contains information about a repository in the specified Amazon Web Services account and that matches the input parameters.
     */
    suspend fun listRepositories(input: ListRepositoriesRequest = ListRepositoriesRequest {}): ListRepositoriesResponse

    /**
     * Returns a list of [RepositorySummary](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_RepositorySummary.html) objects. Each `RepositorySummary` contains information about a repository in the specified Amazon Web Services account and that matches the input parameters.
     */
    suspend fun listRepositories(block: ListRepositoriesRequest.Builder.() -> Unit) = listRepositories(ListRepositoriesRequest.Builder().apply(block).build())

    /**
     * Returns a list of [RepositorySummary](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_RepositorySummary.html) objects. Each `RepositorySummary` contains information about a repository in the specified domain and that matches the input parameters.
     */
    suspend fun listRepositoriesInDomain(input: ListRepositoriesInDomainRequest): ListRepositoriesInDomainResponse

    /**
     * Returns a list of [RepositorySummary](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_RepositorySummary.html) objects. Each `RepositorySummary` contains information about a repository in the specified domain and that matches the input parameters.
     */
    suspend fun listRepositoriesInDomain(block: ListRepositoriesInDomainRequest.Builder.() -> Unit) = listRepositoriesInDomain(ListRepositoriesInDomainRequest.Builder().apply(block).build())

    /**
     * Gets information about Amazon Web Services tags for a specified Amazon Resource Name (ARN) in CodeArtifact.
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Gets information about Amazon Web Services tags for a specified Amazon Resource Name (ARN) in CodeArtifact.
     */
    suspend fun listTagsForResource(block: ListTagsForResourceRequest.Builder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

    /**
     * Sets a resource policy on a domain that specifies permissions to access it.
     *
     *  When you call `PutDomainPermissionsPolicy`, the resource policy on the domain is ignored when evaluting permissions. This ensures that the owner of a domain cannot lock themselves out of the domain, which would prevent them from being able to update the resource policy.
     */
    suspend fun putDomainPermissionsPolicy(input: PutDomainPermissionsPolicyRequest): PutDomainPermissionsPolicyResponse

    /**
     * Sets a resource policy on a domain that specifies permissions to access it.
     *
     *  When you call `PutDomainPermissionsPolicy`, the resource policy on the domain is ignored when evaluting permissions. This ensures that the owner of a domain cannot lock themselves out of the domain, which would prevent them from being able to update the resource policy.
     */
    suspend fun putDomainPermissionsPolicy(block: PutDomainPermissionsPolicyRequest.Builder.() -> Unit) = putDomainPermissionsPolicy(PutDomainPermissionsPolicyRequest.Builder().apply(block).build())

    /**
     * Sets the resource policy on a repository that specifies permissions to access it.
     *
     *  When you call `PutRepositoryPermissionsPolicy`, the resource policy on the repository is ignored when evaluting permissions. This ensures that the owner of a repository cannot lock themselves out of the repository, which would prevent them from being able to update the resource policy.
     */
    suspend fun putRepositoryPermissionsPolicy(input: PutRepositoryPermissionsPolicyRequest): PutRepositoryPermissionsPolicyResponse

    /**
     * Sets the resource policy on a repository that specifies permissions to access it.
     *
     *  When you call `PutRepositoryPermissionsPolicy`, the resource policy on the repository is ignored when evaluting permissions. This ensures that the owner of a repository cannot lock themselves out of the repository, which would prevent them from being able to update the resource policy.
     */
    suspend fun putRepositoryPermissionsPolicy(block: PutRepositoryPermissionsPolicyRequest.Builder.() -> Unit) = putRepositoryPermissionsPolicy(PutRepositoryPermissionsPolicyRequest.Builder().apply(block).build())

    /**
     * Adds or updates tags for a resource in CodeArtifact.
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Adds or updates tags for a resource in CodeArtifact.
     */
    suspend fun tagResource(block: TagResourceRequest.Builder.() -> Unit) = tagResource(TagResourceRequest.Builder().apply(block).build())

    /**
     * Removes tags from a resource in CodeArtifact.
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Removes tags from a resource in CodeArtifact.
     */
    suspend fun untagResource(block: UntagResourceRequest.Builder.() -> Unit) = untagResource(UntagResourceRequest.Builder().apply(block).build())

    /**
     * Updates the status of one or more versions of a package. Using `UpdatePackageVersionsStatus`, you can update the status of package versions to `Archived`, `Published`, or `Unlisted`. To set the status of a package version to `Disposed`, use [DisposePackageVersions](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_DisposePackageVersions.html).
     */
    suspend fun updatePackageVersionsStatus(input: UpdatePackageVersionsStatusRequest): UpdatePackageVersionsStatusResponse

    /**
     * Updates the status of one or more versions of a package. Using `UpdatePackageVersionsStatus`, you can update the status of package versions to `Archived`, `Published`, or `Unlisted`. To set the status of a package version to `Disposed`, use [DisposePackageVersions](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_DisposePackageVersions.html).
     */
    suspend fun updatePackageVersionsStatus(block: UpdatePackageVersionsStatusRequest.Builder.() -> Unit) = updatePackageVersionsStatus(UpdatePackageVersionsStatusRequest.Builder().apply(block).build())

    /**
     * Update the properties of a repository.
     */
    suspend fun updateRepository(input: UpdateRepositoryRequest): UpdateRepositoryResponse

    /**
     * Update the properties of a repository.
     */
    suspend fun updateRepository(block: UpdateRepositoryRequest.Builder.() -> Unit) = updateRepository(UpdateRepositoryRequest.Builder().apply(block).build())
}
