// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeartifact

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.codeartifact.model.*
import aws.sdk.kotlin.services.codeartifact.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.execute
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "codeartifact"
const val ServiceApiVersion: String = "2018-09-22"
const val SdkVersion: String = "0.16.3-beta"

internal class DefaultCodeartifactClient(override val config: CodeartifactClient.Config) : CodeartifactClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Adds an existing external connection to a repository. One external connection is allowed per repository.
     *
     * A repository can have one or more upstream repositories, or an external connection.
     */
    override suspend fun associateExternalConnection(input: AssociateExternalConnectionRequest): AssociateExternalConnectionResponse {
        val op = SdkHttpOperation.build<AssociateExternalConnectionRequest, AssociateExternalConnectionResponse> {
            serializer = AssociateExternalConnectionOperationSerializer()
            deserializer = AssociateExternalConnectionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociateExternalConnection"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codeartifact"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Copies package versions from one repository to another repository in the same domain.
     *
     *  You must specify `versions` or `versionRevisions`. You cannot specify both.
     */
    override suspend fun copyPackageVersions(input: CopyPackageVersionsRequest): CopyPackageVersionsResponse {
        val op = SdkHttpOperation.build<CopyPackageVersionsRequest, CopyPackageVersionsResponse> {
            serializer = CopyPackageVersionsOperationSerializer()
            deserializer = CopyPackageVersionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CopyPackageVersions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codeartifact"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a domain. CodeArtifact *domains* make it easier to manage multiple repositories across an organization. You can use a domain to apply permissions across many repositories owned by different Amazon Web Services accounts. An asset is stored only once in a domain, even if it's in multiple repositories.
     *
     * Although you can have multiple domains, we recommend a single production domain that contains all published artifacts so that your development teams can find and share packages. You can use a second pre-production domain to test changes to the production domain configuration.
     */
    override suspend fun createDomain(input: CreateDomainRequest): CreateDomainResponse {
        val op = SdkHttpOperation.build<CreateDomainRequest, CreateDomainResponse> {
            serializer = CreateDomainOperationSerializer()
            deserializer = CreateDomainOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateDomain"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codeartifact"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a repository.
     */
    override suspend fun createRepository(input: CreateRepositoryRequest): CreateRepositoryResponse {
        val op = SdkHttpOperation.build<CreateRepositoryRequest, CreateRepositoryResponse> {
            serializer = CreateRepositoryOperationSerializer()
            deserializer = CreateRepositoryOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateRepository"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codeartifact"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a domain. You cannot delete a domain that contains repositories. If you want to delete a domain with repositories, first delete its repositories.
     */
    override suspend fun deleteDomain(input: DeleteDomainRequest): DeleteDomainResponse {
        val op = SdkHttpOperation.build<DeleteDomainRequest, DeleteDomainResponse> {
            serializer = DeleteDomainOperationSerializer()
            deserializer = DeleteDomainOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteDomain"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codeartifact"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the resource policy set on a domain.
     */
    override suspend fun deleteDomainPermissionsPolicy(input: DeleteDomainPermissionsPolicyRequest): DeleteDomainPermissionsPolicyResponse {
        val op = SdkHttpOperation.build<DeleteDomainPermissionsPolicyRequest, DeleteDomainPermissionsPolicyResponse> {
            serializer = DeleteDomainPermissionsPolicyOperationSerializer()
            deserializer = DeleteDomainPermissionsPolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteDomainPermissionsPolicy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codeartifact"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes one or more versions of a package. A deleted package version cannot be restored in your repository. If you want to remove a package version from your repository and be able to restore it later, set its status to `Archived`. Archived packages cannot be downloaded from a repository and don't show up with list package APIs (for example, [ListackageVersions](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_ListPackageVersions.html)), but you can restore them using [UpdatePackageVersionsStatus](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_UpdatePackageVersionsStatus.html).
     */
    override suspend fun deletePackageVersions(input: DeletePackageVersionsRequest): DeletePackageVersionsResponse {
        val op = SdkHttpOperation.build<DeletePackageVersionsRequest, DeletePackageVersionsResponse> {
            serializer = DeletePackageVersionsOperationSerializer()
            deserializer = DeletePackageVersionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeletePackageVersions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codeartifact"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a repository.
     */
    override suspend fun deleteRepository(input: DeleteRepositoryRequest): DeleteRepositoryResponse {
        val op = SdkHttpOperation.build<DeleteRepositoryRequest, DeleteRepositoryResponse> {
            serializer = DeleteRepositoryOperationSerializer()
            deserializer = DeleteRepositoryOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteRepository"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codeartifact"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the resource policy that is set on a repository. After a resource policy is deleted, the permissions allowed and denied by the deleted policy are removed. The effect of deleting a resource policy might not be immediate.
     *
     *  Use `DeleteRepositoryPermissionsPolicy` with caution. After a policy is deleted, Amazon Web Services users, roles, and accounts lose permissions to perform the repository actions granted by the deleted policy.
     */
    override suspend fun deleteRepositoryPermissionsPolicy(input: DeleteRepositoryPermissionsPolicyRequest): DeleteRepositoryPermissionsPolicyResponse {
        val op = SdkHttpOperation.build<DeleteRepositoryPermissionsPolicyRequest, DeleteRepositoryPermissionsPolicyResponse> {
            serializer = DeleteRepositoryPermissionsPolicyOperationSerializer()
            deserializer = DeleteRepositoryPermissionsPolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteRepositoryPermissionsPolicy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codeartifact"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a [DomainDescription](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_DomainDescription.html) object that contains information about the requested domain.
     */
    override suspend fun describeDomain(input: DescribeDomainRequest): DescribeDomainResponse {
        val op = SdkHttpOperation.build<DescribeDomainRequest, DescribeDomainResponse> {
            serializer = DescribeDomainOperationSerializer()
            deserializer = DescribeDomainOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeDomain"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codeartifact"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a [PackageVersionDescription](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionDescription.html) object that contains information about the requested package version.
     */
    override suspend fun describePackageVersion(input: DescribePackageVersionRequest): DescribePackageVersionResponse {
        val op = SdkHttpOperation.build<DescribePackageVersionRequest, DescribePackageVersionResponse> {
            serializer = DescribePackageVersionOperationSerializer()
            deserializer = DescribePackageVersionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribePackageVersion"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codeartifact"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a `RepositoryDescription` object that contains detailed information about the requested repository.
     */
    override suspend fun describeRepository(input: DescribeRepositoryRequest): DescribeRepositoryResponse {
        val op = SdkHttpOperation.build<DescribeRepositoryRequest, DescribeRepositoryResponse> {
            serializer = DescribeRepositoryOperationSerializer()
            deserializer = DescribeRepositoryOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeRepository"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codeartifact"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes an existing external connection from a repository.
     */
    override suspend fun disassociateExternalConnection(input: DisassociateExternalConnectionRequest): DisassociateExternalConnectionResponse {
        val op = SdkHttpOperation.build<DisassociateExternalConnectionRequest, DisassociateExternalConnectionResponse> {
            serializer = DisassociateExternalConnectionOperationSerializer()
            deserializer = DisassociateExternalConnectionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociateExternalConnection"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codeartifact"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the assets in package versions and sets the package versions' status to `Disposed`. A disposed package version cannot be restored in your repository because its assets are deleted.
     *
     *  To view all disposed package versions in a repository, use [ListPackageVersions](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_ListPackageVersions.html) and set the [status](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_ListPackageVersions.html#API_ListPackageVersions_RequestSyntax) parameter to `Disposed`.
     *
     *  To view information about a disposed package version, use [DescribePackageVersion](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_DescribePackageVersion.html).
     */
    override suspend fun disposePackageVersions(input: DisposePackageVersionsRequest): DisposePackageVersionsResponse {
        val op = SdkHttpOperation.build<DisposePackageVersionsRequest, DisposePackageVersionsResponse> {
            serializer = DisposePackageVersionsOperationSerializer()
            deserializer = DisposePackageVersionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisposePackageVersions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codeartifact"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Generates a temporary authorization token for accessing repositories in the domain. This API requires the `codeartifact:GetAuthorizationToken` and `sts:GetServiceBearerToken` permissions. For more information about authorization tokens, see [CodeArtifact authentication and tokens](https://docs.aws.amazon.com/codeartifact/latest/ug/tokens-authentication.html).
     *
     * CodeArtifact authorization tokens are valid for a period of 12 hours when created with the `login` command. You can call `login` periodically to refresh the token. When you create an authorization token with the `GetAuthorizationToken` API, you can set a custom authorization period, up to a maximum of 12 hours, with the `durationSeconds` parameter.
     *
     * The authorization period begins after `login` or `GetAuthorizationToken` is called. If `login` or `GetAuthorizationToken` is called while assuming a role, the token lifetime is independent of the maximum session duration of the role. For example, if you call `sts assume-role` and specify a session duration of 15 minutes, then generate a CodeArtifact authorization token, the token will be valid for the full authorization period even though this is longer than the 15-minute session duration.
     *
     * See [Using IAM Roles](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use.html) for more information on controlling session duration.
     */
    override suspend fun getAuthorizationToken(input: GetAuthorizationTokenRequest): GetAuthorizationTokenResponse {
        val op = SdkHttpOperation.build<GetAuthorizationTokenRequest, GetAuthorizationTokenResponse> {
            serializer = GetAuthorizationTokenOperationSerializer()
            deserializer = GetAuthorizationTokenOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetAuthorizationToken"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codeartifact"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the resource policy attached to the specified domain.
     *
     *  The policy is a resource-based policy, not an identity-based policy. For more information, see [Identity-based policies and resource-based policies ](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_identity-vs-resource.html) in the *IAM User Guide*.
     */
    override suspend fun getDomainPermissionsPolicy(input: GetDomainPermissionsPolicyRequest): GetDomainPermissionsPolicyResponse {
        val op = SdkHttpOperation.build<GetDomainPermissionsPolicyRequest, GetDomainPermissionsPolicyResponse> {
            serializer = GetDomainPermissionsPolicyOperationSerializer()
            deserializer = GetDomainPermissionsPolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetDomainPermissionsPolicy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codeartifact"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns an asset (or file) that is in a package. For example, for a Maven package version, use `GetPackageVersionAsset` to download a `JAR` file, a `POM` file, or any other assets in the package version.
     */
    override suspend fun <T> getPackageVersionAsset(input: GetPackageVersionAssetRequest, block: suspend (GetPackageVersionAssetResponse) -> T): T {
        val op = SdkHttpOperation.build<GetPackageVersionAssetRequest, GetPackageVersionAssetResponse> {
            serializer = GetPackageVersionAssetOperationSerializer()
            deserializer = GetPackageVersionAssetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetPackageVersionAsset"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codeartifact"
            }
        )
        return op.execute(client, input, block)
    }

    /**
     * Gets the readme file or descriptive text for a package version.
     *
     *  The returned text might contain formatting. For example, it might contain formatting for Markdown or reStructuredText.
     */
    override suspend fun getPackageVersionReadme(input: GetPackageVersionReadmeRequest): GetPackageVersionReadmeResponse {
        val op = SdkHttpOperation.build<GetPackageVersionReadmeRequest, GetPackageVersionReadmeResponse> {
            serializer = GetPackageVersionReadmeOperationSerializer()
            deserializer = GetPackageVersionReadmeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetPackageVersionReadme"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codeartifact"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the endpoint of a repository for a specific package format. A repository has one endpoint for each package format:
     * + `maven`
     * + `npm`
     * + `nuget`
     * + `pypi`
     */
    override suspend fun getRepositoryEndpoint(input: GetRepositoryEndpointRequest): GetRepositoryEndpointResponse {
        val op = SdkHttpOperation.build<GetRepositoryEndpointRequest, GetRepositoryEndpointResponse> {
            serializer = GetRepositoryEndpointOperationSerializer()
            deserializer = GetRepositoryEndpointOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetRepositoryEndpoint"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codeartifact"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the resource policy that is set on a repository.
     */
    override suspend fun getRepositoryPermissionsPolicy(input: GetRepositoryPermissionsPolicyRequest): GetRepositoryPermissionsPolicyResponse {
        val op = SdkHttpOperation.build<GetRepositoryPermissionsPolicyRequest, GetRepositoryPermissionsPolicyResponse> {
            serializer = GetRepositoryPermissionsPolicyOperationSerializer()
            deserializer = GetRepositoryPermissionsPolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetRepositoryPermissionsPolicy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codeartifact"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of [DomainSummary](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionDescription.html) objects for all domains owned by the Amazon Web Services account that makes this call. Each returned `DomainSummary` object contains information about a domain.
     */
    override suspend fun listDomains(input: ListDomainsRequest): ListDomainsResponse {
        val op = SdkHttpOperation.build<ListDomainsRequest, ListDomainsResponse> {
            serializer = ListDomainsOperationSerializer()
            deserializer = ListDomainsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListDomains"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codeartifact"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of [AssetSummary](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_AssetSummary.html) objects for assets in a package version.
     */
    override suspend fun listPackageVersionAssets(input: ListPackageVersionAssetsRequest): ListPackageVersionAssetsResponse {
        val op = SdkHttpOperation.build<ListPackageVersionAssetsRequest, ListPackageVersionAssetsResponse> {
            serializer = ListPackageVersionAssetsOperationSerializer()
            deserializer = ListPackageVersionAssetsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListPackageVersionAssets"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codeartifact"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the direct dependencies for a package version. The dependencies are returned as [PackageDependency](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageDependency.html) objects. CodeArtifact extracts the dependencies for a package version from the metadata file for the package format (for example, the `package.json` file for npm packages and the `pom.xml` file for Maven). Any package version dependencies that are not listed in the configuration file are not returned.
     */
    override suspend fun listPackageVersionDependencies(input: ListPackageVersionDependenciesRequest): ListPackageVersionDependenciesResponse {
        val op = SdkHttpOperation.build<ListPackageVersionDependenciesRequest, ListPackageVersionDependenciesResponse> {
            serializer = ListPackageVersionDependenciesOperationSerializer()
            deserializer = ListPackageVersionDependenciesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListPackageVersionDependencies"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codeartifact"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of [PackageVersionSummary](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionSummary.html) objects for package versions in a repository that match the request parameters.
     */
    override suspend fun listPackageVersions(input: ListPackageVersionsRequest): ListPackageVersionsResponse {
        val op = SdkHttpOperation.build<ListPackageVersionsRequest, ListPackageVersionsResponse> {
            serializer = ListPackageVersionsOperationSerializer()
            deserializer = ListPackageVersionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListPackageVersions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codeartifact"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of [PackageSummary](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageSummary.html) objects for packages in a repository that match the request parameters.
     */
    override suspend fun listPackages(input: ListPackagesRequest): ListPackagesResponse {
        val op = SdkHttpOperation.build<ListPackagesRequest, ListPackagesResponse> {
            serializer = ListPackagesOperationSerializer()
            deserializer = ListPackagesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListPackages"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codeartifact"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of [RepositorySummary](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_RepositorySummary.html) objects. Each `RepositorySummary` contains information about a repository in the specified Amazon Web Services account and that matches the input parameters.
     */
    override suspend fun listRepositories(input: ListRepositoriesRequest): ListRepositoriesResponse {
        val op = SdkHttpOperation.build<ListRepositoriesRequest, ListRepositoriesResponse> {
            serializer = ListRepositoriesOperationSerializer()
            deserializer = ListRepositoriesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListRepositories"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codeartifact"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of [RepositorySummary](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_RepositorySummary.html) objects. Each `RepositorySummary` contains information about a repository in the specified domain and that matches the input parameters.
     */
    override suspend fun listRepositoriesInDomain(input: ListRepositoriesInDomainRequest): ListRepositoriesInDomainResponse {
        val op = SdkHttpOperation.build<ListRepositoriesInDomainRequest, ListRepositoriesInDomainResponse> {
            serializer = ListRepositoriesInDomainOperationSerializer()
            deserializer = ListRepositoriesInDomainOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListRepositoriesInDomain"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codeartifact"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about Amazon Web Services tags for a specified Amazon Resource Name (ARN) in CodeArtifact.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codeartifact"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Sets a resource policy on a domain that specifies permissions to access it.
     *
     *  When you call `PutDomainPermissionsPolicy`, the resource policy on the domain is ignored when evaluting permissions. This ensures that the owner of a domain cannot lock themselves out of the domain, which would prevent them from being able to update the resource policy.
     */
    override suspend fun putDomainPermissionsPolicy(input: PutDomainPermissionsPolicyRequest): PutDomainPermissionsPolicyResponse {
        val op = SdkHttpOperation.build<PutDomainPermissionsPolicyRequest, PutDomainPermissionsPolicyResponse> {
            serializer = PutDomainPermissionsPolicyOperationSerializer()
            deserializer = PutDomainPermissionsPolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutDomainPermissionsPolicy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codeartifact"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Sets the resource policy on a repository that specifies permissions to access it.
     *
     *  When you call `PutRepositoryPermissionsPolicy`, the resource policy on the repository is ignored when evaluting permissions. This ensures that the owner of a repository cannot lock themselves out of the repository, which would prevent them from being able to update the resource policy.
     */
    override suspend fun putRepositoryPermissionsPolicy(input: PutRepositoryPermissionsPolicyRequest): PutRepositoryPermissionsPolicyResponse {
        val op = SdkHttpOperation.build<PutRepositoryPermissionsPolicyRequest, PutRepositoryPermissionsPolicyResponse> {
            serializer = PutRepositoryPermissionsPolicyOperationSerializer()
            deserializer = PutRepositoryPermissionsPolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutRepositoryPermissionsPolicy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codeartifact"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds or updates tags for a resource in CodeArtifact.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codeartifact"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes tags from a resource in CodeArtifact.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codeartifact"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the status of one or more versions of a package. Using `UpdatePackageVersionsStatus`, you can update the status of package versions to `Archived`, `Published`, or `Unlisted`. To set the status of a package version to `Disposed`, use [DisposePackageVersions](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_DisposePackageVersions.html).
     */
    override suspend fun updatePackageVersionsStatus(input: UpdatePackageVersionsStatusRequest): UpdatePackageVersionsStatusResponse {
        val op = SdkHttpOperation.build<UpdatePackageVersionsStatusRequest, UpdatePackageVersionsStatusResponse> {
            serializer = UpdatePackageVersionsStatusOperationSerializer()
            deserializer = UpdatePackageVersionsStatusOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdatePackageVersionsStatus"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codeartifact"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Update the properties of a repository.
     */
    override suspend fun updateRepository(input: UpdateRepositoryRequest): UpdateRepositoryResponse {
        val op = SdkHttpOperation.build<UpdateRepositoryRequest, UpdateRepositoryResponse> {
            serializer = UpdateRepositoryOperationSerializer()
            deserializer = UpdateRepositoryOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateRepository"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codeartifact"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "codeartifact")
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
