// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeartifact.model



class CopyPackageVersionsRequest private constructor(builder: Builder) {
    /**
     * Set to true to overwrite a package version that already exists in the destination repository. If set to false and the package version already exists in the destination repository, the package version is returned in the `failedVersions` field of the response with an `ALREADY_EXISTS` error code.
     */
    val allowOverwrite: kotlin.Boolean? = builder.allowOverwrite
    /**
     * The name of the repository into which package versions are copied.
     */
    val destinationRepository: kotlin.String? = builder.destinationRepository
    /**
     * The name of the domain that contains the source and destination repositories.
     */
    val domain: kotlin.String? = builder.domain
    /**
     * The 12-digit account number of the Amazon Web Services account that owns the domain. It does not include dashes or spaces.
     */
    val domainOwner: kotlin.String? = builder.domainOwner
    /**
     * The format of the package that is copied.
     */
    val format: aws.sdk.kotlin.services.codeartifact.model.PackageFormat? = builder.format
    /**
     * Set to true to copy packages from repositories that are upstream from the source repository to the destination repository. The default setting is false. For more information, see [Working with upstream repositories](https://docs.aws.amazon.com/codeartifact/latest/ug/repos-upstream.html).
     */
    val includeFromUpstream: kotlin.Boolean? = builder.includeFromUpstream
    /**
     * The namespace of the package. The package component that specifies its namespace depends on its type. For example:
     * +  The namespace of a Maven package is its `groupId`.
     * +  The namespace of an npm package is its `scope`.
     * +  A Python package does not contain a corresponding component, so Python packages do not have a namespace.
     */
    val namespace: kotlin.String? = builder.namespace
    /**
     * The name of the package that is copied.
     */
    val `package`: kotlin.String? = builder.`package`
    /**
     * The name of the repository that contains the package versions to copy.
     */
    val sourceRepository: kotlin.String? = builder.sourceRepository
    /**
     * A list of key-value pairs. The keys are package versions and the values are package version revisions. A `CopyPackageVersion` operation succeeds if the specified versions in the source repository match the specified package version revision.
     *
     *  You must specify `versions` or `versionRevisions`. You cannot specify both.
     */
    val versionRevisions: Map<String, String>? = builder.versionRevisions
    /**
     * The versions of the package to copy.
     *
     *  You must specify `versions` or `versionRevisions`. You cannot specify both.
     */
    val versions: List<String>? = builder.versions

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codeartifact.model.CopyPackageVersionsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CopyPackageVersionsRequest(")
        append("allowOverwrite=$allowOverwrite,")
        append("destinationRepository=$destinationRepository,")
        append("domain=$domain,")
        append("domainOwner=$domainOwner,")
        append("format=$format,")
        append("includeFromUpstream=$includeFromUpstream,")
        append("namespace=$namespace,")
        append("package=$`package`,")
        append("sourceRepository=$sourceRepository,")
        append("versionRevisions=$versionRevisions,")
        append("versions=$versions)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowOverwrite?.hashCode() ?: 0
        result = 31 * result + (destinationRepository?.hashCode() ?: 0)
        result = 31 * result + (domain?.hashCode() ?: 0)
        result = 31 * result + (domainOwner?.hashCode() ?: 0)
        result = 31 * result + (format?.hashCode() ?: 0)
        result = 31 * result + (includeFromUpstream?.hashCode() ?: 0)
        result = 31 * result + (namespace?.hashCode() ?: 0)
        result = 31 * result + (`package`?.hashCode() ?: 0)
        result = 31 * result + (sourceRepository?.hashCode() ?: 0)
        result = 31 * result + (versionRevisions?.hashCode() ?: 0)
        result = 31 * result + (versions?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CopyPackageVersionsRequest

        if (allowOverwrite != other.allowOverwrite) return false
        if (destinationRepository != other.destinationRepository) return false
        if (domain != other.domain) return false
        if (domainOwner != other.domainOwner) return false
        if (format != other.format) return false
        if (includeFromUpstream != other.includeFromUpstream) return false
        if (namespace != other.namespace) return false
        if (`package` != other.`package`) return false
        if (sourceRepository != other.sourceRepository) return false
        if (versionRevisions != other.versionRevisions) return false
        if (versions != other.versions) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codeartifact.model.CopyPackageVersionsRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Set to true to overwrite a package version that already exists in the destination repository. If set to false and the package version already exists in the destination repository, the package version is returned in the `failedVersions` field of the response with an `ALREADY_EXISTS` error code.
         */
        var allowOverwrite: kotlin.Boolean? = null
        /**
         * The name of the repository into which package versions are copied.
         */
        var destinationRepository: kotlin.String? = null
        /**
         * The name of the domain that contains the source and destination repositories.
         */
        var domain: kotlin.String? = null
        /**
         * The 12-digit account number of the Amazon Web Services account that owns the domain. It does not include dashes or spaces.
         */
        var domainOwner: kotlin.String? = null
        /**
         * The format of the package that is copied.
         */
        var format: aws.sdk.kotlin.services.codeartifact.model.PackageFormat? = null
        /**
         * Set to true to copy packages from repositories that are upstream from the source repository to the destination repository. The default setting is false. For more information, see [Working with upstream repositories](https://docs.aws.amazon.com/codeartifact/latest/ug/repos-upstream.html).
         */
        var includeFromUpstream: kotlin.Boolean? = null
        /**
         * The namespace of the package. The package component that specifies its namespace depends on its type. For example:
         * +  The namespace of a Maven package is its `groupId`.
         * +  The namespace of an npm package is its `scope`.
         * +  A Python package does not contain a corresponding component, so Python packages do not have a namespace.
         */
        var namespace: kotlin.String? = null
        /**
         * The name of the package that is copied.
         */
        var `package`: kotlin.String? = null
        /**
         * The name of the repository that contains the package versions to copy.
         */
        var sourceRepository: kotlin.String? = null
        /**
         * A list of key-value pairs. The keys are package versions and the values are package version revisions. A `CopyPackageVersion` operation succeeds if the specified versions in the source repository match the specified package version revision.
         *
         *  You must specify `versions` or `versionRevisions`. You cannot specify both.
         */
        var versionRevisions: Map<String, String>? = null
        /**
         * The versions of the package to copy.
         *
         *  You must specify `versions` or `versionRevisions`. You cannot specify both.
         */
        var versions: List<String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codeartifact.model.CopyPackageVersionsRequest) : this() {
            this.allowOverwrite = x.allowOverwrite
            this.destinationRepository = x.destinationRepository
            this.domain = x.domain
            this.domainOwner = x.domainOwner
            this.format = x.format
            this.includeFromUpstream = x.includeFromUpstream
            this.namespace = x.namespace
            this.`package` = x.`package`
            this.sourceRepository = x.sourceRepository
            this.versionRevisions = x.versionRevisions
            this.versions = x.versions
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codeartifact.model.CopyPackageVersionsRequest = CopyPackageVersionsRequest(this)
    }
}
