// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeartifact.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about a domain. A domain is a container for repositories. When you create a domain, it is empty until you add one or more repositories.
 */
class DomainDescription private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the domain.
     */
    val arn: kotlin.String? = builder.arn
    /**
     * The total size of all assets in the domain.
     */
    val assetSizeBytes: kotlin.Long = builder.assetSizeBytes
    /**
     * A timestamp that represents the date and time the domain was created.
     */
    val createdTime: aws.smithy.kotlin.runtime.time.Instant? = builder.createdTime
    /**
     * The ARN of an Key Management Service (KMS) key associated with a domain.
     */
    val encryptionKey: kotlin.String? = builder.encryptionKey
    /**
     * The name of the domain.
     */
    val name: kotlin.String? = builder.name
    /**
     * The Amazon Web Services account ID that owns the domain.
     */
    val owner: kotlin.String? = builder.owner
    /**
     * The number of repositories in the domain.
     */
    val repositoryCount: kotlin.Int = builder.repositoryCount
    /**
     * The Amazon Resource Name (ARN) of the Amazon S3 bucket that is used to store package assets in the domain.
     */
    val s3BucketArn: kotlin.String? = builder.s3BucketArn
    /**
     * The current status of a domain.
     */
    val status: aws.sdk.kotlin.services.codeartifact.model.DomainStatus? = builder.status

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codeartifact.model.DomainDescription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DomainDescription(")
        append("arn=$arn,")
        append("assetSizeBytes=$assetSizeBytes,")
        append("createdTime=$createdTime,")
        append("encryptionKey=$encryptionKey,")
        append("name=$name,")
        append("owner=$owner,")
        append("repositoryCount=$repositoryCount,")
        append("s3BucketArn=$s3BucketArn,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (assetSizeBytes.hashCode())
        result = 31 * result + (createdTime?.hashCode() ?: 0)
        result = 31 * result + (encryptionKey?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (owner?.hashCode() ?: 0)
        result = 31 * result + (repositoryCount)
        result = 31 * result + (s3BucketArn?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DomainDescription

        if (arn != other.arn) return false
        if (assetSizeBytes != other.assetSizeBytes) return false
        if (createdTime != other.createdTime) return false
        if (encryptionKey != other.encryptionKey) return false
        if (name != other.name) return false
        if (owner != other.owner) return false
        if (repositoryCount != other.repositoryCount) return false
        if (s3BucketArn != other.s3BucketArn) return false
        if (status != other.status) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codeartifact.model.DomainDescription = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) of the domain.
         */
        var arn: kotlin.String? = null
        /**
         * The total size of all assets in the domain.
         */
        var assetSizeBytes: kotlin.Long = 0L
        /**
         * A timestamp that represents the date and time the domain was created.
         */
        var createdTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ARN of an Key Management Service (KMS) key associated with a domain.
         */
        var encryptionKey: kotlin.String? = null
        /**
         * The name of the domain.
         */
        var name: kotlin.String? = null
        /**
         * The Amazon Web Services account ID that owns the domain.
         */
        var owner: kotlin.String? = null
        /**
         * The number of repositories in the domain.
         */
        var repositoryCount: kotlin.Int = 0
        /**
         * The Amazon Resource Name (ARN) of the Amazon S3 bucket that is used to store package assets in the domain.
         */
        var s3BucketArn: kotlin.String? = null
        /**
         * The current status of a domain.
         */
        var status: aws.sdk.kotlin.services.codeartifact.model.DomainStatus? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codeartifact.model.DomainDescription) : this() {
            this.arn = x.arn
            this.assetSizeBytes = x.assetSizeBytes
            this.createdTime = x.createdTime
            this.encryptionKey = x.encryptionKey
            this.name = x.name
            this.owner = x.owner
            this.repositoryCount = x.repositoryCount
            this.s3BucketArn = x.s3BucketArn
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codeartifact.model.DomainDescription = DomainDescription(this)
    }
}
