// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeartifact.model



/**
 * Details about a package dependency.
 */
class PackageDependency private constructor(builder: Builder) {
    /**
     * The type of a package dependency. The possible values depend on the package type. Example types are `compile`, `runtime`, and `test` for Maven packages, and `dev`, `prod`, and `optional` for npm packages.
     */
    val dependencyType: kotlin.String? = builder.dependencyType
    /**
     * The namespace of the package. The package component that specifies its namespace depends on its type. For example:
     * +  The namespace of a Maven package is its `groupId`.
     * +  The namespace of an npm package is its `scope`.
     * +  A Python package does not contain a corresponding component, so Python packages do not have a namespace.
     */
    val namespace: kotlin.String? = builder.namespace
    /**
     * The name of the package that this package depends on.
     */
    val `package`: kotlin.String? = builder.`package`
    /**
     * The required version, or version range, of the package that this package depends on. The version format is specific to the package type. For example, the following are possible valid required versions: `1.2.3`, `^2.3.4`, or `4.x`.
     */
    val versionRequirement: kotlin.String? = builder.versionRequirement

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codeartifact.model.PackageDependency = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PackageDependency(")
        append("dependencyType=$dependencyType,")
        append("namespace=$namespace,")
        append("package=$`package`,")
        append("versionRequirement=$versionRequirement)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dependencyType?.hashCode() ?: 0
        result = 31 * result + (namespace?.hashCode() ?: 0)
        result = 31 * result + (`package`?.hashCode() ?: 0)
        result = 31 * result + (versionRequirement?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PackageDependency

        if (dependencyType != other.dependencyType) return false
        if (namespace != other.namespace) return false
        if (`package` != other.`package`) return false
        if (versionRequirement != other.versionRequirement) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codeartifact.model.PackageDependency = Builder(this).apply(block).build()

    class Builder {
        /**
         * The type of a package dependency. The possible values depend on the package type. Example types are `compile`, `runtime`, and `test` for Maven packages, and `dev`, `prod`, and `optional` for npm packages.
         */
        var dependencyType: kotlin.String? = null
        /**
         * The namespace of the package. The package component that specifies its namespace depends on its type. For example:
         * +  The namespace of a Maven package is its `groupId`.
         * +  The namespace of an npm package is its `scope`.
         * +  A Python package does not contain a corresponding component, so Python packages do not have a namespace.
         */
        var namespace: kotlin.String? = null
        /**
         * The name of the package that this package depends on.
         */
        var `package`: kotlin.String? = null
        /**
         * The required version, or version range, of the package that this package depends on. The version format is specific to the package type. For example, the following are possible valid required versions: `1.2.3`, `^2.3.4`, or `4.x`.
         */
        var versionRequirement: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codeartifact.model.PackageDependency) : this() {
            this.dependencyType = x.dependencyType
            this.namespace = x.namespace
            this.`package` = x.`package`
            this.versionRequirement = x.versionRequirement
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codeartifact.model.PackageDependency = PackageDependency(this)
    }
}
