// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeartifact.model



/**
 * Details about a package, including its format, namespace, and name. The [ListPackages](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_ListPackages.html) operation returns a list of `PackageSummary` objects.
 */
class PackageSummary private constructor(builder: Builder) {
    /**
     * The format of the package.
     */
    val format: aws.sdk.kotlin.services.codeartifact.model.PackageFormat? = builder.format
    /**
     * The namespace of the package. The package component that specifies its namespace depends on its type. For example:
     * +  The namespace of a Maven package is its `groupId`.
     * +  The namespace of an npm package is its `scope`.
     * +  A Python package does not contain a corresponding component, so Python packages do not have a namespace.
     */
    val namespace: kotlin.String? = builder.namespace
    /**
     * The name of the package.
     */
    val `package`: kotlin.String? = builder.`package`

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codeartifact.model.PackageSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PackageSummary(")
        append("format=$format,")
        append("namespace=$namespace,")
        append("package=$`package`)")
    }

    override fun hashCode(): kotlin.Int {
        var result = format?.hashCode() ?: 0
        result = 31 * result + (namespace?.hashCode() ?: 0)
        result = 31 * result + (`package`?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PackageSummary

        if (format != other.format) return false
        if (namespace != other.namespace) return false
        if (`package` != other.`package`) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codeartifact.model.PackageSummary = Builder(this).apply(block).build()

    class Builder {
        /**
         * The format of the package.
         */
        var format: aws.sdk.kotlin.services.codeartifact.model.PackageFormat? = null
        /**
         * The namespace of the package. The package component that specifies its namespace depends on its type. For example:
         * +  The namespace of a Maven package is its `groupId`.
         * +  The namespace of an npm package is its `scope`.
         * +  A Python package does not contain a corresponding component, so Python packages do not have a namespace.
         */
        var namespace: kotlin.String? = null
        /**
         * The name of the package.
         */
        var `package`: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codeartifact.model.PackageSummary) : this() {
            this.format = x.format
            this.namespace = x.namespace
            this.`package` = x.`package`
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codeartifact.model.PackageSummary = PackageSummary(this)
    }
}
