// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeartifact.model



/**
 * Details about a repository, including its Amazon Resource Name (ARN), description, and domain information. The [ListRepositories](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_ListRepositories.html) operation returns a list of `RepositorySummary` objects.
 */
class RepositorySummary private constructor(builder: Builder) {
    /**
     * The Amazon Web Services account ID that manages the repository.
     */
    val administratorAccount: kotlin.String? = builder.administratorAccount
    /**
     * The ARN of the repository.
     */
    val arn: kotlin.String? = builder.arn
    /**
     * The description of the repository.
     */
    val description: kotlin.String? = builder.description
    /**
     * The name of the domain that contains the repository.
     */
    val domainName: kotlin.String? = builder.domainName
    /**
     * The 12-digit account number of the Amazon Web Services account that owns the domain. It does not include dashes or spaces.
     */
    val domainOwner: kotlin.String? = builder.domainOwner
    /**
     * The name of the repository.
     */
    val name: kotlin.String? = builder.name

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codeartifact.model.RepositorySummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RepositorySummary(")
        append("administratorAccount=$administratorAccount,")
        append("arn=$arn,")
        append("description=$description,")
        append("domainName=$domainName,")
        append("domainOwner=$domainOwner,")
        append("name=$name)")
    }

    override fun hashCode(): kotlin.Int {
        var result = administratorAccount?.hashCode() ?: 0
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (domainName?.hashCode() ?: 0)
        result = 31 * result + (domainOwner?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RepositorySummary

        if (administratorAccount != other.administratorAccount) return false
        if (arn != other.arn) return false
        if (description != other.description) return false
        if (domainName != other.domainName) return false
        if (domainOwner != other.domainOwner) return false
        if (name != other.name) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codeartifact.model.RepositorySummary = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Web Services account ID that manages the repository.
         */
        var administratorAccount: kotlin.String? = null
        /**
         * The ARN of the repository.
         */
        var arn: kotlin.String? = null
        /**
         * The description of the repository.
         */
        var description: kotlin.String? = null
        /**
         * The name of the domain that contains the repository.
         */
        var domainName: kotlin.String? = null
        /**
         * The 12-digit account number of the Amazon Web Services account that owns the domain. It does not include dashes or spaces.
         */
        var domainOwner: kotlin.String? = null
        /**
         * The name of the repository.
         */
        var name: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codeartifact.model.RepositorySummary) : this() {
            this.administratorAccount = x.administratorAccount
            this.arn = x.arn
            this.description = x.description
            this.domainName = x.domainName
            this.domainOwner = x.domainOwner
            this.name = x.name
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codeartifact.model.RepositorySummary = RepositorySummary(this)
    }
}
