// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeartifact.paginators

import aws.sdk.kotlin.services.codeartifact.CodeartifactClient
import aws.sdk.kotlin.services.codeartifact.model.AssetSummary
import aws.sdk.kotlin.services.codeartifact.model.DomainSummary
import aws.sdk.kotlin.services.codeartifact.model.ListDomainsRequest
import aws.sdk.kotlin.services.codeartifact.model.ListDomainsResponse
import aws.sdk.kotlin.services.codeartifact.model.ListPackageVersionAssetsRequest
import aws.sdk.kotlin.services.codeartifact.model.ListPackageVersionAssetsResponse
import aws.sdk.kotlin.services.codeartifact.model.ListPackageVersionsRequest
import aws.sdk.kotlin.services.codeartifact.model.ListPackageVersionsResponse
import aws.sdk.kotlin.services.codeartifact.model.ListPackagesRequest
import aws.sdk.kotlin.services.codeartifact.model.ListPackagesResponse
import aws.sdk.kotlin.services.codeartifact.model.ListRepositoriesInDomainRequest
import aws.sdk.kotlin.services.codeartifact.model.ListRepositoriesInDomainResponse
import aws.sdk.kotlin.services.codeartifact.model.ListRepositoriesRequest
import aws.sdk.kotlin.services.codeartifact.model.ListRepositoriesResponse
import aws.sdk.kotlin.services.codeartifact.model.PackageSummary
import aws.sdk.kotlin.services.codeartifact.model.PackageVersionSummary
import aws.sdk.kotlin.services.codeartifact.model.RepositorySummary
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListDomainsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDomainsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDomainsResponse]
 */
fun CodeartifactClient.listDomainsPaginated(initialRequest: ListDomainsRequest): Flow<ListDomainsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDomainsPaginated.listDomains(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListDomainsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDomainsResponse]
 */
fun CodeartifactClient.listDomainsPaginated(block: ListDomainsRequest.Builder.() -> Unit): Flow<ListDomainsResponse> =
    listDomainsPaginated(ListDomainsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listDomainsPaginated]
 * to access the nested member [DomainSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DomainSummary]
 */
@JvmName("listDomainsResponseDomainSummary")
fun Flow<ListDomainsResponse>.domains(): Flow<DomainSummary> =
    transform() { response ->
        response.domains?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListPackagesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListPackagesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPackagesResponse]
 */
fun CodeartifactClient.listPackagesPaginated(initialRequest: ListPackagesRequest): Flow<ListPackagesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listPackagesPaginated.listPackages(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListPackagesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPackagesResponse]
 */
fun CodeartifactClient.listPackagesPaginated(block: ListPackagesRequest.Builder.() -> Unit): Flow<ListPackagesResponse> =
    listPackagesPaginated(ListPackagesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listPackagesPaginated]
 * to access the nested member [PackageSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [PackageSummary]
 */
@JvmName("listPackagesResponsePackageSummary")
fun Flow<ListPackagesResponse>.packages(): Flow<PackageSummary> =
    transform() { response ->
        response.packages?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListPackageVersionAssetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListPackageVersionAssetsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPackageVersionAssetsResponse]
 */
fun CodeartifactClient.listPackageVersionAssetsPaginated(initialRequest: ListPackageVersionAssetsRequest): Flow<ListPackageVersionAssetsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listPackageVersionAssetsPaginated.listPackageVersionAssets(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListPackageVersionAssetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPackageVersionAssetsResponse]
 */
fun CodeartifactClient.listPackageVersionAssetsPaginated(block: ListPackageVersionAssetsRequest.Builder.() -> Unit): Flow<ListPackageVersionAssetsResponse> =
    listPackageVersionAssetsPaginated(ListPackageVersionAssetsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listPackageVersionAssetsPaginated]
 * to access the nested member [AssetSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AssetSummary]
 */
@JvmName("listPackageVersionAssetsResponseAssetSummary")
fun Flow<ListPackageVersionAssetsResponse>.assets(): Flow<AssetSummary> =
    transform() { response ->
        response.assets?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListPackageVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListPackageVersionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPackageVersionsResponse]
 */
fun CodeartifactClient.listPackageVersionsPaginated(initialRequest: ListPackageVersionsRequest): Flow<ListPackageVersionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listPackageVersionsPaginated.listPackageVersions(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListPackageVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPackageVersionsResponse]
 */
fun CodeartifactClient.listPackageVersionsPaginated(block: ListPackageVersionsRequest.Builder.() -> Unit): Flow<ListPackageVersionsResponse> =
    listPackageVersionsPaginated(ListPackageVersionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listPackageVersionsPaginated]
 * to access the nested member [PackageVersionSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [PackageVersionSummary]
 */
@JvmName("listPackageVersionsResponsePackageVersionSummary")
fun Flow<ListPackageVersionsResponse>.versions(): Flow<PackageVersionSummary> =
    transform() { response ->
        response.versions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListRepositoriesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListRepositoriesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRepositoriesResponse]
 */
fun CodeartifactClient.listRepositoriesPaginated(initialRequest: ListRepositoriesRequest): Flow<ListRepositoriesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listRepositoriesPaginated.listRepositories(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListRepositoriesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRepositoriesResponse]
 */
fun CodeartifactClient.listRepositoriesPaginated(block: ListRepositoriesRequest.Builder.() -> Unit): Flow<ListRepositoriesResponse> =
    listRepositoriesPaginated(ListRepositoriesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listRepositoriesPaginated]
 * to access the nested member [RepositorySummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [RepositorySummary]
 */
@JvmName("listRepositoriesResponseRepositorySummary")
fun Flow<ListRepositoriesResponse>.repositories(): Flow<RepositorySummary> =
    transform() { response ->
        response.repositories?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListRepositoriesInDomainResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListRepositoriesInDomainRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRepositoriesInDomainResponse]
 */
fun CodeartifactClient.listRepositoriesInDomainPaginated(initialRequest: ListRepositoriesInDomainRequest): Flow<ListRepositoriesInDomainResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listRepositoriesInDomainPaginated.listRepositoriesInDomain(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListRepositoriesInDomainResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRepositoriesInDomainResponse]
 */
fun CodeartifactClient.listRepositoriesInDomainPaginated(block: ListRepositoriesInDomainRequest.Builder.() -> Unit): Flow<ListRepositoriesInDomainResponse> =
    listRepositoriesInDomainPaginated(ListRepositoriesInDomainRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listRepositoriesInDomainPaginated]
 * to access the nested member [RepositorySummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [RepositorySummary]
 */
@JvmName("listRepositoriesInDomainResponseRepositorySummary")
fun Flow<ListRepositoriesInDomainResponse>.repositories(): Flow<RepositorySummary> =
    transform() { response ->
        response.repositories?.forEach {
            emit(it)
        }
    }
