// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecommit

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.config.retries.resolveRetryStrategy
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.codecommit.endpoints.DefaultEndpointProvider
import aws.sdk.kotlin.services.codecommit.endpoints.EndpointProvider
import aws.sdk.kotlin.services.codecommit.model.*
import aws.sdk.kotlin.services.codecommit.model.AssociateApprovalRuleTemplateWithRepositoryRequest
import aws.sdk.kotlin.services.codecommit.model.AssociateApprovalRuleTemplateWithRepositoryResponse
import aws.sdk.kotlin.services.codecommit.model.BatchAssociateApprovalRuleTemplateWithRepositoriesRequest
import aws.sdk.kotlin.services.codecommit.model.BatchAssociateApprovalRuleTemplateWithRepositoriesResponse
import aws.sdk.kotlin.services.codecommit.model.BatchDescribeMergeConflictsRequest
import aws.sdk.kotlin.services.codecommit.model.BatchDescribeMergeConflictsResponse
import aws.sdk.kotlin.services.codecommit.model.BatchDisassociateApprovalRuleTemplateFromRepositoriesRequest
import aws.sdk.kotlin.services.codecommit.model.BatchDisassociateApprovalRuleTemplateFromRepositoriesResponse
import aws.sdk.kotlin.services.codecommit.model.BatchGetCommitsRequest
import aws.sdk.kotlin.services.codecommit.model.BatchGetCommitsResponse
import aws.sdk.kotlin.services.codecommit.model.BatchGetRepositoriesRequest
import aws.sdk.kotlin.services.codecommit.model.BatchGetRepositoriesResponse
import aws.sdk.kotlin.services.codecommit.model.CreateApprovalRuleTemplateRequest
import aws.sdk.kotlin.services.codecommit.model.CreateApprovalRuleTemplateResponse
import aws.sdk.kotlin.services.codecommit.model.CreateBranchRequest
import aws.sdk.kotlin.services.codecommit.model.CreateBranchResponse
import aws.sdk.kotlin.services.codecommit.model.CreateCommitRequest
import aws.sdk.kotlin.services.codecommit.model.CreateCommitResponse
import aws.sdk.kotlin.services.codecommit.model.CreatePullRequestApprovalRuleRequest
import aws.sdk.kotlin.services.codecommit.model.CreatePullRequestApprovalRuleResponse
import aws.sdk.kotlin.services.codecommit.model.CreatePullRequestRequest
import aws.sdk.kotlin.services.codecommit.model.CreatePullRequestResponse
import aws.sdk.kotlin.services.codecommit.model.CreateRepositoryRequest
import aws.sdk.kotlin.services.codecommit.model.CreateRepositoryResponse
import aws.sdk.kotlin.services.codecommit.model.CreateUnreferencedMergeCommitRequest
import aws.sdk.kotlin.services.codecommit.model.CreateUnreferencedMergeCommitResponse
import aws.sdk.kotlin.services.codecommit.model.DeleteApprovalRuleTemplateRequest
import aws.sdk.kotlin.services.codecommit.model.DeleteApprovalRuleTemplateResponse
import aws.sdk.kotlin.services.codecommit.model.DeleteBranchRequest
import aws.sdk.kotlin.services.codecommit.model.DeleteBranchResponse
import aws.sdk.kotlin.services.codecommit.model.DeleteCommentContentRequest
import aws.sdk.kotlin.services.codecommit.model.DeleteCommentContentResponse
import aws.sdk.kotlin.services.codecommit.model.DeleteFileRequest
import aws.sdk.kotlin.services.codecommit.model.DeleteFileResponse
import aws.sdk.kotlin.services.codecommit.model.DeletePullRequestApprovalRuleRequest
import aws.sdk.kotlin.services.codecommit.model.DeletePullRequestApprovalRuleResponse
import aws.sdk.kotlin.services.codecommit.model.DeleteRepositoryRequest
import aws.sdk.kotlin.services.codecommit.model.DeleteRepositoryResponse
import aws.sdk.kotlin.services.codecommit.model.DescribeMergeConflictsRequest
import aws.sdk.kotlin.services.codecommit.model.DescribeMergeConflictsResponse
import aws.sdk.kotlin.services.codecommit.model.DescribePullRequestEventsRequest
import aws.sdk.kotlin.services.codecommit.model.DescribePullRequestEventsResponse
import aws.sdk.kotlin.services.codecommit.model.DisassociateApprovalRuleTemplateFromRepositoryRequest
import aws.sdk.kotlin.services.codecommit.model.DisassociateApprovalRuleTemplateFromRepositoryResponse
import aws.sdk.kotlin.services.codecommit.model.EvaluatePullRequestApprovalRulesRequest
import aws.sdk.kotlin.services.codecommit.model.EvaluatePullRequestApprovalRulesResponse
import aws.sdk.kotlin.services.codecommit.model.GetApprovalRuleTemplateRequest
import aws.sdk.kotlin.services.codecommit.model.GetApprovalRuleTemplateResponse
import aws.sdk.kotlin.services.codecommit.model.GetBlobRequest
import aws.sdk.kotlin.services.codecommit.model.GetBlobResponse
import aws.sdk.kotlin.services.codecommit.model.GetBranchRequest
import aws.sdk.kotlin.services.codecommit.model.GetBranchResponse
import aws.sdk.kotlin.services.codecommit.model.GetCommentReactionsRequest
import aws.sdk.kotlin.services.codecommit.model.GetCommentReactionsResponse
import aws.sdk.kotlin.services.codecommit.model.GetCommentRequest
import aws.sdk.kotlin.services.codecommit.model.GetCommentResponse
import aws.sdk.kotlin.services.codecommit.model.GetCommentsForComparedCommitRequest
import aws.sdk.kotlin.services.codecommit.model.GetCommentsForComparedCommitResponse
import aws.sdk.kotlin.services.codecommit.model.GetCommentsForPullRequestRequest
import aws.sdk.kotlin.services.codecommit.model.GetCommentsForPullRequestResponse
import aws.sdk.kotlin.services.codecommit.model.GetCommitRequest
import aws.sdk.kotlin.services.codecommit.model.GetCommitResponse
import aws.sdk.kotlin.services.codecommit.model.GetDifferencesRequest
import aws.sdk.kotlin.services.codecommit.model.GetDifferencesResponse
import aws.sdk.kotlin.services.codecommit.model.GetFileRequest
import aws.sdk.kotlin.services.codecommit.model.GetFileResponse
import aws.sdk.kotlin.services.codecommit.model.GetFolderRequest
import aws.sdk.kotlin.services.codecommit.model.GetFolderResponse
import aws.sdk.kotlin.services.codecommit.model.GetMergeCommitRequest
import aws.sdk.kotlin.services.codecommit.model.GetMergeCommitResponse
import aws.sdk.kotlin.services.codecommit.model.GetMergeConflictsRequest
import aws.sdk.kotlin.services.codecommit.model.GetMergeConflictsResponse
import aws.sdk.kotlin.services.codecommit.model.GetMergeOptionsRequest
import aws.sdk.kotlin.services.codecommit.model.GetMergeOptionsResponse
import aws.sdk.kotlin.services.codecommit.model.GetPullRequestApprovalStatesRequest
import aws.sdk.kotlin.services.codecommit.model.GetPullRequestApprovalStatesResponse
import aws.sdk.kotlin.services.codecommit.model.GetPullRequestOverrideStateRequest
import aws.sdk.kotlin.services.codecommit.model.GetPullRequestOverrideStateResponse
import aws.sdk.kotlin.services.codecommit.model.GetPullRequestRequest
import aws.sdk.kotlin.services.codecommit.model.GetPullRequestResponse
import aws.sdk.kotlin.services.codecommit.model.GetRepositoryRequest
import aws.sdk.kotlin.services.codecommit.model.GetRepositoryResponse
import aws.sdk.kotlin.services.codecommit.model.GetRepositoryTriggersRequest
import aws.sdk.kotlin.services.codecommit.model.GetRepositoryTriggersResponse
import aws.sdk.kotlin.services.codecommit.model.ListApprovalRuleTemplatesRequest
import aws.sdk.kotlin.services.codecommit.model.ListApprovalRuleTemplatesResponse
import aws.sdk.kotlin.services.codecommit.model.ListAssociatedApprovalRuleTemplatesForRepositoryRequest
import aws.sdk.kotlin.services.codecommit.model.ListAssociatedApprovalRuleTemplatesForRepositoryResponse
import aws.sdk.kotlin.services.codecommit.model.ListBranchesRequest
import aws.sdk.kotlin.services.codecommit.model.ListBranchesResponse
import aws.sdk.kotlin.services.codecommit.model.ListPullRequestsRequest
import aws.sdk.kotlin.services.codecommit.model.ListPullRequestsResponse
import aws.sdk.kotlin.services.codecommit.model.ListRepositoriesForApprovalRuleTemplateRequest
import aws.sdk.kotlin.services.codecommit.model.ListRepositoriesForApprovalRuleTemplateResponse
import aws.sdk.kotlin.services.codecommit.model.ListRepositoriesRequest
import aws.sdk.kotlin.services.codecommit.model.ListRepositoriesResponse
import aws.sdk.kotlin.services.codecommit.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.codecommit.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.codecommit.model.MergeBranchesByFastForwardRequest
import aws.sdk.kotlin.services.codecommit.model.MergeBranchesByFastForwardResponse
import aws.sdk.kotlin.services.codecommit.model.MergeBranchesBySquashRequest
import aws.sdk.kotlin.services.codecommit.model.MergeBranchesBySquashResponse
import aws.sdk.kotlin.services.codecommit.model.MergeBranchesByThreeWayRequest
import aws.sdk.kotlin.services.codecommit.model.MergeBranchesByThreeWayResponse
import aws.sdk.kotlin.services.codecommit.model.MergePullRequestByFastForwardRequest
import aws.sdk.kotlin.services.codecommit.model.MergePullRequestByFastForwardResponse
import aws.sdk.kotlin.services.codecommit.model.MergePullRequestBySquashRequest
import aws.sdk.kotlin.services.codecommit.model.MergePullRequestBySquashResponse
import aws.sdk.kotlin.services.codecommit.model.MergePullRequestByThreeWayRequest
import aws.sdk.kotlin.services.codecommit.model.MergePullRequestByThreeWayResponse
import aws.sdk.kotlin.services.codecommit.model.OverridePullRequestApprovalRulesRequest
import aws.sdk.kotlin.services.codecommit.model.OverridePullRequestApprovalRulesResponse
import aws.sdk.kotlin.services.codecommit.model.PostCommentForComparedCommitRequest
import aws.sdk.kotlin.services.codecommit.model.PostCommentForComparedCommitResponse
import aws.sdk.kotlin.services.codecommit.model.PostCommentForPullRequestRequest
import aws.sdk.kotlin.services.codecommit.model.PostCommentForPullRequestResponse
import aws.sdk.kotlin.services.codecommit.model.PostCommentReplyRequest
import aws.sdk.kotlin.services.codecommit.model.PostCommentReplyResponse
import aws.sdk.kotlin.services.codecommit.model.PutCommentReactionRequest
import aws.sdk.kotlin.services.codecommit.model.PutCommentReactionResponse
import aws.sdk.kotlin.services.codecommit.model.PutFileRequest
import aws.sdk.kotlin.services.codecommit.model.PutFileResponse
import aws.sdk.kotlin.services.codecommit.model.PutRepositoryTriggersRequest
import aws.sdk.kotlin.services.codecommit.model.PutRepositoryTriggersResponse
import aws.sdk.kotlin.services.codecommit.model.TagResourceRequest
import aws.sdk.kotlin.services.codecommit.model.TagResourceResponse
import aws.sdk.kotlin.services.codecommit.model.TestRepositoryTriggersRequest
import aws.sdk.kotlin.services.codecommit.model.TestRepositoryTriggersResponse
import aws.sdk.kotlin.services.codecommit.model.UntagResourceRequest
import aws.sdk.kotlin.services.codecommit.model.UntagResourceResponse
import aws.sdk.kotlin.services.codecommit.model.UpdateApprovalRuleTemplateContentRequest
import aws.sdk.kotlin.services.codecommit.model.UpdateApprovalRuleTemplateContentResponse
import aws.sdk.kotlin.services.codecommit.model.UpdateApprovalRuleTemplateDescriptionRequest
import aws.sdk.kotlin.services.codecommit.model.UpdateApprovalRuleTemplateDescriptionResponse
import aws.sdk.kotlin.services.codecommit.model.UpdateApprovalRuleTemplateNameRequest
import aws.sdk.kotlin.services.codecommit.model.UpdateApprovalRuleTemplateNameResponse
import aws.sdk.kotlin.services.codecommit.model.UpdateCommentRequest
import aws.sdk.kotlin.services.codecommit.model.UpdateCommentResponse
import aws.sdk.kotlin.services.codecommit.model.UpdateDefaultBranchRequest
import aws.sdk.kotlin.services.codecommit.model.UpdateDefaultBranchResponse
import aws.sdk.kotlin.services.codecommit.model.UpdatePullRequestApprovalRuleContentRequest
import aws.sdk.kotlin.services.codecommit.model.UpdatePullRequestApprovalRuleContentResponse
import aws.sdk.kotlin.services.codecommit.model.UpdatePullRequestApprovalStateRequest
import aws.sdk.kotlin.services.codecommit.model.UpdatePullRequestApprovalStateResponse
import aws.sdk.kotlin.services.codecommit.model.UpdatePullRequestDescriptionRequest
import aws.sdk.kotlin.services.codecommit.model.UpdatePullRequestDescriptionResponse
import aws.sdk.kotlin.services.codecommit.model.UpdatePullRequestStatusRequest
import aws.sdk.kotlin.services.codecommit.model.UpdatePullRequestStatusResponse
import aws.sdk.kotlin.services.codecommit.model.UpdatePullRequestTitleRequest
import aws.sdk.kotlin.services.codecommit.model.UpdatePullRequestTitleResponse
import aws.sdk.kotlin.services.codecommit.model.UpdateRepositoryDescriptionRequest
import aws.sdk.kotlin.services.codecommit.model.UpdateRepositoryDescriptionResponse
import aws.sdk.kotlin.services.codecommit.model.UpdateRepositoryNameRequest
import aws.sdk.kotlin.services.codecommit.model.UpdateRepositoryNameResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.config.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.Url
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.tracing.DefaultTracer
import aws.smithy.kotlin.runtime.tracing.LoggingTraceProbe
import aws.smithy.kotlin.runtime.tracing.Tracer
import aws.smithy.kotlin.runtime.tracing.TracingClientConfig

/**
 * # AWS CodeCommit
 * This is the *AWS CodeCommit API Reference*. This reference provides descriptions of the operations and data types for AWS CodeCommit API along with usage examples.
 *
 * You can use the AWS CodeCommit API to work with the following objects:
 *
 * Repositories, by calling the following:
 * + BatchGetRepositories, which returns information about one or more repositories associated with your AWS account.
 * + CreateRepository, which creates an AWS CodeCommit repository.
 * + DeleteRepository, which deletes an AWS CodeCommit repository.
 * + GetRepository, which returns information about a specified repository.
 * + ListRepositories, which lists all AWS CodeCommit repositories associated with your AWS account.
 * + UpdateRepositoryDescription, which sets or updates the description of the repository.
 * + UpdateRepositoryName, which changes the name of the repository. If you change the name of a repository, no other users of that repository can access it until you send them the new HTTPS or SSH URL to use.
 *
 * Branches, by calling the following:
 * + CreateBranch, which creates a branch in a specified repository.
 * + DeleteBranch, which deletes the specified branch in a repository unless it is the default branch.
 * + GetBranch, which returns information about a specified branch.
 * + ListBranches, which lists all branches for a specified repository.
 * + UpdateDefaultBranch, which changes the default branch for a repository.
 *
 * Files, by calling the following:
 * + DeleteFile, which deletes the content of a specified file from a specified branch.
 * + GetBlob, which returns the base-64 encoded content of an individual Git blob object in a repository.
 * + GetFile, which returns the base-64 encoded content of a specified file.
 * + GetFolder, which returns the contents of a specified folder or directory.
 * + PutFile, which adds or modifies a single file in a specified repository and branch.
 *
 * Commits, by calling the following:
 * + BatchGetCommits, which returns information about one or more commits in a repository.
 * + CreateCommit, which creates a commit for changes to a repository.
 * + GetCommit, which returns information about a commit, including commit messages and author and committer information.
 * + GetDifferences, which returns information about the differences in a valid commit specifier (such as a branch, tag, HEAD, commit ID, or other fully qualified reference).
 *
 * Merges, by calling the following:
 * + BatchDescribeMergeConflicts, which returns information about conflicts in a merge between commits in a repository.
 * + CreateUnreferencedMergeCommit, which creates an unreferenced commit between two branches or commits for the purpose of comparing them and identifying any potential conflicts.
 * + DescribeMergeConflicts, which returns information about merge conflicts between the base, source, and destination versions of a file in a potential merge.
 * + GetMergeCommit, which returns information about the merge between a source and destination commit.
 * + GetMergeConflicts, which returns information about merge conflicts between the source and destination branch in a pull request.
 * + GetMergeOptions, which returns information about the available merge options between two branches or commit specifiers.
 * + MergeBranchesByFastForward, which merges two branches using the fast-forward merge option.
 * + MergeBranchesBySquash, which merges two branches using the squash merge option.
 * + MergeBranchesByThreeWay, which merges two branches using the three-way merge option.
 *
 * Pull requests, by calling the following:
 * + CreatePullRequest, which creates a pull request in a specified repository.
 * + CreatePullRequestApprovalRule, which creates an approval rule for a specified pull request.
 * + DeletePullRequestApprovalRule, which deletes an approval rule for a specified pull request.
 * + DescribePullRequestEvents, which returns information about one or more pull request events.
 * + EvaluatePullRequestApprovalRules, which evaluates whether a pull request has met all the conditions specified in its associated approval rules.
 * + GetCommentsForPullRequest, which returns information about comments on a specified pull request.
 * + GetPullRequest, which returns information about a specified pull request.
 * + GetPullRequestApprovalStates, which returns information about the approval states for a specified pull request.
 * + GetPullRequestOverrideState, which returns information about whether approval rules have been set aside (overriden) for a pull request, and if so, the Amazon Resource Name (ARN) of the user or identity that overrode the rules and their requirements for the pull request.
 * + ListPullRequests, which lists all pull requests for a repository.
 * + MergePullRequestByFastForward, which merges the source destination branch of a pull request into the specified destination branch for that pull request using the fast-forward merge option.
 * + MergePullRequestBySquash, which merges the source destination branch of a pull request into the specified destination branch for that pull request using the squash merge option.
 * + MergePullRequestByThreeWay. which merges the source destination branch of a pull request into the specified destination branch for that pull request using the three-way merge option.
 * + OverridePullRequestApprovalRules, which sets aside all approval rule requirements for a pull request.
 * + PostCommentForPullRequest, which posts a comment to a pull request at the specified line, file, or request.
 * + UpdatePullRequestApprovalRuleContent, which updates the structure of an approval rule for a pull request.
 * + UpdatePullRequestApprovalState, which updates the state of an approval on a pull request.
 * + UpdatePullRequestDescription, which updates the description of a pull request.
 * + UpdatePullRequestStatus, which updates the status of a pull request.
 * + UpdatePullRequestTitle, which updates the title of a pull request.
 *
 * Approval rule templates, by calling the following:
 * + AssociateApprovalRuleTemplateWithRepository, which associates a template with a specified repository. After the template is associated with a repository, AWS CodeCommit creates approval rules that match the template conditions on every pull request created in the specified repository.
 * + BatchAssociateApprovalRuleTemplateWithRepositories, which associates a template with one or more specified repositories. After the template is associated with a repository, AWS CodeCommit creates approval rules that match the template conditions on every pull request created in the specified repositories.
 * + BatchDisassociateApprovalRuleTemplateFromRepositories, which removes the association between a template and specified repositories so that approval rules based on the template are not automatically created when pull requests are created in those repositories.
 * + CreateApprovalRuleTemplate, which creates a template for approval rules that can then be associated with one or more repositories in your AWS account.
 * + DeleteApprovalRuleTemplate, which deletes the specified template. It does not remove approval rules on pull requests already created with the template.
 * + DisassociateApprovalRuleTemplateFromRepository, which removes the association between a template and a repository so that approval rules based on the template are not automatically created when pull requests are created in the specified repository.
 * + GetApprovalRuleTemplate, which returns information about an approval rule template.
 * + ListApprovalRuleTemplates, which lists all approval rule templates in the AWS Region in your AWS account.
 * + ListAssociatedApprovalRuleTemplatesForRepository, which lists all approval rule templates that are associated with a specified repository.
 * + ListRepositoriesForApprovalRuleTemplate, which lists all repositories associated with the specified approval rule template.
 * + UpdateApprovalRuleTemplateDescription, which updates the description of an approval rule template.
 * + UpdateApprovalRuleTemplateName, which updates the name of an approval rule template.
 * + UpdateApprovalRuleTemplateContent, which updates the content of an approval rule template.
 *
 * Comments in a repository, by calling the following:
 * + DeleteCommentContent, which deletes the content of a comment on a commit in a repository.
 * + GetComment, which returns information about a comment on a commit.
 * + GetCommentReactions, which returns information about emoji reactions to comments.
 * + GetCommentsForComparedCommit, which returns information about comments on the comparison between two commit specifiers in a repository.
 * + PostCommentForComparedCommit, which creates a comment on the comparison between two commit specifiers in a repository.
 * + PostCommentReply, which creates a reply to a comment.
 * + PutCommentReaction, which creates or updates an emoji reaction to a comment.
 * + UpdateComment, which updates the content of a comment on a commit in a repository.
 *
 * Tags used to tag resources in AWS CodeCommit (not Git tags), by calling the following:
 * + ListTagsForResource, which gets information about AWS tags for a specified Amazon Resource Name (ARN) in AWS CodeCommit.
 * + TagResource, which adds or updates tags for a resource in AWS CodeCommit.
 * + UntagResource, which removes tags for a resource in AWS CodeCommit.
 *
 * Triggers, by calling the following:
 * + GetRepositoryTriggers, which returns information about triggers configured for a repository.
 * + PutRepositoryTriggers, which replaces all triggers for a repository and can be used to create or delete triggers.
 * + TestRepositoryTriggers, which tests the functionality of a repository trigger by sending data to the trigger target.
 *
 * For information about how to use AWS CodeCommit, see the [AWS CodeCommit User Guide](https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html).
 */
public interface CodeCommitClient : SdkClient {

    override val serviceName: String
        get() = "CodeCommit"
    /**
     * CodeCommitClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): CodeCommitClient {
            val config = Config.Builder().apply(block).build()
            return DefaultCodeCommitClient(config)
        }

        public operator fun invoke(config: Config): CodeCommitClient = DefaultCodeCommitClient(config)

        /**
         * Construct a [CodeCommitClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): CodeCommitClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            builder.retryStrategy = builder.retryStrategy ?: resolveRetryStrategy()
            return DefaultCodeCommitClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, IdempotencyTokenConfig, SdkClientConfig, TracingClientConfig {
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region)
        public val endpointProvider: EndpointProvider = builder.endpointProvider ?: DefaultEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider? = builder.idempotencyTokenProvider
        public val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        override val tracer: Tracer = builder.tracer ?: DefaultTracer(LoggingTraceProbe, "CodeCommit")
        public val useDualStack: Boolean = builder.useDualStack
        public val useFips: Boolean = builder.useFips
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * The endpoint provider used to determine where to make service requests.
             */
            public var endpointProvider: EndpointProvider? = null
            /**
             * A custom endpoint to use when making requests.
             */
            public var endpointUrl: Url? = null
            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            public var idempotencyTokenProvider: IdempotencyTokenProvider? = null
            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            public var retryStrategy: RetryStrategy? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null
            /**
             * The tracer that is responsible for creating trace spans and wiring them up to a tracing backend (e.g.,
             * a trace probe). By default, this will create a standard tracer that uses the service name for the root
             * trace span and delegates to a logging trace probe (i.e.,
             * `DefaultTracer(LoggingTraceProbe, "<service-name>")`).
             */
            public var tracer: Tracer? = null
            /**
             * Flag to toggle whether to use dual-stack endpoints when making requests.
             */
            public var useDualStack: Boolean = false
            /**
             * Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             */
            public var useFips: Boolean = false

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Creates an association between an approval rule template and a specified repository. Then, the next time a pull request is created in the repository where the destination reference (if specified) matches the destination reference (branch) for the pull request, an approval rule that matches the template conditions is automatically created for that pull request. If no destination references are specified in the template, an approval rule that matches the template contents is created for all pull requests in that repository.
     */
    public suspend fun associateApprovalRuleTemplateWithRepository(input: AssociateApprovalRuleTemplateWithRepositoryRequest): AssociateApprovalRuleTemplateWithRepositoryResponse

    /**
     * Creates an association between an approval rule template and one or more specified repositories.
     */
    public suspend fun batchAssociateApprovalRuleTemplateWithRepositories(input: BatchAssociateApprovalRuleTemplateWithRepositoriesRequest): BatchAssociateApprovalRuleTemplateWithRepositoriesResponse

    /**
     * Returns information about one or more merge conflicts in the attempted merge of two commit specifiers using the squash or three-way merge strategy.
     */
    public suspend fun batchDescribeMergeConflicts(input: BatchDescribeMergeConflictsRequest): BatchDescribeMergeConflictsResponse

    /**
     * Removes the association between an approval rule template and one or more specified repositories.
     */
    public suspend fun batchDisassociateApprovalRuleTemplateFromRepositories(input: BatchDisassociateApprovalRuleTemplateFromRepositoriesRequest): BatchDisassociateApprovalRuleTemplateFromRepositoriesResponse

    /**
     * Returns information about the contents of one or more commits in a repository.
     */
    public suspend fun batchGetCommits(input: BatchGetCommitsRequest): BatchGetCommitsResponse

    /**
     * Returns information about one or more repositories.
     *
     * The description field for a repository accepts all HTML characters and all valid Unicode characters. Applications that do not HTML-encode the description and display it in a webpage can expose users to potentially malicious code. Make sure that you HTML-encode the description field in any application that uses this API to display the repository description on a webpage.
     */
    public suspend fun batchGetRepositories(input: BatchGetRepositoriesRequest): BatchGetRepositoriesResponse

    /**
     * Creates a template for approval rules that can then be associated with one or more repositories in your AWS account. When you associate a template with a repository, AWS CodeCommit creates an approval rule that matches the conditions of the template for all pull requests that meet the conditions of the template. For more information, see AssociateApprovalRuleTemplateWithRepository.
     */
    public suspend fun createApprovalRuleTemplate(input: CreateApprovalRuleTemplateRequest): CreateApprovalRuleTemplateResponse

    /**
     * Creates a branch in a repository and points the branch to a commit.
     *
     * Calling the create branch operation does not set a repository's default branch. To do this, call the update default branch operation.
     */
    public suspend fun createBranch(input: CreateBranchRequest): CreateBranchResponse

    /**
     * Creates a commit for a repository on the tip of a specified branch.
     */
    public suspend fun createCommit(input: CreateCommitRequest): CreateCommitResponse

    /**
     * Creates a pull request in the specified repository.
     */
    public suspend fun createPullRequest(input: CreatePullRequestRequest): CreatePullRequestResponse

    /**
     * Creates an approval rule for a pull request.
     */
    public suspend fun createPullRequestApprovalRule(input: CreatePullRequestApprovalRuleRequest): CreatePullRequestApprovalRuleResponse

    /**
     * Creates a new, empty repository.
     */
    public suspend fun createRepository(input: CreateRepositoryRequest): CreateRepositoryResponse

    /**
     * Creates an unreferenced commit that represents the result of merging two branches using a specified merge strategy. This can help you determine the outcome of a potential merge. This API cannot be used with the fast-forward merge strategy because that strategy does not create a merge commit.
     *
     * This unreferenced merge commit can only be accessed using the GetCommit API or through git commands such as git fetch. To retrieve this commit, you must specify its commit ID or otherwise reference it.
     */
    public suspend fun createUnreferencedMergeCommit(input: CreateUnreferencedMergeCommitRequest): CreateUnreferencedMergeCommitResponse

    /**
     * Deletes a specified approval rule template. Deleting a template does not remove approval rules on pull requests already created with the template.
     */
    public suspend fun deleteApprovalRuleTemplate(input: DeleteApprovalRuleTemplateRequest): DeleteApprovalRuleTemplateResponse

    /**
     * Deletes a branch from a repository, unless that branch is the default branch for the repository.
     */
    public suspend fun deleteBranch(input: DeleteBranchRequest): DeleteBranchResponse

    /**
     * Deletes the content of a comment made on a change, file, or commit in a repository.
     */
    public suspend fun deleteCommentContent(input: DeleteCommentContentRequest): DeleteCommentContentResponse

    /**
     * Deletes a specified file from a specified branch. A commit is created on the branch that contains the revision. The file still exists in the commits earlier to the commit that contains the deletion.
     */
    public suspend fun deleteFile(input: DeleteFileRequest): DeleteFileResponse

    /**
     * Deletes an approval rule from a specified pull request. Approval rules can be deleted from a pull request only if the pull request is open, and if the approval rule was created specifically for a pull request and not generated from an approval rule template associated with the repository where the pull request was created. You cannot delete an approval rule from a merged or closed pull request.
     */
    public suspend fun deletePullRequestApprovalRule(input: DeletePullRequestApprovalRuleRequest): DeletePullRequestApprovalRuleResponse

    /**
     * Deletes a repository. If a specified repository was already deleted, a null repository ID is returned.
     *
     * Deleting a repository also deletes all associated objects and metadata. After a repository is deleted, all future push calls to the deleted repository fail.
     */
    public suspend fun deleteRepository(input: DeleteRepositoryRequest): DeleteRepositoryResponse

    /**
     * Returns information about one or more merge conflicts in the attempted merge of two commit specifiers using the squash or three-way merge strategy. If the merge option for the attempted merge is specified as FAST_FORWARD_MERGE, an exception is thrown.
     */
    public suspend fun describeMergeConflicts(input: DescribeMergeConflictsRequest): DescribeMergeConflictsResponse

    /**
     * Returns information about one or more pull request events.
     */
    public suspend fun describePullRequestEvents(input: DescribePullRequestEventsRequest): DescribePullRequestEventsResponse

    /**
     * Removes the association between a template and a repository so that approval rules based on the template are not automatically created when pull requests are created in the specified repository. This does not delete any approval rules previously created for pull requests through the template association.
     */
    public suspend fun disassociateApprovalRuleTemplateFromRepository(input: DisassociateApprovalRuleTemplateFromRepositoryRequest): DisassociateApprovalRuleTemplateFromRepositoryResponse

    /**
     * Evaluates whether a pull request has met all the conditions specified in its associated approval rules.
     */
    public suspend fun evaluatePullRequestApprovalRules(input: EvaluatePullRequestApprovalRulesRequest): EvaluatePullRequestApprovalRulesResponse

    /**
     * Returns information about a specified approval rule template.
     */
    public suspend fun getApprovalRuleTemplate(input: GetApprovalRuleTemplateRequest): GetApprovalRuleTemplateResponse

    /**
     * Returns the base-64 encoded content of an individual blob in a repository.
     */
    public suspend fun getBlob(input: GetBlobRequest): GetBlobResponse

    /**
     * Returns information about a repository branch, including its name and the last commit ID.
     */
    public suspend fun getBranch(input: GetBranchRequest = GetBranchRequest {}): GetBranchResponse

    /**
     * Returns the content of a comment made on a change, file, or commit in a repository.
     *
     * Reaction counts might include numbers from user identities who were deleted after the reaction was made. For a count of reactions from active identities, use GetCommentReactions.
     */
    public suspend fun getComment(input: GetCommentRequest): GetCommentResponse

    /**
     * Returns information about reactions to a specified comment ID. Reactions from users who have been deleted will not be included in the count.
     */
    public suspend fun getCommentReactions(input: GetCommentReactionsRequest): GetCommentReactionsResponse

    /**
     * Returns information about comments made on the comparison between two commits.
     *
     * Reaction counts might include numbers from user identities who were deleted after the reaction was made. For a count of reactions from active identities, use GetCommentReactions.
     */
    public suspend fun getCommentsForComparedCommit(input: GetCommentsForComparedCommitRequest): GetCommentsForComparedCommitResponse

    /**
     * Returns comments made on a pull request.
     *
     * Reaction counts might include numbers from user identities who were deleted after the reaction was made. For a count of reactions from active identities, use GetCommentReactions.
     */
    public suspend fun getCommentsForPullRequest(input: GetCommentsForPullRequestRequest): GetCommentsForPullRequestResponse

    /**
     * Returns information about a commit, including commit message and committer information.
     */
    public suspend fun getCommit(input: GetCommitRequest): GetCommitResponse

    /**
     * Returns information about the differences in a valid commit specifier (such as a branch, tag, HEAD, commit ID, or other fully qualified reference). Results can be limited to a specified path.
     */
    public suspend fun getDifferences(input: GetDifferencesRequest): GetDifferencesResponse

    /**
     * Returns the base-64 encoded contents of a specified file and its metadata.
     */
    public suspend fun getFile(input: GetFileRequest): GetFileResponse

    /**
     * Returns the contents of a specified folder in a repository.
     */
    public suspend fun getFolder(input: GetFolderRequest): GetFolderResponse

    /**
     * Returns information about a specified merge commit.
     */
    public suspend fun getMergeCommit(input: GetMergeCommitRequest): GetMergeCommitResponse

    /**
     * Returns information about merge conflicts between the before and after commit IDs for a pull request in a repository.
     */
    public suspend fun getMergeConflicts(input: GetMergeConflictsRequest): GetMergeConflictsResponse

    /**
     * Returns information about the merge options available for merging two specified branches. For details about why a merge option is not available, use GetMergeConflicts or DescribeMergeConflicts.
     */
    public suspend fun getMergeOptions(input: GetMergeOptionsRequest): GetMergeOptionsResponse

    /**
     * Gets information about a pull request in a specified repository.
     */
    public suspend fun getPullRequest(input: GetPullRequestRequest): GetPullRequestResponse

    /**
     * Gets information about the approval states for a specified pull request. Approval states only apply to pull requests that have one or more approval rules applied to them.
     */
    public suspend fun getPullRequestApprovalStates(input: GetPullRequestApprovalStatesRequest): GetPullRequestApprovalStatesResponse

    /**
     * Returns information about whether approval rules have been set aside (overridden) for a pull request, and if so, the Amazon Resource Name (ARN) of the user or identity that overrode the rules and their requirements for the pull request.
     */
    public suspend fun getPullRequestOverrideState(input: GetPullRequestOverrideStateRequest): GetPullRequestOverrideStateResponse

    /**
     * Returns information about a repository.
     *
     * The description field for a repository accepts all HTML characters and all valid Unicode characters. Applications that do not HTML-encode the description and display it in a webpage can expose users to potentially malicious code. Make sure that you HTML-encode the description field in any application that uses this API to display the repository description on a webpage.
     */
    public suspend fun getRepository(input: GetRepositoryRequest): GetRepositoryResponse

    /**
     * Gets information about triggers configured for a repository.
     */
    public suspend fun getRepositoryTriggers(input: GetRepositoryTriggersRequest): GetRepositoryTriggersResponse

    /**
     * Lists all approval rule templates in the specified AWS Region in your AWS account. If an AWS Region is not specified, the AWS Region where you are signed in is used.
     */
    public suspend fun listApprovalRuleTemplates(input: ListApprovalRuleTemplatesRequest = ListApprovalRuleTemplatesRequest {}): ListApprovalRuleTemplatesResponse

    /**
     * Lists all approval rule templates that are associated with a specified repository.
     */
    public suspend fun listAssociatedApprovalRuleTemplatesForRepository(input: ListAssociatedApprovalRuleTemplatesForRepositoryRequest): ListAssociatedApprovalRuleTemplatesForRepositoryResponse

    /**
     * Gets information about one or more branches in a repository.
     */
    public suspend fun listBranches(input: ListBranchesRequest): ListBranchesResponse

    /**
     * Returns a list of pull requests for a specified repository. The return list can be refined by pull request status or pull request author ARN.
     */
    public suspend fun listPullRequests(input: ListPullRequestsRequest): ListPullRequestsResponse

    /**
     * Gets information about one or more repositories.
     */
    public suspend fun listRepositories(input: ListRepositoriesRequest = ListRepositoriesRequest {}): ListRepositoriesResponse

    /**
     * Lists all repositories associated with the specified approval rule template.
     */
    public suspend fun listRepositoriesForApprovalRuleTemplate(input: ListRepositoriesForApprovalRuleTemplateRequest): ListRepositoriesForApprovalRuleTemplateResponse

    /**
     * Gets information about AWS tags for a specified Amazon Resource Name (ARN) in AWS CodeCommit. For a list of valid resources in AWS CodeCommit, see [CodeCommit Resources and Operations](https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-iam-access-control-identity-based.html#arn-formats) in the* AWS CodeCommit User Guide*.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Merges two branches using the fast-forward merge strategy.
     */
    public suspend fun mergeBranchesByFastForward(input: MergeBranchesByFastForwardRequest): MergeBranchesByFastForwardResponse

    /**
     * Merges two branches using the squash merge strategy.
     */
    public suspend fun mergeBranchesBySquash(input: MergeBranchesBySquashRequest): MergeBranchesBySquashResponse

    /**
     * Merges two specified branches using the three-way merge strategy.
     */
    public suspend fun mergeBranchesByThreeWay(input: MergeBranchesByThreeWayRequest): MergeBranchesByThreeWayResponse

    /**
     * Attempts to merge the source commit of a pull request into the specified destination branch for that pull request at the specified commit using the fast-forward merge strategy. If the merge is successful, it closes the pull request.
     */
    public suspend fun mergePullRequestByFastForward(input: MergePullRequestByFastForwardRequest): MergePullRequestByFastForwardResponse

    /**
     * Attempts to merge the source commit of a pull request into the specified destination branch for that pull request at the specified commit using the squash merge strategy. If the merge is successful, it closes the pull request.
     */
    public suspend fun mergePullRequestBySquash(input: MergePullRequestBySquashRequest): MergePullRequestBySquashResponse

    /**
     * Attempts to merge the source commit of a pull request into the specified destination branch for that pull request at the specified commit using the three-way merge strategy. If the merge is successful, it closes the pull request.
     */
    public suspend fun mergePullRequestByThreeWay(input: MergePullRequestByThreeWayRequest): MergePullRequestByThreeWayResponse

    /**
     * Sets aside (overrides) all approval rule requirements for a specified pull request.
     */
    public suspend fun overridePullRequestApprovalRules(input: OverridePullRequestApprovalRulesRequest): OverridePullRequestApprovalRulesResponse

    /**
     * Posts a comment on the comparison between two commits.
     */
    public suspend fun postCommentForComparedCommit(input: PostCommentForComparedCommitRequest): PostCommentForComparedCommitResponse

    /**
     * Posts a comment on a pull request.
     */
    public suspend fun postCommentForPullRequest(input: PostCommentForPullRequestRequest): PostCommentForPullRequestResponse

    /**
     * Posts a comment in reply to an existing comment on a comparison between commits or a pull request.
     */
    public suspend fun postCommentReply(input: PostCommentReplyRequest): PostCommentReplyResponse

    /**
     * Adds or updates a reaction to a specified comment for the user whose identity is used to make the request. You can only add or update a reaction for yourself. You cannot add, modify, or delete a reaction for another user.
     */
    public suspend fun putCommentReaction(input: PutCommentReactionRequest): PutCommentReactionResponse

    /**
     * Adds or updates a file in a branch in an AWS CodeCommit repository, and generates a commit for the addition in the specified branch.
     */
    public suspend fun putFile(input: PutFileRequest): PutFileResponse

    /**
     * Replaces all triggers for a repository. Used to create or delete triggers.
     */
    public suspend fun putRepositoryTriggers(input: PutRepositoryTriggersRequest): PutRepositoryTriggersResponse

    /**
     * Adds or updates tags for a resource in AWS CodeCommit. For a list of valid resources in AWS CodeCommit, see [CodeCommit Resources and Operations](https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-iam-access-control-identity-based.html#arn-formats) in the *AWS CodeCommit User Guide*.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Tests the functionality of repository triggers by sending information to the trigger target. If real data is available in the repository, the test sends data from the last commit. If no data is available, sample data is generated.
     */
    public suspend fun testRepositoryTriggers(input: TestRepositoryTriggersRequest): TestRepositoryTriggersResponse

    /**
     * Removes tags for a resource in AWS CodeCommit. For a list of valid resources in AWS CodeCommit, see [CodeCommit Resources and Operations](https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-iam-access-control-identity-based.html#arn-formats) in the *AWS CodeCommit User Guide*.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates the content of an approval rule template. You can change the number of required approvals, the membership of the approval rule, and whether an approval pool is defined.
     */
    public suspend fun updateApprovalRuleTemplateContent(input: UpdateApprovalRuleTemplateContentRequest): UpdateApprovalRuleTemplateContentResponse

    /**
     * Updates the description for a specified approval rule template.
     */
    public suspend fun updateApprovalRuleTemplateDescription(input: UpdateApprovalRuleTemplateDescriptionRequest): UpdateApprovalRuleTemplateDescriptionResponse

    /**
     * Updates the name of a specified approval rule template.
     */
    public suspend fun updateApprovalRuleTemplateName(input: UpdateApprovalRuleTemplateNameRequest): UpdateApprovalRuleTemplateNameResponse

    /**
     * Replaces the contents of a comment.
     */
    public suspend fun updateComment(input: UpdateCommentRequest): UpdateCommentResponse

    /**
     * Sets or changes the default branch name for the specified repository.
     *
     * If you use this operation to change the default branch name to the current default branch name, a success message is returned even though the default branch did not change.
     */
    public suspend fun updateDefaultBranch(input: UpdateDefaultBranchRequest): UpdateDefaultBranchResponse

    /**
     * Updates the structure of an approval rule created specifically for a pull request. For example, you can change the number of required approvers and the approval pool for approvers.
     */
    public suspend fun updatePullRequestApprovalRuleContent(input: UpdatePullRequestApprovalRuleContentRequest): UpdatePullRequestApprovalRuleContentResponse

    /**
     * Updates the state of a user's approval on a pull request. The user is derived from the signed-in account when the request is made.
     */
    public suspend fun updatePullRequestApprovalState(input: UpdatePullRequestApprovalStateRequest): UpdatePullRequestApprovalStateResponse

    /**
     * Replaces the contents of the description of a pull request.
     */
    public suspend fun updatePullRequestDescription(input: UpdatePullRequestDescriptionRequest): UpdatePullRequestDescriptionResponse

    /**
     * Updates the status of a pull request.
     */
    public suspend fun updatePullRequestStatus(input: UpdatePullRequestStatusRequest): UpdatePullRequestStatusResponse

    /**
     * Replaces the title of a pull request.
     */
    public suspend fun updatePullRequestTitle(input: UpdatePullRequestTitleRequest): UpdatePullRequestTitleResponse

    /**
     * Sets or changes the comment or description for a repository.
     *
     * The description field for a repository accepts all HTML characters and all valid Unicode characters. Applications that do not HTML-encode the description and display it in a webpage can expose users to potentially malicious code. Make sure that you HTML-encode the description field in any application that uses this API to display the repository description on a webpage.
     */
    public suspend fun updateRepositoryDescription(input: UpdateRepositoryDescriptionRequest): UpdateRepositoryDescriptionResponse

    /**
     * Renames a repository. The repository name must be unique across the calling AWS account. Repository names are limited to 100 alphanumeric, dash, and underscore characters, and cannot include certain characters. The suffix .git is prohibited. For more information about the limits on repository names, see [Limits](https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html) in the AWS CodeCommit User Guide.
     */
    public suspend fun updateRepositoryName(input: UpdateRepositoryNameRequest): UpdateRepositoryNameResponse
}

/**
 * Creates an association between an approval rule template and a specified repository. Then, the next time a pull request is created in the repository where the destination reference (if specified) matches the destination reference (branch) for the pull request, an approval rule that matches the template conditions is automatically created for that pull request. If no destination references are specified in the template, an approval rule that matches the template contents is created for all pull requests in that repository.
 */
public suspend inline fun CodeCommitClient.associateApprovalRuleTemplateWithRepository(crossinline block: AssociateApprovalRuleTemplateWithRepositoryRequest.Builder.() -> Unit): AssociateApprovalRuleTemplateWithRepositoryResponse = associateApprovalRuleTemplateWithRepository(AssociateApprovalRuleTemplateWithRepositoryRequest.Builder().apply(block).build())

/**
 * Creates an association between an approval rule template and one or more specified repositories.
 */
public suspend inline fun CodeCommitClient.batchAssociateApprovalRuleTemplateWithRepositories(crossinline block: BatchAssociateApprovalRuleTemplateWithRepositoriesRequest.Builder.() -> Unit): BatchAssociateApprovalRuleTemplateWithRepositoriesResponse = batchAssociateApprovalRuleTemplateWithRepositories(BatchAssociateApprovalRuleTemplateWithRepositoriesRequest.Builder().apply(block).build())

/**
 * Returns information about one or more merge conflicts in the attempted merge of two commit specifiers using the squash or three-way merge strategy.
 */
public suspend inline fun CodeCommitClient.batchDescribeMergeConflicts(crossinline block: BatchDescribeMergeConflictsRequest.Builder.() -> Unit): BatchDescribeMergeConflictsResponse = batchDescribeMergeConflicts(BatchDescribeMergeConflictsRequest.Builder().apply(block).build())

/**
 * Removes the association between an approval rule template and one or more specified repositories.
 */
public suspend inline fun CodeCommitClient.batchDisassociateApprovalRuleTemplateFromRepositories(crossinline block: BatchDisassociateApprovalRuleTemplateFromRepositoriesRequest.Builder.() -> Unit): BatchDisassociateApprovalRuleTemplateFromRepositoriesResponse = batchDisassociateApprovalRuleTemplateFromRepositories(BatchDisassociateApprovalRuleTemplateFromRepositoriesRequest.Builder().apply(block).build())

/**
 * Returns information about the contents of one or more commits in a repository.
 */
public suspend inline fun CodeCommitClient.batchGetCommits(crossinline block: BatchGetCommitsRequest.Builder.() -> Unit): BatchGetCommitsResponse = batchGetCommits(BatchGetCommitsRequest.Builder().apply(block).build())

/**
 * Returns information about one or more repositories.
 *
 * The description field for a repository accepts all HTML characters and all valid Unicode characters. Applications that do not HTML-encode the description and display it in a webpage can expose users to potentially malicious code. Make sure that you HTML-encode the description field in any application that uses this API to display the repository description on a webpage.
 */
public suspend inline fun CodeCommitClient.batchGetRepositories(crossinline block: BatchGetRepositoriesRequest.Builder.() -> Unit): BatchGetRepositoriesResponse = batchGetRepositories(BatchGetRepositoriesRequest.Builder().apply(block).build())

/**
 * Creates a template for approval rules that can then be associated with one or more repositories in your AWS account. When you associate a template with a repository, AWS CodeCommit creates an approval rule that matches the conditions of the template for all pull requests that meet the conditions of the template. For more information, see AssociateApprovalRuleTemplateWithRepository.
 */
public suspend inline fun CodeCommitClient.createApprovalRuleTemplate(crossinline block: CreateApprovalRuleTemplateRequest.Builder.() -> Unit): CreateApprovalRuleTemplateResponse = createApprovalRuleTemplate(CreateApprovalRuleTemplateRequest.Builder().apply(block).build())

/**
 * Creates a branch in a repository and points the branch to a commit.
 *
 * Calling the create branch operation does not set a repository's default branch. To do this, call the update default branch operation.
 */
public suspend inline fun CodeCommitClient.createBranch(crossinline block: CreateBranchRequest.Builder.() -> Unit): CreateBranchResponse = createBranch(CreateBranchRequest.Builder().apply(block).build())

/**
 * Creates a commit for a repository on the tip of a specified branch.
 */
public suspend inline fun CodeCommitClient.createCommit(crossinline block: CreateCommitRequest.Builder.() -> Unit): CreateCommitResponse = createCommit(CreateCommitRequest.Builder().apply(block).build())

/**
 * Creates a pull request in the specified repository.
 */
public suspend inline fun CodeCommitClient.createPullRequest(crossinline block: CreatePullRequestRequest.Builder.() -> Unit): CreatePullRequestResponse = createPullRequest(CreatePullRequestRequest.Builder().apply(block).build())

/**
 * Creates an approval rule for a pull request.
 */
public suspend inline fun CodeCommitClient.createPullRequestApprovalRule(crossinline block: CreatePullRequestApprovalRuleRequest.Builder.() -> Unit): CreatePullRequestApprovalRuleResponse = createPullRequestApprovalRule(CreatePullRequestApprovalRuleRequest.Builder().apply(block).build())

/**
 * Creates a new, empty repository.
 */
public suspend inline fun CodeCommitClient.createRepository(crossinline block: CreateRepositoryRequest.Builder.() -> Unit): CreateRepositoryResponse = createRepository(CreateRepositoryRequest.Builder().apply(block).build())

/**
 * Creates an unreferenced commit that represents the result of merging two branches using a specified merge strategy. This can help you determine the outcome of a potential merge. This API cannot be used with the fast-forward merge strategy because that strategy does not create a merge commit.
 *
 * This unreferenced merge commit can only be accessed using the GetCommit API or through git commands such as git fetch. To retrieve this commit, you must specify its commit ID or otherwise reference it.
 */
public suspend inline fun CodeCommitClient.createUnreferencedMergeCommit(crossinline block: CreateUnreferencedMergeCommitRequest.Builder.() -> Unit): CreateUnreferencedMergeCommitResponse = createUnreferencedMergeCommit(CreateUnreferencedMergeCommitRequest.Builder().apply(block).build())

/**
 * Deletes a specified approval rule template. Deleting a template does not remove approval rules on pull requests already created with the template.
 */
public suspend inline fun CodeCommitClient.deleteApprovalRuleTemplate(crossinline block: DeleteApprovalRuleTemplateRequest.Builder.() -> Unit): DeleteApprovalRuleTemplateResponse = deleteApprovalRuleTemplate(DeleteApprovalRuleTemplateRequest.Builder().apply(block).build())

/**
 * Deletes a branch from a repository, unless that branch is the default branch for the repository.
 */
public suspend inline fun CodeCommitClient.deleteBranch(crossinline block: DeleteBranchRequest.Builder.() -> Unit): DeleteBranchResponse = deleteBranch(DeleteBranchRequest.Builder().apply(block).build())

/**
 * Deletes the content of a comment made on a change, file, or commit in a repository.
 */
public suspend inline fun CodeCommitClient.deleteCommentContent(crossinline block: DeleteCommentContentRequest.Builder.() -> Unit): DeleteCommentContentResponse = deleteCommentContent(DeleteCommentContentRequest.Builder().apply(block).build())

/**
 * Deletes a specified file from a specified branch. A commit is created on the branch that contains the revision. The file still exists in the commits earlier to the commit that contains the deletion.
 */
public suspend inline fun CodeCommitClient.deleteFile(crossinline block: DeleteFileRequest.Builder.() -> Unit): DeleteFileResponse = deleteFile(DeleteFileRequest.Builder().apply(block).build())

/**
 * Deletes an approval rule from a specified pull request. Approval rules can be deleted from a pull request only if the pull request is open, and if the approval rule was created specifically for a pull request and not generated from an approval rule template associated with the repository where the pull request was created. You cannot delete an approval rule from a merged or closed pull request.
 */
public suspend inline fun CodeCommitClient.deletePullRequestApprovalRule(crossinline block: DeletePullRequestApprovalRuleRequest.Builder.() -> Unit): DeletePullRequestApprovalRuleResponse = deletePullRequestApprovalRule(DeletePullRequestApprovalRuleRequest.Builder().apply(block).build())

/**
 * Deletes a repository. If a specified repository was already deleted, a null repository ID is returned.
 *
 * Deleting a repository also deletes all associated objects and metadata. After a repository is deleted, all future push calls to the deleted repository fail.
 */
public suspend inline fun CodeCommitClient.deleteRepository(crossinline block: DeleteRepositoryRequest.Builder.() -> Unit): DeleteRepositoryResponse = deleteRepository(DeleteRepositoryRequest.Builder().apply(block).build())

/**
 * Returns information about one or more merge conflicts in the attempted merge of two commit specifiers using the squash or three-way merge strategy. If the merge option for the attempted merge is specified as FAST_FORWARD_MERGE, an exception is thrown.
 */
public suspend inline fun CodeCommitClient.describeMergeConflicts(crossinline block: DescribeMergeConflictsRequest.Builder.() -> Unit): DescribeMergeConflictsResponse = describeMergeConflicts(DescribeMergeConflictsRequest.Builder().apply(block).build())

/**
 * Returns information about one or more pull request events.
 */
public suspend inline fun CodeCommitClient.describePullRequestEvents(crossinline block: DescribePullRequestEventsRequest.Builder.() -> Unit): DescribePullRequestEventsResponse = describePullRequestEvents(DescribePullRequestEventsRequest.Builder().apply(block).build())

/**
 * Removes the association between a template and a repository so that approval rules based on the template are not automatically created when pull requests are created in the specified repository. This does not delete any approval rules previously created for pull requests through the template association.
 */
public suspend inline fun CodeCommitClient.disassociateApprovalRuleTemplateFromRepository(crossinline block: DisassociateApprovalRuleTemplateFromRepositoryRequest.Builder.() -> Unit): DisassociateApprovalRuleTemplateFromRepositoryResponse = disassociateApprovalRuleTemplateFromRepository(DisassociateApprovalRuleTemplateFromRepositoryRequest.Builder().apply(block).build())

/**
 * Evaluates whether a pull request has met all the conditions specified in its associated approval rules.
 */
public suspend inline fun CodeCommitClient.evaluatePullRequestApprovalRules(crossinline block: EvaluatePullRequestApprovalRulesRequest.Builder.() -> Unit): EvaluatePullRequestApprovalRulesResponse = evaluatePullRequestApprovalRules(EvaluatePullRequestApprovalRulesRequest.Builder().apply(block).build())

/**
 * Returns information about a specified approval rule template.
 */
public suspend inline fun CodeCommitClient.getApprovalRuleTemplate(crossinline block: GetApprovalRuleTemplateRequest.Builder.() -> Unit): GetApprovalRuleTemplateResponse = getApprovalRuleTemplate(GetApprovalRuleTemplateRequest.Builder().apply(block).build())

/**
 * Returns the base-64 encoded content of an individual blob in a repository.
 */
public suspend inline fun CodeCommitClient.getBlob(crossinline block: GetBlobRequest.Builder.() -> Unit): GetBlobResponse = getBlob(GetBlobRequest.Builder().apply(block).build())

/**
 * Returns information about a repository branch, including its name and the last commit ID.
 */
public suspend inline fun CodeCommitClient.getBranch(crossinline block: GetBranchRequest.Builder.() -> Unit): GetBranchResponse = getBranch(GetBranchRequest.Builder().apply(block).build())

/**
 * Returns the content of a comment made on a change, file, or commit in a repository.
 *
 * Reaction counts might include numbers from user identities who were deleted after the reaction was made. For a count of reactions from active identities, use GetCommentReactions.
 */
public suspend inline fun CodeCommitClient.getComment(crossinline block: GetCommentRequest.Builder.() -> Unit): GetCommentResponse = getComment(GetCommentRequest.Builder().apply(block).build())

/**
 * Returns information about reactions to a specified comment ID. Reactions from users who have been deleted will not be included in the count.
 */
public suspend inline fun CodeCommitClient.getCommentReactions(crossinline block: GetCommentReactionsRequest.Builder.() -> Unit): GetCommentReactionsResponse = getCommentReactions(GetCommentReactionsRequest.Builder().apply(block).build())

/**
 * Returns information about comments made on the comparison between two commits.
 *
 * Reaction counts might include numbers from user identities who were deleted after the reaction was made. For a count of reactions from active identities, use GetCommentReactions.
 */
public suspend inline fun CodeCommitClient.getCommentsForComparedCommit(crossinline block: GetCommentsForComparedCommitRequest.Builder.() -> Unit): GetCommentsForComparedCommitResponse = getCommentsForComparedCommit(GetCommentsForComparedCommitRequest.Builder().apply(block).build())

/**
 * Returns comments made on a pull request.
 *
 * Reaction counts might include numbers from user identities who were deleted after the reaction was made. For a count of reactions from active identities, use GetCommentReactions.
 */
public suspend inline fun CodeCommitClient.getCommentsForPullRequest(crossinline block: GetCommentsForPullRequestRequest.Builder.() -> Unit): GetCommentsForPullRequestResponse = getCommentsForPullRequest(GetCommentsForPullRequestRequest.Builder().apply(block).build())

/**
 * Returns information about a commit, including commit message and committer information.
 */
public suspend inline fun CodeCommitClient.getCommit(crossinline block: GetCommitRequest.Builder.() -> Unit): GetCommitResponse = getCommit(GetCommitRequest.Builder().apply(block).build())

/**
 * Returns information about the differences in a valid commit specifier (such as a branch, tag, HEAD, commit ID, or other fully qualified reference). Results can be limited to a specified path.
 */
public suspend inline fun CodeCommitClient.getDifferences(crossinline block: GetDifferencesRequest.Builder.() -> Unit): GetDifferencesResponse = getDifferences(GetDifferencesRequest.Builder().apply(block).build())

/**
 * Returns the base-64 encoded contents of a specified file and its metadata.
 */
public suspend inline fun CodeCommitClient.getFile(crossinline block: GetFileRequest.Builder.() -> Unit): GetFileResponse = getFile(GetFileRequest.Builder().apply(block).build())

/**
 * Returns the contents of a specified folder in a repository.
 */
public suspend inline fun CodeCommitClient.getFolder(crossinline block: GetFolderRequest.Builder.() -> Unit): GetFolderResponse = getFolder(GetFolderRequest.Builder().apply(block).build())

/**
 * Returns information about a specified merge commit.
 */
public suspend inline fun CodeCommitClient.getMergeCommit(crossinline block: GetMergeCommitRequest.Builder.() -> Unit): GetMergeCommitResponse = getMergeCommit(GetMergeCommitRequest.Builder().apply(block).build())

/**
 * Returns information about merge conflicts between the before and after commit IDs for a pull request in a repository.
 */
public suspend inline fun CodeCommitClient.getMergeConflicts(crossinline block: GetMergeConflictsRequest.Builder.() -> Unit): GetMergeConflictsResponse = getMergeConflicts(GetMergeConflictsRequest.Builder().apply(block).build())

/**
 * Returns information about the merge options available for merging two specified branches. For details about why a merge option is not available, use GetMergeConflicts or DescribeMergeConflicts.
 */
public suspend inline fun CodeCommitClient.getMergeOptions(crossinline block: GetMergeOptionsRequest.Builder.() -> Unit): GetMergeOptionsResponse = getMergeOptions(GetMergeOptionsRequest.Builder().apply(block).build())

/**
 * Gets information about a pull request in a specified repository.
 */
public suspend inline fun CodeCommitClient.getPullRequest(crossinline block: GetPullRequestRequest.Builder.() -> Unit): GetPullRequestResponse = getPullRequest(GetPullRequestRequest.Builder().apply(block).build())

/**
 * Gets information about the approval states for a specified pull request. Approval states only apply to pull requests that have one or more approval rules applied to them.
 */
public suspend inline fun CodeCommitClient.getPullRequestApprovalStates(crossinline block: GetPullRequestApprovalStatesRequest.Builder.() -> Unit): GetPullRequestApprovalStatesResponse = getPullRequestApprovalStates(GetPullRequestApprovalStatesRequest.Builder().apply(block).build())

/**
 * Returns information about whether approval rules have been set aside (overridden) for a pull request, and if so, the Amazon Resource Name (ARN) of the user or identity that overrode the rules and their requirements for the pull request.
 */
public suspend inline fun CodeCommitClient.getPullRequestOverrideState(crossinline block: GetPullRequestOverrideStateRequest.Builder.() -> Unit): GetPullRequestOverrideStateResponse = getPullRequestOverrideState(GetPullRequestOverrideStateRequest.Builder().apply(block).build())

/**
 * Returns information about a repository.
 *
 * The description field for a repository accepts all HTML characters and all valid Unicode characters. Applications that do not HTML-encode the description and display it in a webpage can expose users to potentially malicious code. Make sure that you HTML-encode the description field in any application that uses this API to display the repository description on a webpage.
 */
public suspend inline fun CodeCommitClient.getRepository(crossinline block: GetRepositoryRequest.Builder.() -> Unit): GetRepositoryResponse = getRepository(GetRepositoryRequest.Builder().apply(block).build())

/**
 * Gets information about triggers configured for a repository.
 */
public suspend inline fun CodeCommitClient.getRepositoryTriggers(crossinline block: GetRepositoryTriggersRequest.Builder.() -> Unit): GetRepositoryTriggersResponse = getRepositoryTriggers(GetRepositoryTriggersRequest.Builder().apply(block).build())

/**
 * Lists all approval rule templates in the specified AWS Region in your AWS account. If an AWS Region is not specified, the AWS Region where you are signed in is used.
 */
public suspend inline fun CodeCommitClient.listApprovalRuleTemplates(crossinline block: ListApprovalRuleTemplatesRequest.Builder.() -> Unit): ListApprovalRuleTemplatesResponse = listApprovalRuleTemplates(ListApprovalRuleTemplatesRequest.Builder().apply(block).build())

/**
 * Lists all approval rule templates that are associated with a specified repository.
 */
public suspend inline fun CodeCommitClient.listAssociatedApprovalRuleTemplatesForRepository(crossinline block: ListAssociatedApprovalRuleTemplatesForRepositoryRequest.Builder.() -> Unit): ListAssociatedApprovalRuleTemplatesForRepositoryResponse = listAssociatedApprovalRuleTemplatesForRepository(ListAssociatedApprovalRuleTemplatesForRepositoryRequest.Builder().apply(block).build())

/**
 * Gets information about one or more branches in a repository.
 */
public suspend inline fun CodeCommitClient.listBranches(crossinline block: ListBranchesRequest.Builder.() -> Unit): ListBranchesResponse = listBranches(ListBranchesRequest.Builder().apply(block).build())

/**
 * Returns a list of pull requests for a specified repository. The return list can be refined by pull request status or pull request author ARN.
 */
public suspend inline fun CodeCommitClient.listPullRequests(crossinline block: ListPullRequestsRequest.Builder.() -> Unit): ListPullRequestsResponse = listPullRequests(ListPullRequestsRequest.Builder().apply(block).build())

/**
 * Gets information about one or more repositories.
 */
public suspend inline fun CodeCommitClient.listRepositories(crossinline block: ListRepositoriesRequest.Builder.() -> Unit): ListRepositoriesResponse = listRepositories(ListRepositoriesRequest.Builder().apply(block).build())

/**
 * Lists all repositories associated with the specified approval rule template.
 */
public suspend inline fun CodeCommitClient.listRepositoriesForApprovalRuleTemplate(crossinline block: ListRepositoriesForApprovalRuleTemplateRequest.Builder.() -> Unit): ListRepositoriesForApprovalRuleTemplateResponse = listRepositoriesForApprovalRuleTemplate(ListRepositoriesForApprovalRuleTemplateRequest.Builder().apply(block).build())

/**
 * Gets information about AWS tags for a specified Amazon Resource Name (ARN) in AWS CodeCommit. For a list of valid resources in AWS CodeCommit, see [CodeCommit Resources and Operations](https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-iam-access-control-identity-based.html#arn-formats) in the* AWS CodeCommit User Guide*.
 */
public suspend inline fun CodeCommitClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Merges two branches using the fast-forward merge strategy.
 */
public suspend inline fun CodeCommitClient.mergeBranchesByFastForward(crossinline block: MergeBranchesByFastForwardRequest.Builder.() -> Unit): MergeBranchesByFastForwardResponse = mergeBranchesByFastForward(MergeBranchesByFastForwardRequest.Builder().apply(block).build())

/**
 * Merges two branches using the squash merge strategy.
 */
public suspend inline fun CodeCommitClient.mergeBranchesBySquash(crossinline block: MergeBranchesBySquashRequest.Builder.() -> Unit): MergeBranchesBySquashResponse = mergeBranchesBySquash(MergeBranchesBySquashRequest.Builder().apply(block).build())

/**
 * Merges two specified branches using the three-way merge strategy.
 */
public suspend inline fun CodeCommitClient.mergeBranchesByThreeWay(crossinline block: MergeBranchesByThreeWayRequest.Builder.() -> Unit): MergeBranchesByThreeWayResponse = mergeBranchesByThreeWay(MergeBranchesByThreeWayRequest.Builder().apply(block).build())

/**
 * Attempts to merge the source commit of a pull request into the specified destination branch for that pull request at the specified commit using the fast-forward merge strategy. If the merge is successful, it closes the pull request.
 */
public suspend inline fun CodeCommitClient.mergePullRequestByFastForward(crossinline block: MergePullRequestByFastForwardRequest.Builder.() -> Unit): MergePullRequestByFastForwardResponse = mergePullRequestByFastForward(MergePullRequestByFastForwardRequest.Builder().apply(block).build())

/**
 * Attempts to merge the source commit of a pull request into the specified destination branch for that pull request at the specified commit using the squash merge strategy. If the merge is successful, it closes the pull request.
 */
public suspend inline fun CodeCommitClient.mergePullRequestBySquash(crossinline block: MergePullRequestBySquashRequest.Builder.() -> Unit): MergePullRequestBySquashResponse = mergePullRequestBySquash(MergePullRequestBySquashRequest.Builder().apply(block).build())

/**
 * Attempts to merge the source commit of a pull request into the specified destination branch for that pull request at the specified commit using the three-way merge strategy. If the merge is successful, it closes the pull request.
 */
public suspend inline fun CodeCommitClient.mergePullRequestByThreeWay(crossinline block: MergePullRequestByThreeWayRequest.Builder.() -> Unit): MergePullRequestByThreeWayResponse = mergePullRequestByThreeWay(MergePullRequestByThreeWayRequest.Builder().apply(block).build())

/**
 * Sets aside (overrides) all approval rule requirements for a specified pull request.
 */
public suspend inline fun CodeCommitClient.overridePullRequestApprovalRules(crossinline block: OverridePullRequestApprovalRulesRequest.Builder.() -> Unit): OverridePullRequestApprovalRulesResponse = overridePullRequestApprovalRules(OverridePullRequestApprovalRulesRequest.Builder().apply(block).build())

/**
 * Posts a comment on the comparison between two commits.
 */
public suspend inline fun CodeCommitClient.postCommentForComparedCommit(crossinline block: PostCommentForComparedCommitRequest.Builder.() -> Unit): PostCommentForComparedCommitResponse = postCommentForComparedCommit(PostCommentForComparedCommitRequest.Builder().apply(block).build())

/**
 * Posts a comment on a pull request.
 */
public suspend inline fun CodeCommitClient.postCommentForPullRequest(crossinline block: PostCommentForPullRequestRequest.Builder.() -> Unit): PostCommentForPullRequestResponse = postCommentForPullRequest(PostCommentForPullRequestRequest.Builder().apply(block).build())

/**
 * Posts a comment in reply to an existing comment on a comparison between commits or a pull request.
 */
public suspend inline fun CodeCommitClient.postCommentReply(crossinline block: PostCommentReplyRequest.Builder.() -> Unit): PostCommentReplyResponse = postCommentReply(PostCommentReplyRequest.Builder().apply(block).build())

/**
 * Adds or updates a reaction to a specified comment for the user whose identity is used to make the request. You can only add or update a reaction for yourself. You cannot add, modify, or delete a reaction for another user.
 */
public suspend inline fun CodeCommitClient.putCommentReaction(crossinline block: PutCommentReactionRequest.Builder.() -> Unit): PutCommentReactionResponse = putCommentReaction(PutCommentReactionRequest.Builder().apply(block).build())

/**
 * Adds or updates a file in a branch in an AWS CodeCommit repository, and generates a commit for the addition in the specified branch.
 */
public suspend inline fun CodeCommitClient.putFile(crossinline block: PutFileRequest.Builder.() -> Unit): PutFileResponse = putFile(PutFileRequest.Builder().apply(block).build())

/**
 * Replaces all triggers for a repository. Used to create or delete triggers.
 */
public suspend inline fun CodeCommitClient.putRepositoryTriggers(crossinline block: PutRepositoryTriggersRequest.Builder.() -> Unit): PutRepositoryTriggersResponse = putRepositoryTriggers(PutRepositoryTriggersRequest.Builder().apply(block).build())

/**
 * Adds or updates tags for a resource in AWS CodeCommit. For a list of valid resources in AWS CodeCommit, see [CodeCommit Resources and Operations](https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-iam-access-control-identity-based.html#arn-formats) in the *AWS CodeCommit User Guide*.
 */
public suspend inline fun CodeCommitClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Tests the functionality of repository triggers by sending information to the trigger target. If real data is available in the repository, the test sends data from the last commit. If no data is available, sample data is generated.
 */
public suspend inline fun CodeCommitClient.testRepositoryTriggers(crossinline block: TestRepositoryTriggersRequest.Builder.() -> Unit): TestRepositoryTriggersResponse = testRepositoryTriggers(TestRepositoryTriggersRequest.Builder().apply(block).build())

/**
 * Removes tags for a resource in AWS CodeCommit. For a list of valid resources in AWS CodeCommit, see [CodeCommit Resources and Operations](https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-iam-access-control-identity-based.html#arn-formats) in the *AWS CodeCommit User Guide*.
 */
public suspend inline fun CodeCommitClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates the content of an approval rule template. You can change the number of required approvals, the membership of the approval rule, and whether an approval pool is defined.
 */
public suspend inline fun CodeCommitClient.updateApprovalRuleTemplateContent(crossinline block: UpdateApprovalRuleTemplateContentRequest.Builder.() -> Unit): UpdateApprovalRuleTemplateContentResponse = updateApprovalRuleTemplateContent(UpdateApprovalRuleTemplateContentRequest.Builder().apply(block).build())

/**
 * Updates the description for a specified approval rule template.
 */
public suspend inline fun CodeCommitClient.updateApprovalRuleTemplateDescription(crossinline block: UpdateApprovalRuleTemplateDescriptionRequest.Builder.() -> Unit): UpdateApprovalRuleTemplateDescriptionResponse = updateApprovalRuleTemplateDescription(UpdateApprovalRuleTemplateDescriptionRequest.Builder().apply(block).build())

/**
 * Updates the name of a specified approval rule template.
 */
public suspend inline fun CodeCommitClient.updateApprovalRuleTemplateName(crossinline block: UpdateApprovalRuleTemplateNameRequest.Builder.() -> Unit): UpdateApprovalRuleTemplateNameResponse = updateApprovalRuleTemplateName(UpdateApprovalRuleTemplateNameRequest.Builder().apply(block).build())

/**
 * Replaces the contents of a comment.
 */
public suspend inline fun CodeCommitClient.updateComment(crossinline block: UpdateCommentRequest.Builder.() -> Unit): UpdateCommentResponse = updateComment(UpdateCommentRequest.Builder().apply(block).build())

/**
 * Sets or changes the default branch name for the specified repository.
 *
 * If you use this operation to change the default branch name to the current default branch name, a success message is returned even though the default branch did not change.
 */
public suspend inline fun CodeCommitClient.updateDefaultBranch(crossinline block: UpdateDefaultBranchRequest.Builder.() -> Unit): UpdateDefaultBranchResponse = updateDefaultBranch(UpdateDefaultBranchRequest.Builder().apply(block).build())

/**
 * Updates the structure of an approval rule created specifically for a pull request. For example, you can change the number of required approvers and the approval pool for approvers.
 */
public suspend inline fun CodeCommitClient.updatePullRequestApprovalRuleContent(crossinline block: UpdatePullRequestApprovalRuleContentRequest.Builder.() -> Unit): UpdatePullRequestApprovalRuleContentResponse = updatePullRequestApprovalRuleContent(UpdatePullRequestApprovalRuleContentRequest.Builder().apply(block).build())

/**
 * Updates the state of a user's approval on a pull request. The user is derived from the signed-in account when the request is made.
 */
public suspend inline fun CodeCommitClient.updatePullRequestApprovalState(crossinline block: UpdatePullRequestApprovalStateRequest.Builder.() -> Unit): UpdatePullRequestApprovalStateResponse = updatePullRequestApprovalState(UpdatePullRequestApprovalStateRequest.Builder().apply(block).build())

/**
 * Replaces the contents of the description of a pull request.
 */
public suspend inline fun CodeCommitClient.updatePullRequestDescription(crossinline block: UpdatePullRequestDescriptionRequest.Builder.() -> Unit): UpdatePullRequestDescriptionResponse = updatePullRequestDescription(UpdatePullRequestDescriptionRequest.Builder().apply(block).build())

/**
 * Updates the status of a pull request.
 */
public suspend inline fun CodeCommitClient.updatePullRequestStatus(crossinline block: UpdatePullRequestStatusRequest.Builder.() -> Unit): UpdatePullRequestStatusResponse = updatePullRequestStatus(UpdatePullRequestStatusRequest.Builder().apply(block).build())

/**
 * Replaces the title of a pull request.
 */
public suspend inline fun CodeCommitClient.updatePullRequestTitle(crossinline block: UpdatePullRequestTitleRequest.Builder.() -> Unit): UpdatePullRequestTitleResponse = updatePullRequestTitle(UpdatePullRequestTitleRequest.Builder().apply(block).build())

/**
 * Sets or changes the comment or description for a repository.
 *
 * The description field for a repository accepts all HTML characters and all valid Unicode characters. Applications that do not HTML-encode the description and display it in a webpage can expose users to potentially malicious code. Make sure that you HTML-encode the description field in any application that uses this API to display the repository description on a webpage.
 */
public suspend inline fun CodeCommitClient.updateRepositoryDescription(crossinline block: UpdateRepositoryDescriptionRequest.Builder.() -> Unit): UpdateRepositoryDescriptionResponse = updateRepositoryDescription(UpdateRepositoryDescriptionRequest.Builder().apply(block).build())

/**
 * Renames a repository. The repository name must be unique across the calling AWS account. Repository names are limited to 100 alphanumeric, dash, and underscore characters, and cannot include certain characters. The suffix .git is prohibited. For more information about the limits on repository names, see [Limits](https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html) in the AWS CodeCommit User Guide.
 */
public suspend inline fun CodeCommitClient.updateRepositoryName(crossinline block: UpdateRepositoryNameRequest.Builder.() -> Unit): UpdateRepositoryNameResponse = updateRepositoryName(UpdateRepositoryNameRequest.Builder().apply(block).build())
