// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecommit

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.runtime.protocol.json.AwsJsonProtocol
import aws.sdk.kotlin.services.codecommit.endpoints.internal.ResolveEndpointMiddleware
import aws.sdk.kotlin.services.codecommit.endpoints.internal.bindAwsBuiltins
import aws.sdk.kotlin.services.codecommit.model.*
import aws.sdk.kotlin.services.codecommit.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.operation.sdkRequestId
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.tracing.withRootTraceSpan
import aws.smithy.kotlin.runtime.util.putIfAbsent
import kotlin.coroutines.coroutineContext


public const val ServiceId: String = "CodeCommit"
public const val ServiceApiVersion: String = "2015-04-13"
public const val SdkVersion: String = "0.19.0-beta"

internal class DefaultCodeCommitClient(override val config: CodeCommitClient.Config) : CodeCommitClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Creates an association between an approval rule template and a specified repository. Then, the next time a pull request is created in the repository where the destination reference (if specified) matches the destination reference (branch) for the pull request, an approval rule that matches the template conditions is automatically created for that pull request. If no destination references are specified in the template, an approval rule that matches the template contents is created for all pull requests in that repository.
     */
    override suspend fun associateApprovalRuleTemplateWithRepository(input: AssociateApprovalRuleTemplateWithRepositoryRequest): AssociateApprovalRuleTemplateWithRepositoryResponse {
        val op = SdkHttpOperation.build<AssociateApprovalRuleTemplateWithRepositoryRequest, AssociateApprovalRuleTemplateWithRepositoryResponse> {
            serializer = AssociateApprovalRuleTemplateWithRepositoryOperationSerializer()
            deserializer = AssociateApprovalRuleTemplateWithRepositoryOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociateApprovalRuleTemplateWithRepository"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeCommit_20150413", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codecommit"
            }
        )
        val rootSpan = config.tracer.createRootSpan("AssociateApprovalRuleTemplateWithRepository-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates an association between an approval rule template and one or more specified repositories.
     */
    override suspend fun batchAssociateApprovalRuleTemplateWithRepositories(input: BatchAssociateApprovalRuleTemplateWithRepositoriesRequest): BatchAssociateApprovalRuleTemplateWithRepositoriesResponse {
        val op = SdkHttpOperation.build<BatchAssociateApprovalRuleTemplateWithRepositoriesRequest, BatchAssociateApprovalRuleTemplateWithRepositoriesResponse> {
            serializer = BatchAssociateApprovalRuleTemplateWithRepositoriesOperationSerializer()
            deserializer = BatchAssociateApprovalRuleTemplateWithRepositoriesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchAssociateApprovalRuleTemplateWithRepositories"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeCommit_20150413", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codecommit"
            }
        )
        val rootSpan = config.tracer.createRootSpan("BatchAssociateApprovalRuleTemplateWithRepositories-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns information about one or more merge conflicts in the attempted merge of two commit specifiers using the squash or three-way merge strategy.
     */
    override suspend fun batchDescribeMergeConflicts(input: BatchDescribeMergeConflictsRequest): BatchDescribeMergeConflictsResponse {
        val op = SdkHttpOperation.build<BatchDescribeMergeConflictsRequest, BatchDescribeMergeConflictsResponse> {
            serializer = BatchDescribeMergeConflictsOperationSerializer()
            deserializer = BatchDescribeMergeConflictsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchDescribeMergeConflicts"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeCommit_20150413", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codecommit"
            }
        )
        val rootSpan = config.tracer.createRootSpan("BatchDescribeMergeConflicts-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Removes the association between an approval rule template and one or more specified repositories.
     */
    override suspend fun batchDisassociateApprovalRuleTemplateFromRepositories(input: BatchDisassociateApprovalRuleTemplateFromRepositoriesRequest): BatchDisassociateApprovalRuleTemplateFromRepositoriesResponse {
        val op = SdkHttpOperation.build<BatchDisassociateApprovalRuleTemplateFromRepositoriesRequest, BatchDisassociateApprovalRuleTemplateFromRepositoriesResponse> {
            serializer = BatchDisassociateApprovalRuleTemplateFromRepositoriesOperationSerializer()
            deserializer = BatchDisassociateApprovalRuleTemplateFromRepositoriesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchDisassociateApprovalRuleTemplateFromRepositories"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeCommit_20150413", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codecommit"
            }
        )
        val rootSpan = config.tracer.createRootSpan("BatchDisassociateApprovalRuleTemplateFromRepositories-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns information about the contents of one or more commits in a repository.
     */
    override suspend fun batchGetCommits(input: BatchGetCommitsRequest): BatchGetCommitsResponse {
        val op = SdkHttpOperation.build<BatchGetCommitsRequest, BatchGetCommitsResponse> {
            serializer = BatchGetCommitsOperationSerializer()
            deserializer = BatchGetCommitsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchGetCommits"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeCommit_20150413", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codecommit"
            }
        )
        val rootSpan = config.tracer.createRootSpan("BatchGetCommits-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns information about one or more repositories.
     *
     * The description field for a repository accepts all HTML characters and all valid Unicode characters. Applications that do not HTML-encode the description and display it in a webpage can expose users to potentially malicious code. Make sure that you HTML-encode the description field in any application that uses this API to display the repository description on a webpage.
     */
    override suspend fun batchGetRepositories(input: BatchGetRepositoriesRequest): BatchGetRepositoriesResponse {
        val op = SdkHttpOperation.build<BatchGetRepositoriesRequest, BatchGetRepositoriesResponse> {
            serializer = BatchGetRepositoriesOperationSerializer()
            deserializer = BatchGetRepositoriesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchGetRepositories"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeCommit_20150413", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codecommit"
            }
        )
        val rootSpan = config.tracer.createRootSpan("BatchGetRepositories-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a template for approval rules that can then be associated with one or more repositories in your AWS account. When you associate a template with a repository, AWS CodeCommit creates an approval rule that matches the conditions of the template for all pull requests that meet the conditions of the template. For more information, see AssociateApprovalRuleTemplateWithRepository.
     */
    override suspend fun createApprovalRuleTemplate(input: CreateApprovalRuleTemplateRequest): CreateApprovalRuleTemplateResponse {
        val op = SdkHttpOperation.build<CreateApprovalRuleTemplateRequest, CreateApprovalRuleTemplateResponse> {
            serializer = CreateApprovalRuleTemplateOperationSerializer()
            deserializer = CreateApprovalRuleTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateApprovalRuleTemplate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeCommit_20150413", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codecommit"
            }
        )
        val rootSpan = config.tracer.createRootSpan("CreateApprovalRuleTemplate-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a branch in a repository and points the branch to a commit.
     *
     * Calling the create branch operation does not set a repository's default branch. To do this, call the update default branch operation.
     */
    override suspend fun createBranch(input: CreateBranchRequest): CreateBranchResponse {
        val op = SdkHttpOperation.build<CreateBranchRequest, CreateBranchResponse> {
            serializer = CreateBranchOperationSerializer()
            deserializer = CreateBranchOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateBranch"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeCommit_20150413", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codecommit"
            }
        )
        val rootSpan = config.tracer.createRootSpan("CreateBranch-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a commit for a repository on the tip of a specified branch.
     */
    override suspend fun createCommit(input: CreateCommitRequest): CreateCommitResponse {
        val op = SdkHttpOperation.build<CreateCommitRequest, CreateCommitResponse> {
            serializer = CreateCommitOperationSerializer()
            deserializer = CreateCommitOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateCommit"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeCommit_20150413", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codecommit"
            }
        )
        val rootSpan = config.tracer.createRootSpan("CreateCommit-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a pull request in the specified repository.
     */
    override suspend fun createPullRequest(input: CreatePullRequestRequest): CreatePullRequestResponse {
        val op = SdkHttpOperation.build<CreatePullRequestRequest, CreatePullRequestResponse> {
            serializer = CreatePullRequestOperationSerializer()
            deserializer = CreatePullRequestOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreatePullRequest"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeCommit_20150413", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codecommit"
            }
        )
        val rootSpan = config.tracer.createRootSpan("CreatePullRequest-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates an approval rule for a pull request.
     */
    override suspend fun createPullRequestApprovalRule(input: CreatePullRequestApprovalRuleRequest): CreatePullRequestApprovalRuleResponse {
        val op = SdkHttpOperation.build<CreatePullRequestApprovalRuleRequest, CreatePullRequestApprovalRuleResponse> {
            serializer = CreatePullRequestApprovalRuleOperationSerializer()
            deserializer = CreatePullRequestApprovalRuleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreatePullRequestApprovalRule"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeCommit_20150413", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codecommit"
            }
        )
        val rootSpan = config.tracer.createRootSpan("CreatePullRequestApprovalRule-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a new, empty repository.
     */
    override suspend fun createRepository(input: CreateRepositoryRequest): CreateRepositoryResponse {
        val op = SdkHttpOperation.build<CreateRepositoryRequest, CreateRepositoryResponse> {
            serializer = CreateRepositoryOperationSerializer()
            deserializer = CreateRepositoryOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateRepository"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeCommit_20150413", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codecommit"
            }
        )
        val rootSpan = config.tracer.createRootSpan("CreateRepository-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates an unreferenced commit that represents the result of merging two branches using a specified merge strategy. This can help you determine the outcome of a potential merge. This API cannot be used with the fast-forward merge strategy because that strategy does not create a merge commit.
     *
     * This unreferenced merge commit can only be accessed using the GetCommit API or through git commands such as git fetch. To retrieve this commit, you must specify its commit ID or otherwise reference it.
     */
    override suspend fun createUnreferencedMergeCommit(input: CreateUnreferencedMergeCommitRequest): CreateUnreferencedMergeCommitResponse {
        val op = SdkHttpOperation.build<CreateUnreferencedMergeCommitRequest, CreateUnreferencedMergeCommitResponse> {
            serializer = CreateUnreferencedMergeCommitOperationSerializer()
            deserializer = CreateUnreferencedMergeCommitOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateUnreferencedMergeCommit"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeCommit_20150413", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codecommit"
            }
        )
        val rootSpan = config.tracer.createRootSpan("CreateUnreferencedMergeCommit-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes a specified approval rule template. Deleting a template does not remove approval rules on pull requests already created with the template.
     */
    override suspend fun deleteApprovalRuleTemplate(input: DeleteApprovalRuleTemplateRequest): DeleteApprovalRuleTemplateResponse {
        val op = SdkHttpOperation.build<DeleteApprovalRuleTemplateRequest, DeleteApprovalRuleTemplateResponse> {
            serializer = DeleteApprovalRuleTemplateOperationSerializer()
            deserializer = DeleteApprovalRuleTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteApprovalRuleTemplate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeCommit_20150413", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codecommit"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DeleteApprovalRuleTemplate-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes a branch from a repository, unless that branch is the default branch for the repository.
     */
    override suspend fun deleteBranch(input: DeleteBranchRequest): DeleteBranchResponse {
        val op = SdkHttpOperation.build<DeleteBranchRequest, DeleteBranchResponse> {
            serializer = DeleteBranchOperationSerializer()
            deserializer = DeleteBranchOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteBranch"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeCommit_20150413", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codecommit"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DeleteBranch-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes the content of a comment made on a change, file, or commit in a repository.
     */
    override suspend fun deleteCommentContent(input: DeleteCommentContentRequest): DeleteCommentContentResponse {
        val op = SdkHttpOperation.build<DeleteCommentContentRequest, DeleteCommentContentResponse> {
            serializer = DeleteCommentContentOperationSerializer()
            deserializer = DeleteCommentContentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteCommentContent"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeCommit_20150413", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codecommit"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DeleteCommentContent-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes a specified file from a specified branch. A commit is created on the branch that contains the revision. The file still exists in the commits earlier to the commit that contains the deletion.
     */
    override suspend fun deleteFile(input: DeleteFileRequest): DeleteFileResponse {
        val op = SdkHttpOperation.build<DeleteFileRequest, DeleteFileResponse> {
            serializer = DeleteFileOperationSerializer()
            deserializer = DeleteFileOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteFile"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeCommit_20150413", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codecommit"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DeleteFile-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes an approval rule from a specified pull request. Approval rules can be deleted from a pull request only if the pull request is open, and if the approval rule was created specifically for a pull request and not generated from an approval rule template associated with the repository where the pull request was created. You cannot delete an approval rule from a merged or closed pull request.
     */
    override suspend fun deletePullRequestApprovalRule(input: DeletePullRequestApprovalRuleRequest): DeletePullRequestApprovalRuleResponse {
        val op = SdkHttpOperation.build<DeletePullRequestApprovalRuleRequest, DeletePullRequestApprovalRuleResponse> {
            serializer = DeletePullRequestApprovalRuleOperationSerializer()
            deserializer = DeletePullRequestApprovalRuleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeletePullRequestApprovalRule"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeCommit_20150413", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codecommit"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DeletePullRequestApprovalRule-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes a repository. If a specified repository was already deleted, a null repository ID is returned.
     *
     * Deleting a repository also deletes all associated objects and metadata. After a repository is deleted, all future push calls to the deleted repository fail.
     */
    override suspend fun deleteRepository(input: DeleteRepositoryRequest): DeleteRepositoryResponse {
        val op = SdkHttpOperation.build<DeleteRepositoryRequest, DeleteRepositoryResponse> {
            serializer = DeleteRepositoryOperationSerializer()
            deserializer = DeleteRepositoryOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteRepository"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeCommit_20150413", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codecommit"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DeleteRepository-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns information about one or more merge conflicts in the attempted merge of two commit specifiers using the squash or three-way merge strategy. If the merge option for the attempted merge is specified as FAST_FORWARD_MERGE, an exception is thrown.
     */
    override suspend fun describeMergeConflicts(input: DescribeMergeConflictsRequest): DescribeMergeConflictsResponse {
        val op = SdkHttpOperation.build<DescribeMergeConflictsRequest, DescribeMergeConflictsResponse> {
            serializer = DescribeMergeConflictsOperationSerializer()
            deserializer = DescribeMergeConflictsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeMergeConflicts"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeCommit_20150413", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codecommit"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DescribeMergeConflicts-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns information about one or more pull request events.
     */
    override suspend fun describePullRequestEvents(input: DescribePullRequestEventsRequest): DescribePullRequestEventsResponse {
        val op = SdkHttpOperation.build<DescribePullRequestEventsRequest, DescribePullRequestEventsResponse> {
            serializer = DescribePullRequestEventsOperationSerializer()
            deserializer = DescribePullRequestEventsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribePullRequestEvents"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeCommit_20150413", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codecommit"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DescribePullRequestEvents-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Removes the association between a template and a repository so that approval rules based on the template are not automatically created when pull requests are created in the specified repository. This does not delete any approval rules previously created for pull requests through the template association.
     */
    override suspend fun disassociateApprovalRuleTemplateFromRepository(input: DisassociateApprovalRuleTemplateFromRepositoryRequest): DisassociateApprovalRuleTemplateFromRepositoryResponse {
        val op = SdkHttpOperation.build<DisassociateApprovalRuleTemplateFromRepositoryRequest, DisassociateApprovalRuleTemplateFromRepositoryResponse> {
            serializer = DisassociateApprovalRuleTemplateFromRepositoryOperationSerializer()
            deserializer = DisassociateApprovalRuleTemplateFromRepositoryOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociateApprovalRuleTemplateFromRepository"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeCommit_20150413", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codecommit"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DisassociateApprovalRuleTemplateFromRepository-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Evaluates whether a pull request has met all the conditions specified in its associated approval rules.
     */
    override suspend fun evaluatePullRequestApprovalRules(input: EvaluatePullRequestApprovalRulesRequest): EvaluatePullRequestApprovalRulesResponse {
        val op = SdkHttpOperation.build<EvaluatePullRequestApprovalRulesRequest, EvaluatePullRequestApprovalRulesResponse> {
            serializer = EvaluatePullRequestApprovalRulesOperationSerializer()
            deserializer = EvaluatePullRequestApprovalRulesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "EvaluatePullRequestApprovalRules"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeCommit_20150413", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codecommit"
            }
        )
        val rootSpan = config.tracer.createRootSpan("EvaluatePullRequestApprovalRules-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns information about a specified approval rule template.
     */
    override suspend fun getApprovalRuleTemplate(input: GetApprovalRuleTemplateRequest): GetApprovalRuleTemplateResponse {
        val op = SdkHttpOperation.build<GetApprovalRuleTemplateRequest, GetApprovalRuleTemplateResponse> {
            serializer = GetApprovalRuleTemplateOperationSerializer()
            deserializer = GetApprovalRuleTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetApprovalRuleTemplate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeCommit_20150413", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codecommit"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetApprovalRuleTemplate-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns the base-64 encoded content of an individual blob in a repository.
     */
    override suspend fun getBlob(input: GetBlobRequest): GetBlobResponse {
        val op = SdkHttpOperation.build<GetBlobRequest, GetBlobResponse> {
            serializer = GetBlobOperationSerializer()
            deserializer = GetBlobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetBlob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeCommit_20150413", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codecommit"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetBlob-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns information about a repository branch, including its name and the last commit ID.
     */
    override suspend fun getBranch(input: GetBranchRequest): GetBranchResponse {
        val op = SdkHttpOperation.build<GetBranchRequest, GetBranchResponse> {
            serializer = GetBranchOperationSerializer()
            deserializer = GetBranchOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetBranch"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeCommit_20150413", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codecommit"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetBranch-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns the content of a comment made on a change, file, or commit in a repository.
     *
     * Reaction counts might include numbers from user identities who were deleted after the reaction was made. For a count of reactions from active identities, use GetCommentReactions.
     */
    override suspend fun getComment(input: GetCommentRequest): GetCommentResponse {
        val op = SdkHttpOperation.build<GetCommentRequest, GetCommentResponse> {
            serializer = GetCommentOperationSerializer()
            deserializer = GetCommentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetComment"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeCommit_20150413", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codecommit"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetComment-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns information about reactions to a specified comment ID. Reactions from users who have been deleted will not be included in the count.
     */
    override suspend fun getCommentReactions(input: GetCommentReactionsRequest): GetCommentReactionsResponse {
        val op = SdkHttpOperation.build<GetCommentReactionsRequest, GetCommentReactionsResponse> {
            serializer = GetCommentReactionsOperationSerializer()
            deserializer = GetCommentReactionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetCommentReactions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeCommit_20150413", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codecommit"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetCommentReactions-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns information about comments made on the comparison between two commits.
     *
     * Reaction counts might include numbers from user identities who were deleted after the reaction was made. For a count of reactions from active identities, use GetCommentReactions.
     */
    override suspend fun getCommentsForComparedCommit(input: GetCommentsForComparedCommitRequest): GetCommentsForComparedCommitResponse {
        val op = SdkHttpOperation.build<GetCommentsForComparedCommitRequest, GetCommentsForComparedCommitResponse> {
            serializer = GetCommentsForComparedCommitOperationSerializer()
            deserializer = GetCommentsForComparedCommitOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetCommentsForComparedCommit"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeCommit_20150413", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codecommit"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetCommentsForComparedCommit-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns comments made on a pull request.
     *
     * Reaction counts might include numbers from user identities who were deleted after the reaction was made. For a count of reactions from active identities, use GetCommentReactions.
     */
    override suspend fun getCommentsForPullRequest(input: GetCommentsForPullRequestRequest): GetCommentsForPullRequestResponse {
        val op = SdkHttpOperation.build<GetCommentsForPullRequestRequest, GetCommentsForPullRequestResponse> {
            serializer = GetCommentsForPullRequestOperationSerializer()
            deserializer = GetCommentsForPullRequestOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetCommentsForPullRequest"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeCommit_20150413", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codecommit"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetCommentsForPullRequest-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns information about a commit, including commit message and committer information.
     */
    override suspend fun getCommit(input: GetCommitRequest): GetCommitResponse {
        val op = SdkHttpOperation.build<GetCommitRequest, GetCommitResponse> {
            serializer = GetCommitOperationSerializer()
            deserializer = GetCommitOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetCommit"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeCommit_20150413", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codecommit"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetCommit-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns information about the differences in a valid commit specifier (such as a branch, tag, HEAD, commit ID, or other fully qualified reference). Results can be limited to a specified path.
     */
    override suspend fun getDifferences(input: GetDifferencesRequest): GetDifferencesResponse {
        val op = SdkHttpOperation.build<GetDifferencesRequest, GetDifferencesResponse> {
            serializer = GetDifferencesOperationSerializer()
            deserializer = GetDifferencesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetDifferences"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeCommit_20150413", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codecommit"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetDifferences-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns the base-64 encoded contents of a specified file and its metadata.
     */
    override suspend fun getFile(input: GetFileRequest): GetFileResponse {
        val op = SdkHttpOperation.build<GetFileRequest, GetFileResponse> {
            serializer = GetFileOperationSerializer()
            deserializer = GetFileOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetFile"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeCommit_20150413", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codecommit"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetFile-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns the contents of a specified folder in a repository.
     */
    override suspend fun getFolder(input: GetFolderRequest): GetFolderResponse {
        val op = SdkHttpOperation.build<GetFolderRequest, GetFolderResponse> {
            serializer = GetFolderOperationSerializer()
            deserializer = GetFolderOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetFolder"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeCommit_20150413", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codecommit"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetFolder-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns information about a specified merge commit.
     */
    override suspend fun getMergeCommit(input: GetMergeCommitRequest): GetMergeCommitResponse {
        val op = SdkHttpOperation.build<GetMergeCommitRequest, GetMergeCommitResponse> {
            serializer = GetMergeCommitOperationSerializer()
            deserializer = GetMergeCommitOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetMergeCommit"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeCommit_20150413", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codecommit"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetMergeCommit-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns information about merge conflicts between the before and after commit IDs for a pull request in a repository.
     */
    override suspend fun getMergeConflicts(input: GetMergeConflictsRequest): GetMergeConflictsResponse {
        val op = SdkHttpOperation.build<GetMergeConflictsRequest, GetMergeConflictsResponse> {
            serializer = GetMergeConflictsOperationSerializer()
            deserializer = GetMergeConflictsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetMergeConflicts"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeCommit_20150413", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codecommit"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetMergeConflicts-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns information about the merge options available for merging two specified branches. For details about why a merge option is not available, use GetMergeConflicts or DescribeMergeConflicts.
     */
    override suspend fun getMergeOptions(input: GetMergeOptionsRequest): GetMergeOptionsResponse {
        val op = SdkHttpOperation.build<GetMergeOptionsRequest, GetMergeOptionsResponse> {
            serializer = GetMergeOptionsOperationSerializer()
            deserializer = GetMergeOptionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetMergeOptions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeCommit_20150413", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codecommit"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetMergeOptions-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Gets information about a pull request in a specified repository.
     */
    override suspend fun getPullRequest(input: GetPullRequestRequest): GetPullRequestResponse {
        val op = SdkHttpOperation.build<GetPullRequestRequest, GetPullRequestResponse> {
            serializer = GetPullRequestOperationSerializer()
            deserializer = GetPullRequestOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetPullRequest"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeCommit_20150413", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codecommit"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetPullRequest-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Gets information about the approval states for a specified pull request. Approval states only apply to pull requests that have one or more approval rules applied to them.
     */
    override suspend fun getPullRequestApprovalStates(input: GetPullRequestApprovalStatesRequest): GetPullRequestApprovalStatesResponse {
        val op = SdkHttpOperation.build<GetPullRequestApprovalStatesRequest, GetPullRequestApprovalStatesResponse> {
            serializer = GetPullRequestApprovalStatesOperationSerializer()
            deserializer = GetPullRequestApprovalStatesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetPullRequestApprovalStates"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeCommit_20150413", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codecommit"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetPullRequestApprovalStates-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns information about whether approval rules have been set aside (overridden) for a pull request, and if so, the Amazon Resource Name (ARN) of the user or identity that overrode the rules and their requirements for the pull request.
     */
    override suspend fun getPullRequestOverrideState(input: GetPullRequestOverrideStateRequest): GetPullRequestOverrideStateResponse {
        val op = SdkHttpOperation.build<GetPullRequestOverrideStateRequest, GetPullRequestOverrideStateResponse> {
            serializer = GetPullRequestOverrideStateOperationSerializer()
            deserializer = GetPullRequestOverrideStateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetPullRequestOverrideState"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeCommit_20150413", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codecommit"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetPullRequestOverrideState-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns information about a repository.
     *
     * The description field for a repository accepts all HTML characters and all valid Unicode characters. Applications that do not HTML-encode the description and display it in a webpage can expose users to potentially malicious code. Make sure that you HTML-encode the description field in any application that uses this API to display the repository description on a webpage.
     */
    override suspend fun getRepository(input: GetRepositoryRequest): GetRepositoryResponse {
        val op = SdkHttpOperation.build<GetRepositoryRequest, GetRepositoryResponse> {
            serializer = GetRepositoryOperationSerializer()
            deserializer = GetRepositoryOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetRepository"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeCommit_20150413", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codecommit"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetRepository-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Gets information about triggers configured for a repository.
     */
    override suspend fun getRepositoryTriggers(input: GetRepositoryTriggersRequest): GetRepositoryTriggersResponse {
        val op = SdkHttpOperation.build<GetRepositoryTriggersRequest, GetRepositoryTriggersResponse> {
            serializer = GetRepositoryTriggersOperationSerializer()
            deserializer = GetRepositoryTriggersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetRepositoryTriggers"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeCommit_20150413", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codecommit"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetRepositoryTriggers-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Lists all approval rule templates in the specified AWS Region in your AWS account. If an AWS Region is not specified, the AWS Region where you are signed in is used.
     */
    override suspend fun listApprovalRuleTemplates(input: ListApprovalRuleTemplatesRequest): ListApprovalRuleTemplatesResponse {
        val op = SdkHttpOperation.build<ListApprovalRuleTemplatesRequest, ListApprovalRuleTemplatesResponse> {
            serializer = ListApprovalRuleTemplatesOperationSerializer()
            deserializer = ListApprovalRuleTemplatesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListApprovalRuleTemplates"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeCommit_20150413", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codecommit"
            }
        )
        val rootSpan = config.tracer.createRootSpan("ListApprovalRuleTemplates-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Lists all approval rule templates that are associated with a specified repository.
     */
    override suspend fun listAssociatedApprovalRuleTemplatesForRepository(input: ListAssociatedApprovalRuleTemplatesForRepositoryRequest): ListAssociatedApprovalRuleTemplatesForRepositoryResponse {
        val op = SdkHttpOperation.build<ListAssociatedApprovalRuleTemplatesForRepositoryRequest, ListAssociatedApprovalRuleTemplatesForRepositoryResponse> {
            serializer = ListAssociatedApprovalRuleTemplatesForRepositoryOperationSerializer()
            deserializer = ListAssociatedApprovalRuleTemplatesForRepositoryOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAssociatedApprovalRuleTemplatesForRepository"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeCommit_20150413", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codecommit"
            }
        )
        val rootSpan = config.tracer.createRootSpan("ListAssociatedApprovalRuleTemplatesForRepository-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Gets information about one or more branches in a repository.
     */
    override suspend fun listBranches(input: ListBranchesRequest): ListBranchesResponse {
        val op = SdkHttpOperation.build<ListBranchesRequest, ListBranchesResponse> {
            serializer = ListBranchesOperationSerializer()
            deserializer = ListBranchesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListBranches"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeCommit_20150413", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codecommit"
            }
        )
        val rootSpan = config.tracer.createRootSpan("ListBranches-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns a list of pull requests for a specified repository. The return list can be refined by pull request status or pull request author ARN.
     */
    override suspend fun listPullRequests(input: ListPullRequestsRequest): ListPullRequestsResponse {
        val op = SdkHttpOperation.build<ListPullRequestsRequest, ListPullRequestsResponse> {
            serializer = ListPullRequestsOperationSerializer()
            deserializer = ListPullRequestsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListPullRequests"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeCommit_20150413", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codecommit"
            }
        )
        val rootSpan = config.tracer.createRootSpan("ListPullRequests-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Gets information about one or more repositories.
     */
    override suspend fun listRepositories(input: ListRepositoriesRequest): ListRepositoriesResponse {
        val op = SdkHttpOperation.build<ListRepositoriesRequest, ListRepositoriesResponse> {
            serializer = ListRepositoriesOperationSerializer()
            deserializer = ListRepositoriesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListRepositories"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeCommit_20150413", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codecommit"
            }
        )
        val rootSpan = config.tracer.createRootSpan("ListRepositories-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Lists all repositories associated with the specified approval rule template.
     */
    override suspend fun listRepositoriesForApprovalRuleTemplate(input: ListRepositoriesForApprovalRuleTemplateRequest): ListRepositoriesForApprovalRuleTemplateResponse {
        val op = SdkHttpOperation.build<ListRepositoriesForApprovalRuleTemplateRequest, ListRepositoriesForApprovalRuleTemplateResponse> {
            serializer = ListRepositoriesForApprovalRuleTemplateOperationSerializer()
            deserializer = ListRepositoriesForApprovalRuleTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListRepositoriesForApprovalRuleTemplate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeCommit_20150413", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codecommit"
            }
        )
        val rootSpan = config.tracer.createRootSpan("ListRepositoriesForApprovalRuleTemplate-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Gets information about AWS tags for a specified Amazon Resource Name (ARN) in AWS CodeCommit. For a list of valid resources in AWS CodeCommit, see [CodeCommit Resources and Operations](https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-iam-access-control-identity-based.html#arn-formats) in the* AWS CodeCommit User Guide*.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeCommit_20150413", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codecommit"
            }
        )
        val rootSpan = config.tracer.createRootSpan("ListTagsForResource-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Merges two branches using the fast-forward merge strategy.
     */
    override suspend fun mergeBranchesByFastForward(input: MergeBranchesByFastForwardRequest): MergeBranchesByFastForwardResponse {
        val op = SdkHttpOperation.build<MergeBranchesByFastForwardRequest, MergeBranchesByFastForwardResponse> {
            serializer = MergeBranchesByFastForwardOperationSerializer()
            deserializer = MergeBranchesByFastForwardOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "MergeBranchesByFastForward"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeCommit_20150413", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codecommit"
            }
        )
        val rootSpan = config.tracer.createRootSpan("MergeBranchesByFastForward-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Merges two branches using the squash merge strategy.
     */
    override suspend fun mergeBranchesBySquash(input: MergeBranchesBySquashRequest): MergeBranchesBySquashResponse {
        val op = SdkHttpOperation.build<MergeBranchesBySquashRequest, MergeBranchesBySquashResponse> {
            serializer = MergeBranchesBySquashOperationSerializer()
            deserializer = MergeBranchesBySquashOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "MergeBranchesBySquash"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeCommit_20150413", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codecommit"
            }
        )
        val rootSpan = config.tracer.createRootSpan("MergeBranchesBySquash-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Merges two specified branches using the three-way merge strategy.
     */
    override suspend fun mergeBranchesByThreeWay(input: MergeBranchesByThreeWayRequest): MergeBranchesByThreeWayResponse {
        val op = SdkHttpOperation.build<MergeBranchesByThreeWayRequest, MergeBranchesByThreeWayResponse> {
            serializer = MergeBranchesByThreeWayOperationSerializer()
            deserializer = MergeBranchesByThreeWayOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "MergeBranchesByThreeWay"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeCommit_20150413", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codecommit"
            }
        )
        val rootSpan = config.tracer.createRootSpan("MergeBranchesByThreeWay-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Attempts to merge the source commit of a pull request into the specified destination branch for that pull request at the specified commit using the fast-forward merge strategy. If the merge is successful, it closes the pull request.
     */
    override suspend fun mergePullRequestByFastForward(input: MergePullRequestByFastForwardRequest): MergePullRequestByFastForwardResponse {
        val op = SdkHttpOperation.build<MergePullRequestByFastForwardRequest, MergePullRequestByFastForwardResponse> {
            serializer = MergePullRequestByFastForwardOperationSerializer()
            deserializer = MergePullRequestByFastForwardOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "MergePullRequestByFastForward"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeCommit_20150413", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codecommit"
            }
        )
        val rootSpan = config.tracer.createRootSpan("MergePullRequestByFastForward-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Attempts to merge the source commit of a pull request into the specified destination branch for that pull request at the specified commit using the squash merge strategy. If the merge is successful, it closes the pull request.
     */
    override suspend fun mergePullRequestBySquash(input: MergePullRequestBySquashRequest): MergePullRequestBySquashResponse {
        val op = SdkHttpOperation.build<MergePullRequestBySquashRequest, MergePullRequestBySquashResponse> {
            serializer = MergePullRequestBySquashOperationSerializer()
            deserializer = MergePullRequestBySquashOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "MergePullRequestBySquash"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeCommit_20150413", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codecommit"
            }
        )
        val rootSpan = config.tracer.createRootSpan("MergePullRequestBySquash-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Attempts to merge the source commit of a pull request into the specified destination branch for that pull request at the specified commit using the three-way merge strategy. If the merge is successful, it closes the pull request.
     */
    override suspend fun mergePullRequestByThreeWay(input: MergePullRequestByThreeWayRequest): MergePullRequestByThreeWayResponse {
        val op = SdkHttpOperation.build<MergePullRequestByThreeWayRequest, MergePullRequestByThreeWayResponse> {
            serializer = MergePullRequestByThreeWayOperationSerializer()
            deserializer = MergePullRequestByThreeWayOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "MergePullRequestByThreeWay"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeCommit_20150413", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codecommit"
            }
        )
        val rootSpan = config.tracer.createRootSpan("MergePullRequestByThreeWay-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Sets aside (overrides) all approval rule requirements for a specified pull request.
     */
    override suspend fun overridePullRequestApprovalRules(input: OverridePullRequestApprovalRulesRequest): OverridePullRequestApprovalRulesResponse {
        val op = SdkHttpOperation.build<OverridePullRequestApprovalRulesRequest, OverridePullRequestApprovalRulesResponse> {
            serializer = OverridePullRequestApprovalRulesOperationSerializer()
            deserializer = OverridePullRequestApprovalRulesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "OverridePullRequestApprovalRules"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeCommit_20150413", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codecommit"
            }
        )
        val rootSpan = config.tracer.createRootSpan("OverridePullRequestApprovalRules-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Posts a comment on the comparison between two commits.
     */
    override suspend fun postCommentForComparedCommit(input: PostCommentForComparedCommitRequest): PostCommentForComparedCommitResponse {
        val op = SdkHttpOperation.build<PostCommentForComparedCommitRequest, PostCommentForComparedCommitResponse> {
            serializer = PostCommentForComparedCommitOperationSerializer()
            deserializer = PostCommentForComparedCommitOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PostCommentForComparedCommit"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeCommit_20150413", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codecommit"
            }
        )
        val rootSpan = config.tracer.createRootSpan("PostCommentForComparedCommit-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Posts a comment on a pull request.
     */
    override suspend fun postCommentForPullRequest(input: PostCommentForPullRequestRequest): PostCommentForPullRequestResponse {
        val op = SdkHttpOperation.build<PostCommentForPullRequestRequest, PostCommentForPullRequestResponse> {
            serializer = PostCommentForPullRequestOperationSerializer()
            deserializer = PostCommentForPullRequestOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PostCommentForPullRequest"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeCommit_20150413", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codecommit"
            }
        )
        val rootSpan = config.tracer.createRootSpan("PostCommentForPullRequest-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Posts a comment in reply to an existing comment on a comparison between commits or a pull request.
     */
    override suspend fun postCommentReply(input: PostCommentReplyRequest): PostCommentReplyResponse {
        val op = SdkHttpOperation.build<PostCommentReplyRequest, PostCommentReplyResponse> {
            serializer = PostCommentReplyOperationSerializer()
            deserializer = PostCommentReplyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PostCommentReply"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeCommit_20150413", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codecommit"
            }
        )
        val rootSpan = config.tracer.createRootSpan("PostCommentReply-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Adds or updates a reaction to a specified comment for the user whose identity is used to make the request. You can only add or update a reaction for yourself. You cannot add, modify, or delete a reaction for another user.
     */
    override suspend fun putCommentReaction(input: PutCommentReactionRequest): PutCommentReactionResponse {
        val op = SdkHttpOperation.build<PutCommentReactionRequest, PutCommentReactionResponse> {
            serializer = PutCommentReactionOperationSerializer()
            deserializer = PutCommentReactionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutCommentReaction"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeCommit_20150413", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codecommit"
            }
        )
        val rootSpan = config.tracer.createRootSpan("PutCommentReaction-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Adds or updates a file in a branch in an AWS CodeCommit repository, and generates a commit for the addition in the specified branch.
     */
    override suspend fun putFile(input: PutFileRequest): PutFileResponse {
        val op = SdkHttpOperation.build<PutFileRequest, PutFileResponse> {
            serializer = PutFileOperationSerializer()
            deserializer = PutFileOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutFile"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeCommit_20150413", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codecommit"
            }
        )
        val rootSpan = config.tracer.createRootSpan("PutFile-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Replaces all triggers for a repository. Used to create or delete triggers.
     */
    override suspend fun putRepositoryTriggers(input: PutRepositoryTriggersRequest): PutRepositoryTriggersResponse {
        val op = SdkHttpOperation.build<PutRepositoryTriggersRequest, PutRepositoryTriggersResponse> {
            serializer = PutRepositoryTriggersOperationSerializer()
            deserializer = PutRepositoryTriggersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutRepositoryTriggers"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeCommit_20150413", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codecommit"
            }
        )
        val rootSpan = config.tracer.createRootSpan("PutRepositoryTriggers-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Adds or updates tags for a resource in AWS CodeCommit. For a list of valid resources in AWS CodeCommit, see [CodeCommit Resources and Operations](https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-iam-access-control-identity-based.html#arn-formats) in the *AWS CodeCommit User Guide*.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeCommit_20150413", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codecommit"
            }
        )
        val rootSpan = config.tracer.createRootSpan("TagResource-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Tests the functionality of repository triggers by sending information to the trigger target. If real data is available in the repository, the test sends data from the last commit. If no data is available, sample data is generated.
     */
    override suspend fun testRepositoryTriggers(input: TestRepositoryTriggersRequest): TestRepositoryTriggersResponse {
        val op = SdkHttpOperation.build<TestRepositoryTriggersRequest, TestRepositoryTriggersResponse> {
            serializer = TestRepositoryTriggersOperationSerializer()
            deserializer = TestRepositoryTriggersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TestRepositoryTriggers"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeCommit_20150413", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codecommit"
            }
        )
        val rootSpan = config.tracer.createRootSpan("TestRepositoryTriggers-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Removes tags for a resource in AWS CodeCommit. For a list of valid resources in AWS CodeCommit, see [CodeCommit Resources and Operations](https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-iam-access-control-identity-based.html#arn-formats) in the *AWS CodeCommit User Guide*.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeCommit_20150413", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codecommit"
            }
        )
        val rootSpan = config.tracer.createRootSpan("UntagResource-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates the content of an approval rule template. You can change the number of required approvals, the membership of the approval rule, and whether an approval pool is defined.
     */
    override suspend fun updateApprovalRuleTemplateContent(input: UpdateApprovalRuleTemplateContentRequest): UpdateApprovalRuleTemplateContentResponse {
        val op = SdkHttpOperation.build<UpdateApprovalRuleTemplateContentRequest, UpdateApprovalRuleTemplateContentResponse> {
            serializer = UpdateApprovalRuleTemplateContentOperationSerializer()
            deserializer = UpdateApprovalRuleTemplateContentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateApprovalRuleTemplateContent"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeCommit_20150413", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codecommit"
            }
        )
        val rootSpan = config.tracer.createRootSpan("UpdateApprovalRuleTemplateContent-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates the description for a specified approval rule template.
     */
    override suspend fun updateApprovalRuleTemplateDescription(input: UpdateApprovalRuleTemplateDescriptionRequest): UpdateApprovalRuleTemplateDescriptionResponse {
        val op = SdkHttpOperation.build<UpdateApprovalRuleTemplateDescriptionRequest, UpdateApprovalRuleTemplateDescriptionResponse> {
            serializer = UpdateApprovalRuleTemplateDescriptionOperationSerializer()
            deserializer = UpdateApprovalRuleTemplateDescriptionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateApprovalRuleTemplateDescription"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeCommit_20150413", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codecommit"
            }
        )
        val rootSpan = config.tracer.createRootSpan("UpdateApprovalRuleTemplateDescription-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates the name of a specified approval rule template.
     */
    override suspend fun updateApprovalRuleTemplateName(input: UpdateApprovalRuleTemplateNameRequest): UpdateApprovalRuleTemplateNameResponse {
        val op = SdkHttpOperation.build<UpdateApprovalRuleTemplateNameRequest, UpdateApprovalRuleTemplateNameResponse> {
            serializer = UpdateApprovalRuleTemplateNameOperationSerializer()
            deserializer = UpdateApprovalRuleTemplateNameOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateApprovalRuleTemplateName"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeCommit_20150413", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codecommit"
            }
        )
        val rootSpan = config.tracer.createRootSpan("UpdateApprovalRuleTemplateName-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Replaces the contents of a comment.
     */
    override suspend fun updateComment(input: UpdateCommentRequest): UpdateCommentResponse {
        val op = SdkHttpOperation.build<UpdateCommentRequest, UpdateCommentResponse> {
            serializer = UpdateCommentOperationSerializer()
            deserializer = UpdateCommentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateComment"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeCommit_20150413", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codecommit"
            }
        )
        val rootSpan = config.tracer.createRootSpan("UpdateComment-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Sets or changes the default branch name for the specified repository.
     *
     * If you use this operation to change the default branch name to the current default branch name, a success message is returned even though the default branch did not change.
     */
    override suspend fun updateDefaultBranch(input: UpdateDefaultBranchRequest): UpdateDefaultBranchResponse {
        val op = SdkHttpOperation.build<UpdateDefaultBranchRequest, UpdateDefaultBranchResponse> {
            serializer = UpdateDefaultBranchOperationSerializer()
            deserializer = UpdateDefaultBranchOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateDefaultBranch"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeCommit_20150413", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codecommit"
            }
        )
        val rootSpan = config.tracer.createRootSpan("UpdateDefaultBranch-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates the structure of an approval rule created specifically for a pull request. For example, you can change the number of required approvers and the approval pool for approvers.
     */
    override suspend fun updatePullRequestApprovalRuleContent(input: UpdatePullRequestApprovalRuleContentRequest): UpdatePullRequestApprovalRuleContentResponse {
        val op = SdkHttpOperation.build<UpdatePullRequestApprovalRuleContentRequest, UpdatePullRequestApprovalRuleContentResponse> {
            serializer = UpdatePullRequestApprovalRuleContentOperationSerializer()
            deserializer = UpdatePullRequestApprovalRuleContentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdatePullRequestApprovalRuleContent"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeCommit_20150413", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codecommit"
            }
        )
        val rootSpan = config.tracer.createRootSpan("UpdatePullRequestApprovalRuleContent-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates the state of a user's approval on a pull request. The user is derived from the signed-in account when the request is made.
     */
    override suspend fun updatePullRequestApprovalState(input: UpdatePullRequestApprovalStateRequest): UpdatePullRequestApprovalStateResponse {
        val op = SdkHttpOperation.build<UpdatePullRequestApprovalStateRequest, UpdatePullRequestApprovalStateResponse> {
            serializer = UpdatePullRequestApprovalStateOperationSerializer()
            deserializer = UpdatePullRequestApprovalStateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdatePullRequestApprovalState"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeCommit_20150413", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codecommit"
            }
        )
        val rootSpan = config.tracer.createRootSpan("UpdatePullRequestApprovalState-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Replaces the contents of the description of a pull request.
     */
    override suspend fun updatePullRequestDescription(input: UpdatePullRequestDescriptionRequest): UpdatePullRequestDescriptionResponse {
        val op = SdkHttpOperation.build<UpdatePullRequestDescriptionRequest, UpdatePullRequestDescriptionResponse> {
            serializer = UpdatePullRequestDescriptionOperationSerializer()
            deserializer = UpdatePullRequestDescriptionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdatePullRequestDescription"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeCommit_20150413", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codecommit"
            }
        )
        val rootSpan = config.tracer.createRootSpan("UpdatePullRequestDescription-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates the status of a pull request.
     */
    override suspend fun updatePullRequestStatus(input: UpdatePullRequestStatusRequest): UpdatePullRequestStatusResponse {
        val op = SdkHttpOperation.build<UpdatePullRequestStatusRequest, UpdatePullRequestStatusResponse> {
            serializer = UpdatePullRequestStatusOperationSerializer()
            deserializer = UpdatePullRequestStatusOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdatePullRequestStatus"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeCommit_20150413", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codecommit"
            }
        )
        val rootSpan = config.tracer.createRootSpan("UpdatePullRequestStatus-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Replaces the title of a pull request.
     */
    override suspend fun updatePullRequestTitle(input: UpdatePullRequestTitleRequest): UpdatePullRequestTitleResponse {
        val op = SdkHttpOperation.build<UpdatePullRequestTitleRequest, UpdatePullRequestTitleResponse> {
            serializer = UpdatePullRequestTitleOperationSerializer()
            deserializer = UpdatePullRequestTitleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdatePullRequestTitle"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeCommit_20150413", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codecommit"
            }
        )
        val rootSpan = config.tracer.createRootSpan("UpdatePullRequestTitle-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Sets or changes the comment or description for a repository.
     *
     * The description field for a repository accepts all HTML characters and all valid Unicode characters. Applications that do not HTML-encode the description and display it in a webpage can expose users to potentially malicious code. Make sure that you HTML-encode the description field in any application that uses this API to display the repository description on a webpage.
     */
    override suspend fun updateRepositoryDescription(input: UpdateRepositoryDescriptionRequest): UpdateRepositoryDescriptionResponse {
        val op = SdkHttpOperation.build<UpdateRepositoryDescriptionRequest, UpdateRepositoryDescriptionResponse> {
            serializer = UpdateRepositoryDescriptionOperationSerializer()
            deserializer = UpdateRepositoryDescriptionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateRepositoryDescription"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeCommit_20150413", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codecommit"
            }
        )
        val rootSpan = config.tracer.createRootSpan("UpdateRepositoryDescription-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Renames a repository. The repository name must be unique across the calling AWS account. Repository names are limited to 100 alphanumeric, dash, and underscore characters, and cannot include certain characters. The suffix .git is prohibited. For more information about the limits on repository names, see [Limits](https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html) in the AWS CodeCommit User Guide.
     */
    override suspend fun updateRepositoryName(input: UpdateRepositoryNameRequest): UpdateRepositoryNameResponse {
        val op = SdkHttpOperation.build<UpdateRepositoryNameRequest, UpdateRepositoryNameResponse> {
            serializer = UpdateRepositoryNameOperationSerializer()
            deserializer = UpdateRepositoryNameOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateRepositoryName"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("CodeCommit_20150413", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codecommit"
            }
        )
        val rootSpan = config.tracer.createRootSpan("UpdateRepositoryName-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "codecommit")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
        config.idempotencyTokenProvider?.let { ctx[SdkClientOption.IdempotencyTokenProvider] = it }
    }
}
