// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecommit.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Returns information about an approval rule.
 */
public class ApprovalRule private constructor(builder: Builder) {
    /**
     * The content of the approval rule.
     */
    public val approvalRuleContent: kotlin.String? = builder.approvalRuleContent
    /**
     * The system-generated ID of the approval rule.
     */
    public val approvalRuleId: kotlin.String? = builder.approvalRuleId
    /**
     * The name of the approval rule.
     */
    public val approvalRuleName: kotlin.String? = builder.approvalRuleName
    /**
     * The date the approval rule was created, in timestamp format.
     */
    public val creationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDate
    /**
     * The date the approval rule was most recently changed, in timestamp format.
     */
    public val lastModifiedDate: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedDate
    /**
     * The Amazon Resource Name (ARN) of the user who made the most recent changes to the approval rule.
     */
    public val lastModifiedUser: kotlin.String? = builder.lastModifiedUser
    /**
     * The approval rule template used to create the rule.
     */
    public val originApprovalRuleTemplate: aws.sdk.kotlin.services.codecommit.model.OriginApprovalRuleTemplate? = builder.originApprovalRuleTemplate
    /**
     * The SHA-256 hash signature for the content of the approval rule.
     */
    public val ruleContentSha256: kotlin.String? = builder.ruleContentSha256

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codecommit.model.ApprovalRule = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ApprovalRule(")
        append("approvalRuleContent=$approvalRuleContent,")
        append("approvalRuleId=$approvalRuleId,")
        append("approvalRuleName=$approvalRuleName,")
        append("creationDate=$creationDate,")
        append("lastModifiedDate=$lastModifiedDate,")
        append("lastModifiedUser=$lastModifiedUser,")
        append("originApprovalRuleTemplate=$originApprovalRuleTemplate,")
        append("ruleContentSha256=$ruleContentSha256)")
    }

    override fun hashCode(): kotlin.Int {
        var result = approvalRuleContent?.hashCode() ?: 0
        result = 31 * result + (approvalRuleId?.hashCode() ?: 0)
        result = 31 * result + (approvalRuleName?.hashCode() ?: 0)
        result = 31 * result + (creationDate?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedDate?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedUser?.hashCode() ?: 0)
        result = 31 * result + (originApprovalRuleTemplate?.hashCode() ?: 0)
        result = 31 * result + (ruleContentSha256?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ApprovalRule

        if (approvalRuleContent != other.approvalRuleContent) return false
        if (approvalRuleId != other.approvalRuleId) return false
        if (approvalRuleName != other.approvalRuleName) return false
        if (creationDate != other.creationDate) return false
        if (lastModifiedDate != other.lastModifiedDate) return false
        if (lastModifiedUser != other.lastModifiedUser) return false
        if (originApprovalRuleTemplate != other.originApprovalRuleTemplate) return false
        if (ruleContentSha256 != other.ruleContentSha256) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codecommit.model.ApprovalRule = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The content of the approval rule.
         */
        public var approvalRuleContent: kotlin.String? = null
        /**
         * The system-generated ID of the approval rule.
         */
        public var approvalRuleId: kotlin.String? = null
        /**
         * The name of the approval rule.
         */
        public var approvalRuleName: kotlin.String? = null
        /**
         * The date the approval rule was created, in timestamp format.
         */
        public var creationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The date the approval rule was most recently changed, in timestamp format.
         */
        public var lastModifiedDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the user who made the most recent changes to the approval rule.
         */
        public var lastModifiedUser: kotlin.String? = null
        /**
         * The approval rule template used to create the rule.
         */
        public var originApprovalRuleTemplate: aws.sdk.kotlin.services.codecommit.model.OriginApprovalRuleTemplate? = null
        /**
         * The SHA-256 hash signature for the content of the approval rule.
         */
        public var ruleContentSha256: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codecommit.model.ApprovalRule) : this() {
            this.approvalRuleContent = x.approvalRuleContent
            this.approvalRuleId = x.approvalRuleId
            this.approvalRuleName = x.approvalRuleName
            this.creationDate = x.creationDate
            this.lastModifiedDate = x.lastModifiedDate
            this.lastModifiedUser = x.lastModifiedUser
            this.originApprovalRuleTemplate = x.originApprovalRuleTemplate
            this.ruleContentSha256 = x.ruleContentSha256
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codecommit.model.ApprovalRule = ApprovalRule(this)

        /**
         * construct an [aws.sdk.kotlin.services.codecommit.model.OriginApprovalRuleTemplate] inside the given [block]
         */
        public fun originApprovalRuleTemplate(block: aws.sdk.kotlin.services.codecommit.model.OriginApprovalRuleTemplate.Builder.() -> kotlin.Unit) {
            this.originApprovalRuleTemplate = aws.sdk.kotlin.services.codecommit.model.OriginApprovalRuleTemplate.invoke(block)
        }
    }
}
