// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecommit.model



/**
 * Returns information about a specific Git blob object.
 */
public class BlobMetadata private constructor(builder: Builder) {
    /**
     * The full ID of the blob.
     */
    public val blobId: kotlin.String? = builder.blobId
    /**
     * The file mode permissions of the blob. File mode permission codes include:
     * + `100644` indicates read/write
     * + `100755` indicates read/write/execute
     * + `160000` indicates a submodule
     * + `120000` indicates a symlink
     */
    public val mode: kotlin.String? = builder.mode
    /**
     * The path to the blob and associated file name, if any.
     */
    public val path: kotlin.String? = builder.path

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codecommit.model.BlobMetadata = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BlobMetadata(")
        append("blobId=$blobId,")
        append("mode=$mode,")
        append("path=$path)")
    }

    override fun hashCode(): kotlin.Int {
        var result = blobId?.hashCode() ?: 0
        result = 31 * result + (mode?.hashCode() ?: 0)
        result = 31 * result + (path?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BlobMetadata

        if (blobId != other.blobId) return false
        if (mode != other.mode) return false
        if (path != other.path) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codecommit.model.BlobMetadata = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The full ID of the blob.
         */
        public var blobId: kotlin.String? = null
        /**
         * The file mode permissions of the blob. File mode permission codes include:
         * + `100644` indicates read/write
         * + `100755` indicates read/write/execute
         * + `160000` indicates a submodule
         * + `120000` indicates a symlink
         */
        public var mode: kotlin.String? = null
        /**
         * The path to the blob and associated file name, if any.
         */
        public var path: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codecommit.model.BlobMetadata) : this() {
            this.blobId = x.blobId
            this.mode = x.mode
            this.path = x.path
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codecommit.model.BlobMetadata = BlobMetadata(this)
    }
}
