// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecommit.model



/**
 * Returns information about a specific commit.
 */
public class Commit private constructor(builder: Builder) {
    /**
     * Any other data associated with the specified commit.
     */
    public val additionalData: kotlin.String? = builder.additionalData
    /**
     * Information about the author of the specified commit. Information includes the date in timestamp format with GMT offset, the name of the author, and the email address for the author, as configured in Git.
     */
    public val author: aws.sdk.kotlin.services.codecommit.model.UserInfo? = builder.author
    /**
     * The full SHA ID of the specified commit.
     */
    public val commitId: kotlin.String? = builder.commitId
    /**
     * Information about the person who committed the specified commit, also known as the committer. Information includes the date in timestamp format with GMT offset, the name of the committer, and the email address for the committer, as configured in Git.
     *
     * For more information about the difference between an author and a committer in Git, see [Viewing the Commit History](http://git-scm.com/book/ch2-3.html) in Pro Git by Scott Chacon and Ben Straub.
     */
    public val committer: aws.sdk.kotlin.services.codecommit.model.UserInfo? = builder.committer
    /**
     * The commit message associated with the specified commit.
     */
    public val message: kotlin.String? = builder.message
    /**
     * A list of parent commits for the specified commit. Each parent commit ID is the full commit ID.
     */
    public val parents: List<String>? = builder.parents
    /**
     * Tree information for the specified commit.
     */
    public val treeId: kotlin.String? = builder.treeId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codecommit.model.Commit = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Commit(")
        append("additionalData=$additionalData,")
        append("author=$author,")
        append("commitId=$commitId,")
        append("committer=$committer,")
        append("message=$message,")
        append("parents=$parents,")
        append("treeId=$treeId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = additionalData?.hashCode() ?: 0
        result = 31 * result + (author?.hashCode() ?: 0)
        result = 31 * result + (commitId?.hashCode() ?: 0)
        result = 31 * result + (committer?.hashCode() ?: 0)
        result = 31 * result + (message?.hashCode() ?: 0)
        result = 31 * result + (parents?.hashCode() ?: 0)
        result = 31 * result + (treeId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Commit

        if (additionalData != other.additionalData) return false
        if (author != other.author) return false
        if (commitId != other.commitId) return false
        if (committer != other.committer) return false
        if (message != other.message) return false
        if (parents != other.parents) return false
        if (treeId != other.treeId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codecommit.model.Commit = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Any other data associated with the specified commit.
         */
        public var additionalData: kotlin.String? = null
        /**
         * Information about the author of the specified commit. Information includes the date in timestamp format with GMT offset, the name of the author, and the email address for the author, as configured in Git.
         */
        public var author: aws.sdk.kotlin.services.codecommit.model.UserInfo? = null
        /**
         * The full SHA ID of the specified commit.
         */
        public var commitId: kotlin.String? = null
        /**
         * Information about the person who committed the specified commit, also known as the committer. Information includes the date in timestamp format with GMT offset, the name of the committer, and the email address for the committer, as configured in Git.
         *
         * For more information about the difference between an author and a committer in Git, see [Viewing the Commit History](http://git-scm.com/book/ch2-3.html) in Pro Git by Scott Chacon and Ben Straub.
         */
        public var committer: aws.sdk.kotlin.services.codecommit.model.UserInfo? = null
        /**
         * The commit message associated with the specified commit.
         */
        public var message: kotlin.String? = null
        /**
         * A list of parent commits for the specified commit. Each parent commit ID is the full commit ID.
         */
        public var parents: List<String>? = null
        /**
         * Tree information for the specified commit.
         */
        public var treeId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codecommit.model.Commit) : this() {
            this.additionalData = x.additionalData
            this.author = x.author
            this.commitId = x.commitId
            this.committer = x.committer
            this.message = x.message
            this.parents = x.parents
            this.treeId = x.treeId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codecommit.model.Commit = Commit(this)

        /**
         * construct an [aws.sdk.kotlin.services.codecommit.model.UserInfo] inside the given [block]
         */
        public fun author(block: aws.sdk.kotlin.services.codecommit.model.UserInfo.Builder.() -> kotlin.Unit) {
            this.author = aws.sdk.kotlin.services.codecommit.model.UserInfo.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codecommit.model.UserInfo] inside the given [block]
         */
        public fun committer(block: aws.sdk.kotlin.services.codecommit.model.UserInfo.Builder.() -> kotlin.Unit) {
            this.committer = aws.sdk.kotlin.services.codecommit.model.UserInfo.invoke(block)
        }
    }
}
