// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecommit.model



public class CreateApprovalRuleTemplateRequest private constructor(builder: Builder) {
    /**
     * The content of the approval rule that is created on pull requests in associated repositories. If you specify one or more destination references (branches), approval rules are created in an associated repository only if their destination references (branches) match those specified in the template.
     *
     * When you create the content of the approval rule template, you can specify approvers in an approval pool in one of two ways:
     * + **CodeCommitApprovers**: This option only requires an AWS account and a resource. It can be used for both IAM users and federated access users whose name matches the provided resource name. This is a very powerful option that offers a great deal of flexibility. For example, if you specify the AWS account *123456789012* and *Mary_Major*, all of the following are counted as approvals coming from that user:
     *    + An IAM user in the account (arn:aws:iam::*123456789012*:user&#47;*Mary_Major*)
     *    + A federated user identified in IAM as Mary_Major (arn:aws:sts::*123456789012*:federated-user&#47;*Mary_Major*)
     * This option does not recognize an active session of someone assuming the role of CodeCommitReview with a role session name of *Mary_Major* (arn:aws:sts::*123456789012*:assumed-role/CodeCommitReview&#47;*Mary_Major*) unless you include a wildcard (*Mary_Major).
     * + **Fully qualified ARN**: This option allows you to specify the fully qualified Amazon Resource Name (ARN) of the IAM user or role.
     * For more information about IAM ARNs, wildcards, and formats, see [IAM Identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html) in the *IAM User Guide*.
     */
    public val approvalRuleTemplateContent: kotlin.String? = builder.approvalRuleTemplateContent
    /**
     * The description of the approval rule template. Consider providing a description that explains what this template does and when it might be appropriate to associate it with repositories.
     */
    public val approvalRuleTemplateDescription: kotlin.String? = builder.approvalRuleTemplateDescription
    /**
     * The name of the approval rule template. Provide descriptive names, because this name is applied to the approval rules created automatically in associated repositories.
     */
    public val approvalRuleTemplateName: kotlin.String? = builder.approvalRuleTemplateName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codecommit.model.CreateApprovalRuleTemplateRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateApprovalRuleTemplateRequest(")
        append("approvalRuleTemplateContent=$approvalRuleTemplateContent,")
        append("approvalRuleTemplateDescription=$approvalRuleTemplateDescription,")
        append("approvalRuleTemplateName=$approvalRuleTemplateName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = approvalRuleTemplateContent?.hashCode() ?: 0
        result = 31 * result + (approvalRuleTemplateDescription?.hashCode() ?: 0)
        result = 31 * result + (approvalRuleTemplateName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateApprovalRuleTemplateRequest

        if (approvalRuleTemplateContent != other.approvalRuleTemplateContent) return false
        if (approvalRuleTemplateDescription != other.approvalRuleTemplateDescription) return false
        if (approvalRuleTemplateName != other.approvalRuleTemplateName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codecommit.model.CreateApprovalRuleTemplateRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The content of the approval rule that is created on pull requests in associated repositories. If you specify one or more destination references (branches), approval rules are created in an associated repository only if their destination references (branches) match those specified in the template.
         *
         * When you create the content of the approval rule template, you can specify approvers in an approval pool in one of two ways:
         * + **CodeCommitApprovers**: This option only requires an AWS account and a resource. It can be used for both IAM users and federated access users whose name matches the provided resource name. This is a very powerful option that offers a great deal of flexibility. For example, if you specify the AWS account *123456789012* and *Mary_Major*, all of the following are counted as approvals coming from that user:
         *    + An IAM user in the account (arn:aws:iam::*123456789012*:user&#47;*Mary_Major*)
         *    + A federated user identified in IAM as Mary_Major (arn:aws:sts::*123456789012*:federated-user&#47;*Mary_Major*)
         * This option does not recognize an active session of someone assuming the role of CodeCommitReview with a role session name of *Mary_Major* (arn:aws:sts::*123456789012*:assumed-role/CodeCommitReview&#47;*Mary_Major*) unless you include a wildcard (*Mary_Major).
         * + **Fully qualified ARN**: This option allows you to specify the fully qualified Amazon Resource Name (ARN) of the IAM user or role.
         * For more information about IAM ARNs, wildcards, and formats, see [IAM Identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html) in the *IAM User Guide*.
         */
        public var approvalRuleTemplateContent: kotlin.String? = null
        /**
         * The description of the approval rule template. Consider providing a description that explains what this template does and when it might be appropriate to associate it with repositories.
         */
        public var approvalRuleTemplateDescription: kotlin.String? = null
        /**
         * The name of the approval rule template. Provide descriptive names, because this name is applied to the approval rules created automatically in associated repositories.
         */
        public var approvalRuleTemplateName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codecommit.model.CreateApprovalRuleTemplateRequest) : this() {
            this.approvalRuleTemplateContent = x.approvalRuleTemplateContent
            this.approvalRuleTemplateDescription = x.approvalRuleTemplateDescription
            this.approvalRuleTemplateName = x.approvalRuleTemplateName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codecommit.model.CreateApprovalRuleTemplateRequest = CreateApprovalRuleTemplateRequest(this)
    }
}
