// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecommit.model



public class CreatePullRequestApprovalRuleRequest private constructor(builder: Builder) {
    /**
     * The content of the approval rule, including the number of approvals needed and the structure of an approval pool defined for approvals, if any. For more information about approval pools, see the AWS CodeCommit User Guide.
     *
     * When you create the content of the approval rule, you can specify approvers in an approval pool in one of two ways:
     * + **CodeCommitApprovers**: This option only requires an AWS account and a resource. It can be used for both IAM users and federated access users whose name matches the provided resource name. This is a very powerful option that offers a great deal of flexibility. For example, if you specify the AWS account *123456789012* and *Mary_Major*, all of the following would be counted as approvals coming from that user:
     *    + An IAM user in the account (arn:aws:iam::*123456789012*:user&#47;*Mary_Major*)
     *    + A federated user identified in IAM as Mary_Major (arn:aws:sts::*123456789012*:federated-user&#47;*Mary_Major*)
     * This option does not recognize an active session of someone assuming the role of CodeCommitReview with a role session name of *Mary_Major* (arn:aws:sts::*123456789012*:assumed-role/CodeCommitReview&#47;*Mary_Major*) unless you include a wildcard (*Mary_Major).
     * + **Fully qualified ARN**: This option allows you to specify the fully qualified Amazon Resource Name (ARN) of the IAM user or role.
     * For more information about IAM ARNs, wildcards, and formats, see [IAM Identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html) in the *IAM User Guide*.
     */
    public val approvalRuleContent: kotlin.String? = builder.approvalRuleContent
    /**
     * The name for the approval rule.
     */
    public val approvalRuleName: kotlin.String? = builder.approvalRuleName
    /**
     * The system-generated ID of the pull request for which you want to create the approval rule.
     */
    public val pullRequestId: kotlin.String? = builder.pullRequestId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codecommit.model.CreatePullRequestApprovalRuleRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreatePullRequestApprovalRuleRequest(")
        append("approvalRuleContent=$approvalRuleContent,")
        append("approvalRuleName=$approvalRuleName,")
        append("pullRequestId=$pullRequestId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = approvalRuleContent?.hashCode() ?: 0
        result = 31 * result + (approvalRuleName?.hashCode() ?: 0)
        result = 31 * result + (pullRequestId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreatePullRequestApprovalRuleRequest

        if (approvalRuleContent != other.approvalRuleContent) return false
        if (approvalRuleName != other.approvalRuleName) return false
        if (pullRequestId != other.pullRequestId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codecommit.model.CreatePullRequestApprovalRuleRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The content of the approval rule, including the number of approvals needed and the structure of an approval pool defined for approvals, if any. For more information about approval pools, see the AWS CodeCommit User Guide.
         *
         * When you create the content of the approval rule, you can specify approvers in an approval pool in one of two ways:
         * + **CodeCommitApprovers**: This option only requires an AWS account and a resource. It can be used for both IAM users and federated access users whose name matches the provided resource name. This is a very powerful option that offers a great deal of flexibility. For example, if you specify the AWS account *123456789012* and *Mary_Major*, all of the following would be counted as approvals coming from that user:
         *    + An IAM user in the account (arn:aws:iam::*123456789012*:user&#47;*Mary_Major*)
         *    + A federated user identified in IAM as Mary_Major (arn:aws:sts::*123456789012*:federated-user&#47;*Mary_Major*)
         * This option does not recognize an active session of someone assuming the role of CodeCommitReview with a role session name of *Mary_Major* (arn:aws:sts::*123456789012*:assumed-role/CodeCommitReview&#47;*Mary_Major*) unless you include a wildcard (*Mary_Major).
         * + **Fully qualified ARN**: This option allows you to specify the fully qualified Amazon Resource Name (ARN) of the IAM user or role.
         * For more information about IAM ARNs, wildcards, and formats, see [IAM Identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html) in the *IAM User Guide*.
         */
        public var approvalRuleContent: kotlin.String? = null
        /**
         * The name for the approval rule.
         */
        public var approvalRuleName: kotlin.String? = null
        /**
         * The system-generated ID of the pull request for which you want to create the approval rule.
         */
        public var pullRequestId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codecommit.model.CreatePullRequestApprovalRuleRequest) : this() {
            this.approvalRuleContent = x.approvalRuleContent
            this.approvalRuleName = x.approvalRuleName
            this.pullRequestId = x.pullRequestId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codecommit.model.CreatePullRequestApprovalRuleRequest = CreatePullRequestApprovalRuleRequest(this)
    }
}
