// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecommit.model



/**
 * Represents the input of a create repository operation.
 */
public class CreateRepositoryRequest private constructor(builder: Builder) {
    /**
     * A comment or description about the new repository.
     *
     * The description field for a repository accepts all HTML characters and all valid Unicode characters. Applications that do not HTML-encode the description and display it in a webpage can expose users to potentially malicious code. Make sure that you HTML-encode the description field in any application that uses this API to display the repository description on a webpage.
     */
    public val repositoryDescription: kotlin.String? = builder.repositoryDescription
    /**
     * The name of the new repository to be created.
     *
     * The repository name must be unique across the calling AWS account. Repository names are limited to 100 alphanumeric, dash, and underscore characters, and cannot include certain characters. For more information about the limits on repository names, see [Limits](https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html) in the *AWS CodeCommit User Guide*. The suffix .git is prohibited.
     */
    public val repositoryName: kotlin.String? = builder.repositoryName
    /**
     * One or more tag key-value pairs to use when tagging this repository.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codecommit.model.CreateRepositoryRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateRepositoryRequest(")
        append("repositoryDescription=$repositoryDescription,")
        append("repositoryName=$repositoryName,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = repositoryDescription?.hashCode() ?: 0
        result = 31 * result + (repositoryName?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateRepositoryRequest

        if (repositoryDescription != other.repositoryDescription) return false
        if (repositoryName != other.repositoryName) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codecommit.model.CreateRepositoryRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A comment or description about the new repository.
         *
         * The description field for a repository accepts all HTML characters and all valid Unicode characters. Applications that do not HTML-encode the description and display it in a webpage can expose users to potentially malicious code. Make sure that you HTML-encode the description field in any application that uses this API to display the repository description on a webpage.
         */
        public var repositoryDescription: kotlin.String? = null
        /**
         * The name of the new repository to be created.
         *
         * The repository name must be unique across the calling AWS account. Repository names are limited to 100 alphanumeric, dash, and underscore characters, and cannot include certain characters. For more information about the limits on repository names, see [Limits](https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html) in the *AWS CodeCommit User Guide*. The suffix .git is prohibited.
         */
        public var repositoryName: kotlin.String? = null
        /**
         * One or more tag key-value pairs to use when tagging this repository.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codecommit.model.CreateRepositoryRequest) : this() {
            this.repositoryDescription = x.repositoryDescription
            this.repositoryName = x.repositoryName
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codecommit.model.CreateRepositoryRequest = CreateRepositoryRequest(this)
    }
}
