// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecommit.model



/**
 * Information about a file added or updated as part of a commit.
 */
public class PutFileEntry private constructor(builder: Builder) {
    /**
     * The content of the file, if a source file is not specified.
     */
    public val fileContent: kotlin.ByteArray? = builder.fileContent
    /**
     * The extrapolated file mode permissions for the file. Valid values include EXECUTABLE and NORMAL.
     */
    public val fileMode: aws.sdk.kotlin.services.codecommit.model.FileModeTypeEnum? = builder.fileMode
    /**
     * The full path to the file in the repository, including the name of the file.
     */
    public val filePath: kotlin.String? = builder.filePath
    /**
     * The name and full path of the file that contains the changes you want to make as part of the commit, if you are not providing the file content directly.
     */
    public val sourceFile: aws.sdk.kotlin.services.codecommit.model.SourceFileSpecifier? = builder.sourceFile

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codecommit.model.PutFileEntry = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutFileEntry(")
        append("fileContent=$fileContent,")
        append("fileMode=$fileMode,")
        append("filePath=$filePath,")
        append("sourceFile=$sourceFile)")
    }

    override fun hashCode(): kotlin.Int {
        var result = fileContent?.contentHashCode() ?: 0
        result = 31 * result + (fileMode?.hashCode() ?: 0)
        result = 31 * result + (filePath?.hashCode() ?: 0)
        result = 31 * result + (sourceFile?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutFileEntry

        if (fileContent != null) {
            if (other.fileContent == null) return false
            if (!fileContent.contentEquals(other.fileContent)) return false
        } else if (other.fileContent != null) return false
        if (fileMode != other.fileMode) return false
        if (filePath != other.filePath) return false
        if (sourceFile != other.sourceFile) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codecommit.model.PutFileEntry = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The content of the file, if a source file is not specified.
         */
        public var fileContent: kotlin.ByteArray? = null
        /**
         * The extrapolated file mode permissions for the file. Valid values include EXECUTABLE and NORMAL.
         */
        public var fileMode: aws.sdk.kotlin.services.codecommit.model.FileModeTypeEnum? = null
        /**
         * The full path to the file in the repository, including the name of the file.
         */
        public var filePath: kotlin.String? = null
        /**
         * The name and full path of the file that contains the changes you want to make as part of the commit, if you are not providing the file content directly.
         */
        public var sourceFile: aws.sdk.kotlin.services.codecommit.model.SourceFileSpecifier? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codecommit.model.PutFileEntry) : this() {
            this.fileContent = x.fileContent
            this.fileMode = x.fileMode
            this.filePath = x.filePath
            this.sourceFile = x.sourceFile
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codecommit.model.PutFileEntry = PutFileEntry(this)

        /**
         * construct an [aws.sdk.kotlin.services.codecommit.model.SourceFileSpecifier] inside the given [block]
         */
        public fun sourceFile(block: aws.sdk.kotlin.services.codecommit.model.SourceFileSpecifier.Builder.() -> kotlin.Unit) {
            this.sourceFile = aws.sdk.kotlin.services.codecommit.model.SourceFileSpecifier.invoke(block)
        }
    }
}
