// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecommit.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.codecommit.model.BatchAssociateApprovalRuleTemplateWithRepositoriesError
import aws.sdk.kotlin.services.codecommit.model.BatchAssociateApprovalRuleTemplateWithRepositoriesResponse
import aws.sdk.kotlin.services.codecommit.model.CodeCommitException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class BatchAssociateApprovalRuleTemplateWithRepositoriesOperationDeserializer: HttpDeserialize<BatchAssociateApprovalRuleTemplateWithRepositoriesResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): BatchAssociateApprovalRuleTemplateWithRepositoriesResponse {
        if (!response.status.isSuccess()) {
            throwBatchAssociateApprovalRuleTemplateWithRepositoriesError(context, response)
        }
        val builder = BatchAssociateApprovalRuleTemplateWithRepositoriesResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeBatchAssociateApprovalRuleTemplateWithRepositoriesOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwBatchAssociateApprovalRuleTemplateWithRepositoriesError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CodeCommitException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ApprovalRuleTemplateDoesNotExistException" -> ApprovalRuleTemplateDoesNotExistExceptionDeserializer().deserialize(context, wrappedResponse)
        "ApprovalRuleTemplateNameRequiredException" -> ApprovalRuleTemplateNameRequiredExceptionDeserializer().deserialize(context, wrappedResponse)
        "EncryptionIntegrityChecksFailedException" -> EncryptionIntegrityChecksFailedExceptionDeserializer().deserialize(context, wrappedResponse)
        "EncryptionKeyAccessDeniedException" -> EncryptionKeyAccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "EncryptionKeyDisabledException" -> EncryptionKeyDisabledExceptionDeserializer().deserialize(context, wrappedResponse)
        "EncryptionKeyNotFoundException" -> EncryptionKeyNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "EncryptionKeyUnavailableException" -> EncryptionKeyUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidApprovalRuleTemplateNameException" -> InvalidApprovalRuleTemplateNameExceptionDeserializer().deserialize(context, wrappedResponse)
        "MaximumRepositoryNamesExceededException" -> MaximumRepositoryNamesExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "RepositoryNamesRequiredException" -> RepositoryNamesRequiredExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CodeCommitException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeBatchAssociateApprovalRuleTemplateWithRepositoriesOperationBody(builder: BatchAssociateApprovalRuleTemplateWithRepositoriesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ASSOCIATEDREPOSITORYNAMES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("associatedRepositoryNames"))
    val ERRORS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("errors"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ASSOCIATEDREPOSITORYNAMES_DESCRIPTOR)
        field(ERRORS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ASSOCIATEDREPOSITORYNAMES_DESCRIPTOR.index -> builder.associatedRepositoryNames =
                    deserializer.deserializeList(ASSOCIATEDREPOSITORYNAMES_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ERRORS_DESCRIPTOR.index -> builder.errors =
                    deserializer.deserializeList(ERRORS_DESCRIPTOR) {
                        val col0 = mutableListOf<BatchAssociateApprovalRuleTemplateWithRepositoriesError>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeBatchAssociateApprovalRuleTemplateWithRepositoriesErrorDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
