// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecommit.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.codecommit.model.BatchDescribeMergeConflictsError
import aws.sdk.kotlin.services.codecommit.model.BatchDescribeMergeConflictsResponse
import aws.sdk.kotlin.services.codecommit.model.CodeCommitException
import aws.sdk.kotlin.services.codecommit.model.Conflict
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class BatchDescribeMergeConflictsOperationDeserializer: HttpDeserialize<BatchDescribeMergeConflictsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): BatchDescribeMergeConflictsResponse {
        if (!response.status.isSuccess()) {
            throwBatchDescribeMergeConflictsError(context, response)
        }
        val builder = BatchDescribeMergeConflictsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeBatchDescribeMergeConflictsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwBatchDescribeMergeConflictsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CodeCommitException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "CommitDoesNotExistException" -> CommitDoesNotExistExceptionDeserializer().deserialize(context, wrappedResponse)
        "CommitRequiredException" -> CommitRequiredExceptionDeserializer().deserialize(context, wrappedResponse)
        "EncryptionIntegrityChecksFailedException" -> EncryptionIntegrityChecksFailedExceptionDeserializer().deserialize(context, wrappedResponse)
        "EncryptionKeyAccessDeniedException" -> EncryptionKeyAccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "EncryptionKeyDisabledException" -> EncryptionKeyDisabledExceptionDeserializer().deserialize(context, wrappedResponse)
        "EncryptionKeyNotFoundException" -> EncryptionKeyNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "EncryptionKeyUnavailableException" -> EncryptionKeyUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidCommitException" -> InvalidCommitExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidConflictDetailLevelException" -> InvalidConflictDetailLevelExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidConflictResolutionStrategyException" -> InvalidConflictResolutionStrategyExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidContinuationTokenException" -> InvalidContinuationTokenExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidMaxConflictFilesException" -> InvalidMaxConflictFilesExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidMaxMergeHunksException" -> InvalidMaxMergeHunksExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidMergeOptionException" -> InvalidMergeOptionExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRepositoryNameException" -> InvalidRepositoryNameExceptionDeserializer().deserialize(context, wrappedResponse)
        "MaximumFileContentToLoadExceededException" -> MaximumFileContentToLoadExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "MaximumItemsToCompareExceededException" -> MaximumItemsToCompareExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "MergeOptionRequiredException" -> MergeOptionRequiredExceptionDeserializer().deserialize(context, wrappedResponse)
        "RepositoryDoesNotExistException" -> RepositoryDoesNotExistExceptionDeserializer().deserialize(context, wrappedResponse)
        "RepositoryNameRequiredException" -> RepositoryNameRequiredExceptionDeserializer().deserialize(context, wrappedResponse)
        "TipsDivergenceExceededException" -> TipsDivergenceExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CodeCommitException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeBatchDescribeMergeConflictsOperationBody(builder: BatchDescribeMergeConflictsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BASECOMMITID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("baseCommitId"))
    val CONFLICTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("conflicts"))
    val DESTINATIONCOMMITID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("destinationCommitId"))
    val ERRORS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("errors"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nextToken"))
    val SOURCECOMMITID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("sourceCommitId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BASECOMMITID_DESCRIPTOR)
        field(CONFLICTS_DESCRIPTOR)
        field(DESTINATIONCOMMITID_DESCRIPTOR)
        field(ERRORS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(SOURCECOMMITID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BASECOMMITID_DESCRIPTOR.index -> builder.baseCommitId = deserializeString()
                CONFLICTS_DESCRIPTOR.index -> builder.conflicts =
                    deserializer.deserializeList(CONFLICTS_DESCRIPTOR) {
                        val col0 = mutableListOf<Conflict>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeConflictDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                DESTINATIONCOMMITID_DESCRIPTOR.index -> builder.destinationCommitId = deserializeString()
                ERRORS_DESCRIPTOR.index -> builder.errors =
                    deserializer.deserializeList(ERRORS_DESCRIPTOR) {
                        val col0 = mutableListOf<BatchDescribeMergeConflictsError>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeBatchDescribeMergeConflictsErrorDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                SOURCECOMMITID_DESCRIPTOR.index -> builder.sourceCommitId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
