// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecommit.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.codecommit.model.CodeCommitException
import aws.sdk.kotlin.services.codecommit.model.CreateRepositoryResponse
import aws.sdk.kotlin.services.codecommit.model.RepositoryMetadata
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateRepositoryOperationDeserializer: HttpDeserialize<CreateRepositoryResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateRepositoryResponse {
        if (!response.status.isSuccess()) {
            throwCreateRepositoryError(context, response)
        }
        val builder = CreateRepositoryResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateRepositoryOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreateRepositoryError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CodeCommitException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "EncryptionIntegrityChecksFailedException" -> EncryptionIntegrityChecksFailedExceptionDeserializer().deserialize(context, wrappedResponse)
        "EncryptionKeyAccessDeniedException" -> EncryptionKeyAccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "EncryptionKeyDisabledException" -> EncryptionKeyDisabledExceptionDeserializer().deserialize(context, wrappedResponse)
        "EncryptionKeyNotFoundException" -> EncryptionKeyNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "EncryptionKeyUnavailableException" -> EncryptionKeyUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRepositoryDescriptionException" -> InvalidRepositoryDescriptionExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRepositoryNameException" -> InvalidRepositoryNameExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidSystemTagUsageException" -> InvalidSystemTagUsageExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidTagsMapException" -> InvalidTagsMapExceptionDeserializer().deserialize(context, wrappedResponse)
        "RepositoryLimitExceededException" -> RepositoryLimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "RepositoryNameExistsException" -> RepositoryNameExistsExceptionDeserializer().deserialize(context, wrappedResponse)
        "RepositoryNameRequiredException" -> RepositoryNameRequiredExceptionDeserializer().deserialize(context, wrappedResponse)
        "TagPolicyException" -> TagPolicyExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyTagsException" -> TooManyTagsExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CodeCommitException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateRepositoryOperationBody(builder: CreateRepositoryResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val REPOSITORYMETADATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("repositoryMetadata"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(REPOSITORYMETADATA_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                REPOSITORYMETADATA_DESCRIPTOR.index -> builder.repositoryMetadata = deserializeRepositoryMetadataDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
