// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecommit.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.codecommit.model.CodeCommitException
import aws.sdk.kotlin.services.codecommit.model.DeleteFileResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DeleteFileOperationDeserializer: HttpDeserialize<DeleteFileResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DeleteFileResponse {
        if (!response.status.isSuccess()) {
            throwDeleteFileError(context, response)
        }
        val builder = DeleteFileResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDeleteFileOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDeleteFileError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CodeCommitException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BranchDoesNotExistException" -> BranchDoesNotExistExceptionDeserializer().deserialize(context, wrappedResponse)
        "BranchNameIsTagNameException" -> BranchNameIsTagNameExceptionDeserializer().deserialize(context, wrappedResponse)
        "BranchNameRequiredException" -> BranchNameRequiredExceptionDeserializer().deserialize(context, wrappedResponse)
        "CommitMessageLengthExceededException" -> CommitMessageLengthExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "EncryptionIntegrityChecksFailedException" -> EncryptionIntegrityChecksFailedExceptionDeserializer().deserialize(context, wrappedResponse)
        "EncryptionKeyAccessDeniedException" -> EncryptionKeyAccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "EncryptionKeyDisabledException" -> EncryptionKeyDisabledExceptionDeserializer().deserialize(context, wrappedResponse)
        "EncryptionKeyNotFoundException" -> EncryptionKeyNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "EncryptionKeyUnavailableException" -> EncryptionKeyUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        "FileDoesNotExistException" -> FileDoesNotExistExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidBranchNameException" -> InvalidBranchNameExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidEmailException" -> InvalidEmailExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidParentCommitIdException" -> InvalidParentCommitIdExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidPathException" -> InvalidPathExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRepositoryNameException" -> InvalidRepositoryNameExceptionDeserializer().deserialize(context, wrappedResponse)
        "NameLengthExceededException" -> NameLengthExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ParentCommitDoesNotExistException" -> ParentCommitDoesNotExistExceptionDeserializer().deserialize(context, wrappedResponse)
        "ParentCommitIdOutdatedException" -> ParentCommitIdOutdatedExceptionDeserializer().deserialize(context, wrappedResponse)
        "ParentCommitIdRequiredException" -> ParentCommitIdRequiredExceptionDeserializer().deserialize(context, wrappedResponse)
        "PathRequiredException" -> PathRequiredExceptionDeserializer().deserialize(context, wrappedResponse)
        "RepositoryDoesNotExistException" -> RepositoryDoesNotExistExceptionDeserializer().deserialize(context, wrappedResponse)
        "RepositoryNameRequiredException" -> RepositoryNameRequiredExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CodeCommitException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDeleteFileOperationBody(builder: DeleteFileResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BLOBID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("blobId"))
    val COMMITID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("commitId"))
    val FILEPATH_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("filePath"))
    val TREEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("treeId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BLOBID_DESCRIPTOR)
        field(COMMITID_DESCRIPTOR)
        field(FILEPATH_DESCRIPTOR)
        field(TREEID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BLOBID_DESCRIPTOR.index -> builder.blobId = deserializeString()
                COMMITID_DESCRIPTOR.index -> builder.commitId = deserializeString()
                FILEPATH_DESCRIPTOR.index -> builder.filePath = deserializeString()
                TREEID_DESCRIPTOR.index -> builder.treeId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
