// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecommit.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.codecommit.model.CodeCommitException
import aws.sdk.kotlin.services.codecommit.model.CommentsForComparedCommit
import aws.sdk.kotlin.services.codecommit.model.GetCommentsForComparedCommitResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class GetCommentsForComparedCommitOperationDeserializer: HttpDeserialize<GetCommentsForComparedCommitResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetCommentsForComparedCommitResponse {
        if (!response.status.isSuccess()) {
            throwGetCommentsForComparedCommitError(context, response)
        }
        val builder = GetCommentsForComparedCommitResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetCommentsForComparedCommitOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetCommentsForComparedCommitError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CodeCommitException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "CommitDoesNotExistException" -> CommitDoesNotExistExceptionDeserializer().deserialize(context, wrappedResponse)
        "CommitIdRequiredException" -> CommitIdRequiredExceptionDeserializer().deserialize(context, wrappedResponse)
        "EncryptionIntegrityChecksFailedException" -> EncryptionIntegrityChecksFailedExceptionDeserializer().deserialize(context, wrappedResponse)
        "EncryptionKeyAccessDeniedException" -> EncryptionKeyAccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "EncryptionKeyDisabledException" -> EncryptionKeyDisabledExceptionDeserializer().deserialize(context, wrappedResponse)
        "EncryptionKeyNotFoundException" -> EncryptionKeyNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "EncryptionKeyUnavailableException" -> EncryptionKeyUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidCommitIdException" -> InvalidCommitIdExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidContinuationTokenException" -> InvalidContinuationTokenExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidMaxResultsException" -> InvalidMaxResultsExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRepositoryNameException" -> InvalidRepositoryNameExceptionDeserializer().deserialize(context, wrappedResponse)
        "RepositoryDoesNotExistException" -> RepositoryDoesNotExistExceptionDeserializer().deserialize(context, wrappedResponse)
        "RepositoryNameRequiredException" -> RepositoryNameRequiredExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CodeCommitException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetCommentsForComparedCommitOperationBody(builder: GetCommentsForComparedCommitResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val COMMENTSFORCOMPAREDCOMMITDATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("commentsForComparedCommitData"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nextToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(COMMENTSFORCOMPAREDCOMMITDATA_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                COMMENTSFORCOMPAREDCOMMITDATA_DESCRIPTOR.index -> builder.commentsForComparedCommitData =
                    deserializer.deserializeList(COMMENTSFORCOMPAREDCOMMITDATA_DESCRIPTOR) {
                        val col0 = mutableListOf<CommentsForComparedCommit>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeCommentsForComparedCommitDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
