// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecommit.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.codecommit.model.CodeCommitException
import aws.sdk.kotlin.services.codecommit.model.FileModeTypeEnum
import aws.sdk.kotlin.services.codecommit.model.GetFileResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.util.decodeBase64Bytes


internal class GetFileOperationDeserializer: HttpDeserialize<GetFileResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetFileResponse {
        if (!response.status.isSuccess()) {
            throwGetFileError(context, response)
        }
        val builder = GetFileResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetFileOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetFileError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CodeCommitException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "CommitDoesNotExistException" -> CommitDoesNotExistExceptionDeserializer().deserialize(context, wrappedResponse)
        "EncryptionIntegrityChecksFailedException" -> EncryptionIntegrityChecksFailedExceptionDeserializer().deserialize(context, wrappedResponse)
        "EncryptionKeyAccessDeniedException" -> EncryptionKeyAccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "EncryptionKeyDisabledException" -> EncryptionKeyDisabledExceptionDeserializer().deserialize(context, wrappedResponse)
        "EncryptionKeyNotFoundException" -> EncryptionKeyNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "EncryptionKeyUnavailableException" -> EncryptionKeyUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        "FileDoesNotExistException" -> FileDoesNotExistExceptionDeserializer().deserialize(context, wrappedResponse)
        "FileTooLargeException" -> FileTooLargeExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidCommitException" -> InvalidCommitExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidPathException" -> InvalidPathExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRepositoryNameException" -> InvalidRepositoryNameExceptionDeserializer().deserialize(context, wrappedResponse)
        "PathRequiredException" -> PathRequiredExceptionDeserializer().deserialize(context, wrappedResponse)
        "RepositoryDoesNotExistException" -> RepositoryDoesNotExistExceptionDeserializer().deserialize(context, wrappedResponse)
        "RepositoryNameRequiredException" -> RepositoryNameRequiredExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CodeCommitException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetFileOperationBody(builder: GetFileResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BLOBID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("blobId"))
    val COMMITID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("commitId"))
    val FILECONTENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Blob, JsonSerialName("fileContent"))
    val FILEMODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("fileMode"))
    val FILEPATH_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("filePath"))
    val FILESIZE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("fileSize"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BLOBID_DESCRIPTOR)
        field(COMMITID_DESCRIPTOR)
        field(FILECONTENT_DESCRIPTOR)
        field(FILEMODE_DESCRIPTOR)
        field(FILEPATH_DESCRIPTOR)
        field(FILESIZE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BLOBID_DESCRIPTOR.index -> builder.blobId = deserializeString()
                COMMITID_DESCRIPTOR.index -> builder.commitId = deserializeString()
                FILECONTENT_DESCRIPTOR.index -> builder.fileContent = deserializeString().decodeBase64Bytes()
                FILEMODE_DESCRIPTOR.index -> builder.fileMode = deserializeString().let { FileModeTypeEnum.fromValue(it) }
                FILEPATH_DESCRIPTOR.index -> builder.filePath = deserializeString()
                FILESIZE_DESCRIPTOR.index -> builder.fileSize = deserializeLong()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
