// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecommit.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.codecommit.model.CodeCommitException
import aws.sdk.kotlin.services.codecommit.model.File
import aws.sdk.kotlin.services.codecommit.model.Folder
import aws.sdk.kotlin.services.codecommit.model.GetFolderResponse
import aws.sdk.kotlin.services.codecommit.model.SubModule
import aws.sdk.kotlin.services.codecommit.model.SymbolicLink
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class GetFolderOperationDeserializer: HttpDeserialize<GetFolderResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetFolderResponse {
        if (!response.status.isSuccess()) {
            throwGetFolderError(context, response)
        }
        val builder = GetFolderResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetFolderOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetFolderError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CodeCommitException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "CommitDoesNotExistException" -> CommitDoesNotExistExceptionDeserializer().deserialize(context, wrappedResponse)
        "EncryptionIntegrityChecksFailedException" -> EncryptionIntegrityChecksFailedExceptionDeserializer().deserialize(context, wrappedResponse)
        "EncryptionKeyAccessDeniedException" -> EncryptionKeyAccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "EncryptionKeyDisabledException" -> EncryptionKeyDisabledExceptionDeserializer().deserialize(context, wrappedResponse)
        "EncryptionKeyNotFoundException" -> EncryptionKeyNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "EncryptionKeyUnavailableException" -> EncryptionKeyUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        "FolderDoesNotExistException" -> FolderDoesNotExistExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidCommitException" -> InvalidCommitExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidPathException" -> InvalidPathExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRepositoryNameException" -> InvalidRepositoryNameExceptionDeserializer().deserialize(context, wrappedResponse)
        "PathRequiredException" -> PathRequiredExceptionDeserializer().deserialize(context, wrappedResponse)
        "RepositoryDoesNotExistException" -> RepositoryDoesNotExistExceptionDeserializer().deserialize(context, wrappedResponse)
        "RepositoryNameRequiredException" -> RepositoryNameRequiredExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CodeCommitException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetFolderOperationBody(builder: GetFolderResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val COMMITID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("commitId"))
    val FILES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("files"))
    val FOLDERPATH_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("folderPath"))
    val SUBFOLDERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("subFolders"))
    val SUBMODULES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("subModules"))
    val SYMBOLICLINKS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("symbolicLinks"))
    val TREEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("treeId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(COMMITID_DESCRIPTOR)
        field(FILES_DESCRIPTOR)
        field(FOLDERPATH_DESCRIPTOR)
        field(SUBFOLDERS_DESCRIPTOR)
        field(SUBMODULES_DESCRIPTOR)
        field(SYMBOLICLINKS_DESCRIPTOR)
        field(TREEID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                COMMITID_DESCRIPTOR.index -> builder.commitId = deserializeString()
                FILES_DESCRIPTOR.index -> builder.files =
                    deserializer.deserializeList(FILES_DESCRIPTOR) {
                        val col0 = mutableListOf<File>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeFileDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                FOLDERPATH_DESCRIPTOR.index -> builder.folderPath = deserializeString()
                SUBFOLDERS_DESCRIPTOR.index -> builder.subFolders =
                    deserializer.deserializeList(SUBFOLDERS_DESCRIPTOR) {
                        val col0 = mutableListOf<Folder>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeFolderDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                SUBMODULES_DESCRIPTOR.index -> builder.subModules =
                    deserializer.deserializeList(SUBMODULES_DESCRIPTOR) {
                        val col0 = mutableListOf<SubModule>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeSubModuleDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                SYMBOLICLINKS_DESCRIPTOR.index -> builder.symbolicLinks =
                    deserializer.deserializeList(SYMBOLICLINKS_DESCRIPTOR) {
                        val col0 = mutableListOf<SymbolicLink>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeSymbolicLinkDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                TREEID_DESCRIPTOR.index -> builder.treeId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
