// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecommit.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.codecommit.model.CodeCommitException
import aws.sdk.kotlin.services.codecommit.model.GetPullRequestOverrideStateResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetPullRequestOverrideStateOperationDeserializer: HttpDeserialize<GetPullRequestOverrideStateResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetPullRequestOverrideStateResponse {
        if (!response.status.isSuccess()) {
            throwGetPullRequestOverrideStateError(context, response)
        }
        val builder = GetPullRequestOverrideStateResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetPullRequestOverrideStateOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetPullRequestOverrideStateError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CodeCommitException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "EncryptionIntegrityChecksFailedException" -> EncryptionIntegrityChecksFailedExceptionDeserializer().deserialize(context, wrappedResponse)
        "EncryptionKeyAccessDeniedException" -> EncryptionKeyAccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "EncryptionKeyDisabledException" -> EncryptionKeyDisabledExceptionDeserializer().deserialize(context, wrappedResponse)
        "EncryptionKeyNotFoundException" -> EncryptionKeyNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "EncryptionKeyUnavailableException" -> EncryptionKeyUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidPullRequestIdException" -> InvalidPullRequestIdExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRevisionIdException" -> InvalidRevisionIdExceptionDeserializer().deserialize(context, wrappedResponse)
        "PullRequestDoesNotExistException" -> PullRequestDoesNotExistExceptionDeserializer().deserialize(context, wrappedResponse)
        "PullRequestIdRequiredException" -> PullRequestIdRequiredExceptionDeserializer().deserialize(context, wrappedResponse)
        "RevisionIdRequiredException" -> RevisionIdRequiredExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CodeCommitException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetPullRequestOverrideStateOperationBody(builder: GetPullRequestOverrideStateResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val OVERRIDDEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("overridden"))
    val OVERRIDER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("overrider"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(OVERRIDDEN_DESCRIPTOR)
        field(OVERRIDER_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                OVERRIDDEN_DESCRIPTOR.index -> builder.overridden = deserializeBoolean()
                OVERRIDER_DESCRIPTOR.index -> builder.overrider = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
