// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecommit.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.codecommit.model.CodeCommitException
import aws.sdk.kotlin.services.codecommit.model.MergePullRequestByFastForwardResponse
import aws.sdk.kotlin.services.codecommit.model.PullRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class MergePullRequestByFastForwardOperationDeserializer: HttpDeserialize<MergePullRequestByFastForwardResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): MergePullRequestByFastForwardResponse {
        if (!response.status.isSuccess()) {
            throwMergePullRequestByFastForwardError(context, response)
        }
        val builder = MergePullRequestByFastForwardResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeMergePullRequestByFastForwardOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwMergePullRequestByFastForwardError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CodeCommitException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ConcurrentReferenceUpdateException" -> ConcurrentReferenceUpdateExceptionDeserializer().deserialize(context, wrappedResponse)
        "EncryptionIntegrityChecksFailedException" -> EncryptionIntegrityChecksFailedExceptionDeserializer().deserialize(context, wrappedResponse)
        "EncryptionKeyAccessDeniedException" -> EncryptionKeyAccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "EncryptionKeyDisabledException" -> EncryptionKeyDisabledExceptionDeserializer().deserialize(context, wrappedResponse)
        "EncryptionKeyNotFoundException" -> EncryptionKeyNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "EncryptionKeyUnavailableException" -> EncryptionKeyUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidCommitIdException" -> InvalidCommitIdExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidPullRequestIdException" -> InvalidPullRequestIdExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRepositoryNameException" -> InvalidRepositoryNameExceptionDeserializer().deserialize(context, wrappedResponse)
        "ManualMergeRequiredException" -> ManualMergeRequiredExceptionDeserializer().deserialize(context, wrappedResponse)
        "PullRequestAlreadyClosedException" -> PullRequestAlreadyClosedExceptionDeserializer().deserialize(context, wrappedResponse)
        "PullRequestApprovalRulesNotSatisfiedException" -> PullRequestApprovalRulesNotSatisfiedExceptionDeserializer().deserialize(context, wrappedResponse)
        "PullRequestDoesNotExistException" -> PullRequestDoesNotExistExceptionDeserializer().deserialize(context, wrappedResponse)
        "PullRequestIdRequiredException" -> PullRequestIdRequiredExceptionDeserializer().deserialize(context, wrappedResponse)
        "ReferenceDoesNotExistException" -> ReferenceDoesNotExistExceptionDeserializer().deserialize(context, wrappedResponse)
        "RepositoryDoesNotExistException" -> RepositoryDoesNotExistExceptionDeserializer().deserialize(context, wrappedResponse)
        "RepositoryNameRequiredException" -> RepositoryNameRequiredExceptionDeserializer().deserialize(context, wrappedResponse)
        "RepositoryNotAssociatedWithPullRequestException" -> RepositoryNotAssociatedWithPullRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "TipOfSourceReferenceIsDifferentException" -> TipOfSourceReferenceIsDifferentExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CodeCommitException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeMergePullRequestByFastForwardOperationBody(builder: MergePullRequestByFastForwardResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val PULLREQUEST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("pullRequest"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(PULLREQUEST_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                PULLREQUEST_DESCRIPTOR.index -> builder.pullRequest = deserializePullRequestDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
