// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecommit.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.codecommit.model.CodeCommitException
import aws.sdk.kotlin.services.codecommit.model.MergePullRequestBySquashResponse
import aws.sdk.kotlin.services.codecommit.model.PullRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class MergePullRequestBySquashOperationDeserializer: HttpDeserialize<MergePullRequestBySquashResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): MergePullRequestBySquashResponse {
        if (!response.status.isSuccess()) {
            throwMergePullRequestBySquashError(context, response)
        }
        val builder = MergePullRequestBySquashResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeMergePullRequestBySquashOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwMergePullRequestBySquashError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CodeCommitException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "CommitMessageLengthExceededException" -> CommitMessageLengthExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ConcurrentReferenceUpdateException" -> ConcurrentReferenceUpdateExceptionDeserializer().deserialize(context, wrappedResponse)
        "EncryptionIntegrityChecksFailedException" -> EncryptionIntegrityChecksFailedExceptionDeserializer().deserialize(context, wrappedResponse)
        "EncryptionKeyAccessDeniedException" -> EncryptionKeyAccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "EncryptionKeyDisabledException" -> EncryptionKeyDisabledExceptionDeserializer().deserialize(context, wrappedResponse)
        "EncryptionKeyNotFoundException" -> EncryptionKeyNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "EncryptionKeyUnavailableException" -> EncryptionKeyUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        "FileContentSizeLimitExceededException" -> FileContentSizeLimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "FolderContentSizeLimitExceededException" -> FolderContentSizeLimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidCommitIdException" -> InvalidCommitIdExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidConflictDetailLevelException" -> InvalidConflictDetailLevelExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidConflictResolutionException" -> InvalidConflictResolutionExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidConflictResolutionStrategyException" -> InvalidConflictResolutionStrategyExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidEmailException" -> InvalidEmailExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidFileModeException" -> InvalidFileModeExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidPathException" -> InvalidPathExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidPullRequestIdException" -> InvalidPullRequestIdExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidReplacementContentException" -> InvalidReplacementContentExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidReplacementTypeException" -> InvalidReplacementTypeExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRepositoryNameException" -> InvalidRepositoryNameExceptionDeserializer().deserialize(context, wrappedResponse)
        "ManualMergeRequiredException" -> ManualMergeRequiredExceptionDeserializer().deserialize(context, wrappedResponse)
        "MaximumConflictResolutionEntriesExceededException" -> MaximumConflictResolutionEntriesExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "MaximumFileContentToLoadExceededException" -> MaximumFileContentToLoadExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "MaximumItemsToCompareExceededException" -> MaximumItemsToCompareExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "MultipleConflictResolutionEntriesException" -> MultipleConflictResolutionEntriesExceptionDeserializer().deserialize(context, wrappedResponse)
        "NameLengthExceededException" -> NameLengthExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "PathRequiredException" -> PathRequiredExceptionDeserializer().deserialize(context, wrappedResponse)
        "PullRequestAlreadyClosedException" -> PullRequestAlreadyClosedExceptionDeserializer().deserialize(context, wrappedResponse)
        "PullRequestApprovalRulesNotSatisfiedException" -> PullRequestApprovalRulesNotSatisfiedExceptionDeserializer().deserialize(context, wrappedResponse)
        "PullRequestDoesNotExistException" -> PullRequestDoesNotExistExceptionDeserializer().deserialize(context, wrappedResponse)
        "PullRequestIdRequiredException" -> PullRequestIdRequiredExceptionDeserializer().deserialize(context, wrappedResponse)
        "ReplacementContentRequiredException" -> ReplacementContentRequiredExceptionDeserializer().deserialize(context, wrappedResponse)
        "ReplacementTypeRequiredException" -> ReplacementTypeRequiredExceptionDeserializer().deserialize(context, wrappedResponse)
        "RepositoryDoesNotExistException" -> RepositoryDoesNotExistExceptionDeserializer().deserialize(context, wrappedResponse)
        "RepositoryNameRequiredException" -> RepositoryNameRequiredExceptionDeserializer().deserialize(context, wrappedResponse)
        "RepositoryNotAssociatedWithPullRequestException" -> RepositoryNotAssociatedWithPullRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "TipOfSourceReferenceIsDifferentException" -> TipOfSourceReferenceIsDifferentExceptionDeserializer().deserialize(context, wrappedResponse)
        "TipsDivergenceExceededException" -> TipsDivergenceExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CodeCommitException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeMergePullRequestBySquashOperationBody(builder: MergePullRequestBySquashResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val PULLREQUEST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("pullRequest"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(PULLREQUEST_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                PULLREQUEST_DESCRIPTOR.index -> builder.pullRequest = deserializePullRequestDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
