// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecommit.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.codecommit.model.CodeCommitException
import aws.sdk.kotlin.services.codecommit.model.Comment
import aws.sdk.kotlin.services.codecommit.model.Location
import aws.sdk.kotlin.services.codecommit.model.PostCommentForComparedCommitResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class PostCommentForComparedCommitOperationDeserializer: HttpDeserialize<PostCommentForComparedCommitResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): PostCommentForComparedCommitResponse {
        if (!response.status.isSuccess()) {
            throwPostCommentForComparedCommitError(context, response)
        }
        val builder = PostCommentForComparedCommitResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializePostCommentForComparedCommitOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwPostCommentForComparedCommitError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CodeCommitException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BeforeCommitIdAndAfterCommitIdAreSameException" -> BeforeCommitIdAndAfterCommitIdAreSameExceptionDeserializer().deserialize(context, wrappedResponse)
        "ClientRequestTokenRequiredException" -> ClientRequestTokenRequiredExceptionDeserializer().deserialize(context, wrappedResponse)
        "CommentContentRequiredException" -> CommentContentRequiredExceptionDeserializer().deserialize(context, wrappedResponse)
        "CommentContentSizeLimitExceededException" -> CommentContentSizeLimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "CommitDoesNotExistException" -> CommitDoesNotExistExceptionDeserializer().deserialize(context, wrappedResponse)
        "CommitIdRequiredException" -> CommitIdRequiredExceptionDeserializer().deserialize(context, wrappedResponse)
        "EncryptionIntegrityChecksFailedException" -> EncryptionIntegrityChecksFailedExceptionDeserializer().deserialize(context, wrappedResponse)
        "EncryptionKeyAccessDeniedException" -> EncryptionKeyAccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "EncryptionKeyDisabledException" -> EncryptionKeyDisabledExceptionDeserializer().deserialize(context, wrappedResponse)
        "EncryptionKeyNotFoundException" -> EncryptionKeyNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "EncryptionKeyUnavailableException" -> EncryptionKeyUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        "IdempotencyParameterMismatchException" -> IdempotencyParameterMismatchExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidClientRequestTokenException" -> InvalidClientRequestTokenExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidCommitIdException" -> InvalidCommitIdExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidFileLocationException" -> InvalidFileLocationExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidFilePositionException" -> InvalidFilePositionExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidPathException" -> InvalidPathExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRelativeFileVersionEnumException" -> InvalidRelativeFileVersionEnumExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRepositoryNameException" -> InvalidRepositoryNameExceptionDeserializer().deserialize(context, wrappedResponse)
        "PathDoesNotExistException" -> PathDoesNotExistExceptionDeserializer().deserialize(context, wrappedResponse)
        "PathRequiredException" -> PathRequiredExceptionDeserializer().deserialize(context, wrappedResponse)
        "RepositoryDoesNotExistException" -> RepositoryDoesNotExistExceptionDeserializer().deserialize(context, wrappedResponse)
        "RepositoryNameRequiredException" -> RepositoryNameRequiredExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CodeCommitException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializePostCommentForComparedCommitOperationBody(builder: PostCommentForComparedCommitResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AFTERBLOBID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("afterBlobId"))
    val AFTERCOMMITID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("afterCommitId"))
    val BEFOREBLOBID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("beforeBlobId"))
    val BEFORECOMMITID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("beforeCommitId"))
    val COMMENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("comment"))
    val LOCATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("location"))
    val REPOSITORYNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("repositoryName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AFTERBLOBID_DESCRIPTOR)
        field(AFTERCOMMITID_DESCRIPTOR)
        field(BEFOREBLOBID_DESCRIPTOR)
        field(BEFORECOMMITID_DESCRIPTOR)
        field(COMMENT_DESCRIPTOR)
        field(LOCATION_DESCRIPTOR)
        field(REPOSITORYNAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AFTERBLOBID_DESCRIPTOR.index -> builder.afterBlobId = deserializeString()
                AFTERCOMMITID_DESCRIPTOR.index -> builder.afterCommitId = deserializeString()
                BEFOREBLOBID_DESCRIPTOR.index -> builder.beforeBlobId = deserializeString()
                BEFORECOMMITID_DESCRIPTOR.index -> builder.beforeCommitId = deserializeString()
                COMMENT_DESCRIPTOR.index -> builder.comment = deserializeCommentDocument(deserializer)
                LOCATION_DESCRIPTOR.index -> builder.location = deserializeLocationDocument(deserializer)
                REPOSITORYNAME_DESCRIPTOR.index -> builder.repositoryName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
