// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecommit.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.codecommit.model.CodeCommitException
import aws.sdk.kotlin.services.codecommit.model.PutCommentReactionResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse


internal class PutCommentReactionOperationDeserializer: HttpDeserialize<PutCommentReactionResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): PutCommentReactionResponse {
        if (!response.status.isSuccess()) {
            throwPutCommentReactionError(context, response)
        }
        val builder = PutCommentReactionResponse.Builder()

        return builder.build()
    }
}

private suspend fun throwPutCommentReactionError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CodeCommitException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "CommentDeletedException" -> CommentDeletedExceptionDeserializer().deserialize(context, wrappedResponse)
        "CommentDoesNotExistException" -> CommentDoesNotExistExceptionDeserializer().deserialize(context, wrappedResponse)
        "CommentIdRequiredException" -> CommentIdRequiredExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidCommentIdException" -> InvalidCommentIdExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidReactionValueException" -> InvalidReactionValueExceptionDeserializer().deserialize(context, wrappedResponse)
        "ReactionLimitExceededException" -> ReactionLimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ReactionValueRequiredException" -> ReactionValueRequiredExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CodeCommitException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
