// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecommit.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.codecommit.model.CodeCommitException
import aws.sdk.kotlin.services.codecommit.model.RepositoryTriggerExecutionFailure
import aws.sdk.kotlin.services.codecommit.model.TestRepositoryTriggersResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class TestRepositoryTriggersOperationDeserializer: HttpDeserialize<TestRepositoryTriggersResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): TestRepositoryTriggersResponse {
        if (!response.status.isSuccess()) {
            throwTestRepositoryTriggersError(context, response)
        }
        val builder = TestRepositoryTriggersResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeTestRepositoryTriggersOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwTestRepositoryTriggersError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CodeCommitException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "EncryptionIntegrityChecksFailedException" -> EncryptionIntegrityChecksFailedExceptionDeserializer().deserialize(context, wrappedResponse)
        "EncryptionKeyAccessDeniedException" -> EncryptionKeyAccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "EncryptionKeyDisabledException" -> EncryptionKeyDisabledExceptionDeserializer().deserialize(context, wrappedResponse)
        "EncryptionKeyNotFoundException" -> EncryptionKeyNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "EncryptionKeyUnavailableException" -> EncryptionKeyUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRepositoryNameException" -> InvalidRepositoryNameExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRepositoryTriggerBranchNameException" -> InvalidRepositoryTriggerBranchNameExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRepositoryTriggerCustomDataException" -> InvalidRepositoryTriggerCustomDataExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRepositoryTriggerDestinationArnException" -> InvalidRepositoryTriggerDestinationArnExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRepositoryTriggerEventsException" -> InvalidRepositoryTriggerEventsExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRepositoryTriggerNameException" -> InvalidRepositoryTriggerNameExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRepositoryTriggerRegionException" -> InvalidRepositoryTriggerRegionExceptionDeserializer().deserialize(context, wrappedResponse)
        "MaximumBranchesExceededException" -> MaximumBranchesExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "MaximumRepositoryTriggersExceededException" -> MaximumRepositoryTriggersExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "RepositoryDoesNotExistException" -> RepositoryDoesNotExistExceptionDeserializer().deserialize(context, wrappedResponse)
        "RepositoryNameRequiredException" -> RepositoryNameRequiredExceptionDeserializer().deserialize(context, wrappedResponse)
        "RepositoryTriggerBranchNameListRequiredException" -> RepositoryTriggerBranchNameListRequiredExceptionDeserializer().deserialize(context, wrappedResponse)
        "RepositoryTriggerDestinationArnRequiredException" -> RepositoryTriggerDestinationArnRequiredExceptionDeserializer().deserialize(context, wrappedResponse)
        "RepositoryTriggerEventsListRequiredException" -> RepositoryTriggerEventsListRequiredExceptionDeserializer().deserialize(context, wrappedResponse)
        "RepositoryTriggerNameRequiredException" -> RepositoryTriggerNameRequiredExceptionDeserializer().deserialize(context, wrappedResponse)
        "RepositoryTriggersListRequiredException" -> RepositoryTriggersListRequiredExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CodeCommitException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeTestRepositoryTriggersOperationBody(builder: TestRepositoryTriggersResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val FAILEDEXECUTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("failedExecutions"))
    val SUCCESSFULEXECUTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("successfulExecutions"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(FAILEDEXECUTIONS_DESCRIPTOR)
        field(SUCCESSFULEXECUTIONS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                FAILEDEXECUTIONS_DESCRIPTOR.index -> builder.failedExecutions =
                    deserializer.deserializeList(FAILEDEXECUTIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<RepositoryTriggerExecutionFailure>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeRepositoryTriggerExecutionFailureDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                SUCCESSFULEXECUTIONS_DESCRIPTOR.index -> builder.successfulExecutions =
                    deserializer.deserializeList(SUCCESSFULEXECUTIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
