// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecommit.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.codecommit.model.ApprovalRuleTemplate
import aws.sdk.kotlin.services.codecommit.model.CodeCommitException
import aws.sdk.kotlin.services.codecommit.model.UpdateApprovalRuleTemplateNameResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateApprovalRuleTemplateNameOperationDeserializer: HttpDeserialize<UpdateApprovalRuleTemplateNameResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): UpdateApprovalRuleTemplateNameResponse {
        if (!response.status.isSuccess()) {
            throwUpdateApprovalRuleTemplateNameError(context, response)
        }
        val builder = UpdateApprovalRuleTemplateNameResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateApprovalRuleTemplateNameOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwUpdateApprovalRuleTemplateNameError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CodeCommitException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ApprovalRuleTemplateDoesNotExistException" -> ApprovalRuleTemplateDoesNotExistExceptionDeserializer().deserialize(context, wrappedResponse)
        "ApprovalRuleTemplateNameAlreadyExistsException" -> ApprovalRuleTemplateNameAlreadyExistsExceptionDeserializer().deserialize(context, wrappedResponse)
        "ApprovalRuleTemplateNameRequiredException" -> ApprovalRuleTemplateNameRequiredExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidApprovalRuleTemplateNameException" -> InvalidApprovalRuleTemplateNameExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CodeCommitException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateApprovalRuleTemplateNameOperationBody(builder: UpdateApprovalRuleTemplateNameResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val APPROVALRULETEMPLATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("approvalRuleTemplate"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APPROVALRULETEMPLATE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                APPROVALRULETEMPLATE_DESCRIPTOR.index -> builder.approvalRuleTemplate = deserializeApprovalRuleTemplateDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
