// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecommit.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.codecommit.model.CodeCommitException
import aws.sdk.kotlin.services.codecommit.model.Comment
import aws.sdk.kotlin.services.codecommit.model.UpdateCommentResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateCommentOperationDeserializer: HttpDeserialize<UpdateCommentResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): UpdateCommentResponse {
        if (!response.status.isSuccess()) {
            throwUpdateCommentError(context, response)
        }
        val builder = UpdateCommentResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateCommentOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwUpdateCommentError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CodeCommitException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "CommentContentRequiredException" -> CommentContentRequiredExceptionDeserializer().deserialize(context, wrappedResponse)
        "CommentContentSizeLimitExceededException" -> CommentContentSizeLimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "CommentDeletedException" -> CommentDeletedExceptionDeserializer().deserialize(context, wrappedResponse)
        "CommentDoesNotExistException" -> CommentDoesNotExistExceptionDeserializer().deserialize(context, wrappedResponse)
        "CommentIdRequiredException" -> CommentIdRequiredExceptionDeserializer().deserialize(context, wrappedResponse)
        "CommentNotCreatedByCallerException" -> CommentNotCreatedByCallerExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidCommentIdException" -> InvalidCommentIdExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CodeCommitException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateCommentOperationBody(builder: UpdateCommentResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val COMMENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("comment"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(COMMENT_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                COMMENT_DESCRIPTOR.index -> builder.comment = deserializeCommentDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
