// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecommit.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.codecommit.model.CodeCommitException
import aws.sdk.kotlin.services.codecommit.model.UpdatePullRequestApprovalStateResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse


internal class UpdatePullRequestApprovalStateOperationDeserializer: HttpDeserialize<UpdatePullRequestApprovalStateResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): UpdatePullRequestApprovalStateResponse {
        if (!response.status.isSuccess()) {
            throwUpdatePullRequestApprovalStateError(context, response)
        }
        val builder = UpdatePullRequestApprovalStateResponse.Builder()

        return builder.build()
    }
}

private suspend fun throwUpdatePullRequestApprovalStateError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CodeCommitException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ApprovalStateRequiredException" -> ApprovalStateRequiredExceptionDeserializer().deserialize(context, wrappedResponse)
        "EncryptionIntegrityChecksFailedException" -> EncryptionIntegrityChecksFailedExceptionDeserializer().deserialize(context, wrappedResponse)
        "EncryptionKeyAccessDeniedException" -> EncryptionKeyAccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "EncryptionKeyDisabledException" -> EncryptionKeyDisabledExceptionDeserializer().deserialize(context, wrappedResponse)
        "EncryptionKeyNotFoundException" -> EncryptionKeyNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "EncryptionKeyUnavailableException" -> EncryptionKeyUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidApprovalStateException" -> InvalidApprovalStateExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidPullRequestIdException" -> InvalidPullRequestIdExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRevisionIdException" -> InvalidRevisionIdExceptionDeserializer().deserialize(context, wrappedResponse)
        "MaximumNumberOfApprovalsExceededException" -> MaximumNumberOfApprovalsExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "PullRequestAlreadyClosedException" -> PullRequestAlreadyClosedExceptionDeserializer().deserialize(context, wrappedResponse)
        "PullRequestCannotBeApprovedByAuthorException" -> PullRequestCannotBeApprovedByAuthorExceptionDeserializer().deserialize(context, wrappedResponse)
        "PullRequestDoesNotExistException" -> PullRequestDoesNotExistExceptionDeserializer().deserialize(context, wrappedResponse)
        "PullRequestIdRequiredException" -> PullRequestIdRequiredExceptionDeserializer().deserialize(context, wrappedResponse)
        "RevisionIdRequiredException" -> RevisionIdRequiredExceptionDeserializer().deserialize(context, wrappedResponse)
        "RevisionNotCurrentException" -> RevisionNotCurrentExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CodeCommitException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
