// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.model



/**
 * Information about alarms associated with the deployment group.
 */
class AlarmConfiguration private constructor(builder: Builder) {
    /**
     * A list of alarms configured for the deployment group. A maximum of 10 alarms can be
     * added to a deployment group.
     */
    val alarms: List<Alarm>? = builder.alarms
    /**
     * Indicates whether the alarm configuration is enabled.
     */
    val enabled: kotlin.Boolean = builder.enabled
    /**
     * Indicates whether a deployment should continue if information about the current state
     * of alarms cannot be retrieved from Amazon CloudWatch. The default value is false.
     *
     *
     *
     * true: The deployment proceeds even if alarm status information
     * can't be retrieved from Amazon CloudWatch.
     *
     *
     * false: The deployment stops if alarm status information can't be
     * retrieved from Amazon CloudWatch.
     */
    val ignorePollAlarmFailure: kotlin.Boolean = builder.ignorePollAlarmFailure

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codedeploy.model.AlarmConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AlarmConfiguration(")
        append("alarms=$alarms,")
        append("enabled=$enabled,")
        append("ignorePollAlarmFailure=$ignorePollAlarmFailure)")
    }

    override fun hashCode(): kotlin.Int {
        var result = alarms?.hashCode() ?: 0
        result = 31 * result + (enabled.hashCode())
        result = 31 * result + (ignorePollAlarmFailure.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AlarmConfiguration

        if (alarms != other.alarms) return false
        if (enabled != other.enabled) return false
        if (ignorePollAlarmFailure != other.ignorePollAlarmFailure) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codedeploy.model.AlarmConfiguration = Builder(this).apply(block).build()

    class Builder {
        /**
         * A list of alarms configured for the deployment group. A maximum of 10 alarms can be
         * added to a deployment group.
         */
        var alarms: List<Alarm>? = null
        /**
         * Indicates whether the alarm configuration is enabled.
         */
        var enabled: kotlin.Boolean = false
        /**
         * Indicates whether a deployment should continue if information about the current state
         * of alarms cannot be retrieved from Amazon CloudWatch. The default value is false.
         *
         *
         *
         * true: The deployment proceeds even if alarm status information
         * can't be retrieved from Amazon CloudWatch.
         *
         *
         * false: The deployment stops if alarm status information can't be
         * retrieved from Amazon CloudWatch.
         */
        var ignorePollAlarmFailure: kotlin.Boolean = false

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codedeploy.model.AlarmConfiguration) : this() {
            this.alarms = x.alarms
            this.enabled = x.enabled
            this.ignorePollAlarmFailure = x.ignorePollAlarmFailure
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codedeploy.model.AlarmConfiguration = AlarmConfiguration(this)
    }
}
