// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.model



/**
 * Information about a set of Amazon ECS tasks in an AWS CodeDeploy deployment. An
 * Amazon ECS task set includes details such as the desired number of tasks, how many tasks
 * are running, and whether the task set serves production traffic. An AWS CodeDeploy
 * application that uses the Amazon ECS compute platform deploys a containerized
 * application in an Amazon ECS service as a task set.
 */
class EcsTaskSet private constructor(builder: Builder) {
    /**
     * The number of tasks in a task set. During a deployment that uses the Amazon ECS
     * compute type, CodeDeploy instructs Amazon ECS to create a new task set and uses this
     * value to determine how many tasks to create. After the updated task set is created,
     * CodeDeploy shifts traffic to the new task set.
     */
    val desiredCount: kotlin.Long = builder.desiredCount
    /**
     * A unique ID of an ECSTaskSet.
     */
    val identifer: kotlin.String? = builder.identifer
    /**
     * The number of tasks in the task set that are in the PENDING status
     * during an Amazon ECS deployment. A task in the PENDING state is preparing
     * to enter the RUNNING state. A task set enters the PENDING
     * status when it launches for the first time, or when it is restarted after being in the
     * STOPPED state.
     */
    val pendingCount: kotlin.Long = builder.pendingCount
    /**
     * The number of tasks in the task set that are in the RUNNING status
     * during an Amazon ECS deployment. A task in the RUNNING state is running and
     * ready for use.
     */
    val runningCount: kotlin.Long = builder.runningCount
    /**
     * The status of the task set. There are three valid task set statuses:
     *
     *
     *
     * PRIMARY: Indicates the task set is serving production traffic.
     *
     *
     *
     * ACTIVE: Indicates the task set is not serving production traffic.
     *
     *
     *
     * DRAINING: Indicates the tasks in the task set are being stopped and
     * their corresponding targets are being deregistered from their target group.
     */
    val status: kotlin.String? = builder.status
    /**
     * The target group associated with the task set. The target group is used by AWS
     * CodeDeploy to manage traffic to a task set.
     */
    val targetGroup: aws.sdk.kotlin.services.codedeploy.model.TargetGroupInfo? = builder.targetGroup
    /**
     * A label that identifies whether the ECS task set is an original target
     * (BLUE) or a replacement target (GREEN).
     */
    val taskSetLabel: aws.sdk.kotlin.services.codedeploy.model.TargetLabel? = builder.taskSetLabel
    /**
     * The percentage of traffic served by this task set.
     */
    val trafficWeight: kotlin.Double = builder.trafficWeight

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codedeploy.model.EcsTaskSet = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EcsTaskSet(")
        append("desiredCount=$desiredCount,")
        append("identifer=$identifer,")
        append("pendingCount=$pendingCount,")
        append("runningCount=$runningCount,")
        append("status=$status,")
        append("targetGroup=$targetGroup,")
        append("taskSetLabel=$taskSetLabel,")
        append("trafficWeight=$trafficWeight)")
    }

    override fun hashCode(): kotlin.Int {
        var result = desiredCount.hashCode()
        result = 31 * result + (identifer?.hashCode() ?: 0)
        result = 31 * result + (pendingCount.hashCode())
        result = 31 * result + (runningCount.hashCode())
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (targetGroup?.hashCode() ?: 0)
        result = 31 * result + (taskSetLabel?.hashCode() ?: 0)
        result = 31 * result + (trafficWeight.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EcsTaskSet

        if (desiredCount != other.desiredCount) return false
        if (identifer != other.identifer) return false
        if (pendingCount != other.pendingCount) return false
        if (runningCount != other.runningCount) return false
        if (status != other.status) return false
        if (targetGroup != other.targetGroup) return false
        if (taskSetLabel != other.taskSetLabel) return false
        if (trafficWeight != other.trafficWeight) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codedeploy.model.EcsTaskSet = Builder(this).apply(block).build()

    class Builder {
        /**
         * The number of tasks in a task set. During a deployment that uses the Amazon ECS
         * compute type, CodeDeploy instructs Amazon ECS to create a new task set and uses this
         * value to determine how many tasks to create. After the updated task set is created,
         * CodeDeploy shifts traffic to the new task set.
         */
        var desiredCount: kotlin.Long = 0L
        /**
         * A unique ID of an ECSTaskSet.
         */
        var identifer: kotlin.String? = null
        /**
         * The number of tasks in the task set that are in the PENDING status
         * during an Amazon ECS deployment. A task in the PENDING state is preparing
         * to enter the RUNNING state. A task set enters the PENDING
         * status when it launches for the first time, or when it is restarted after being in the
         * STOPPED state.
         */
        var pendingCount: kotlin.Long = 0L
        /**
         * The number of tasks in the task set that are in the RUNNING status
         * during an Amazon ECS deployment. A task in the RUNNING state is running and
         * ready for use.
         */
        var runningCount: kotlin.Long = 0L
        /**
         * The status of the task set. There are three valid task set statuses:
         *
         *
         *
         * PRIMARY: Indicates the task set is serving production traffic.
         *
         *
         *
         * ACTIVE: Indicates the task set is not serving production traffic.
         *
         *
         *
         * DRAINING: Indicates the tasks in the task set are being stopped and
         * their corresponding targets are being deregistered from their target group.
         */
        var status: kotlin.String? = null
        /**
         * The target group associated with the task set. The target group is used by AWS
         * CodeDeploy to manage traffic to a task set.
         */
        var targetGroup: aws.sdk.kotlin.services.codedeploy.model.TargetGroupInfo? = null
        /**
         * A label that identifies whether the ECS task set is an original target
         * (BLUE) or a replacement target (GREEN).
         */
        var taskSetLabel: aws.sdk.kotlin.services.codedeploy.model.TargetLabel? = null
        /**
         * The percentage of traffic served by this task set.
         */
        var trafficWeight: kotlin.Double = 0.0

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codedeploy.model.EcsTaskSet) : this() {
            this.desiredCount = x.desiredCount
            this.identifer = x.identifer
            this.pendingCount = x.pendingCount
            this.runningCount = x.runningCount
            this.status = x.status
            this.targetGroup = x.targetGroup
            this.taskSetLabel = x.taskSetLabel
            this.trafficWeight = x.trafficWeight
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codedeploy.model.EcsTaskSet = EcsTaskSet(this)

        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.TargetGroupInfo] inside the given [block]
         */
        fun targetGroup(block: aws.sdk.kotlin.services.codedeploy.model.TargetGroupInfo.Builder.() -> kotlin.Unit) {
            this.targetGroup = aws.sdk.kotlin.services.codedeploy.model.TargetGroupInfo.invoke(block)
        }
    }
}
