// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about the target AWS Lambda function during an AWS Lambda deployment.
 */
class LambdaTarget private constructor(builder: Builder) {
    /**
     * The unique ID of a deployment.
     */
    val deploymentId: kotlin.String? = builder.deploymentId
    /**
     * A LambdaFunctionInfo object that describes a target Lambda function.
     */
    val lambdaFunctionInfo: aws.sdk.kotlin.services.codedeploy.model.LambdaFunctionInfo? = builder.lambdaFunctionInfo
    /**
     * The date and time when the target Lambda function was updated by a deployment.
     */
    val lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedAt
    /**
     * The lifecycle events of the deployment to this target Lambda function.
     */
    val lifecycleEvents: List<LifecycleEvent>? = builder.lifecycleEvents
    /**
     * The status an AWS Lambda deployment's target Lambda function.
     */
    val status: aws.sdk.kotlin.services.codedeploy.model.TargetStatus? = builder.status
    /**
     * The Amazon Resource Name (ARN) of the target.
     */
    val targetArn: kotlin.String? = builder.targetArn
    /**
     * The unique ID of a deployment target that has a type of lambdaTarget.
     */
    val targetId: kotlin.String? = builder.targetId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codedeploy.model.LambdaTarget = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LambdaTarget(")
        append("deploymentId=$deploymentId,")
        append("lambdaFunctionInfo=$lambdaFunctionInfo,")
        append("lastUpdatedAt=$lastUpdatedAt,")
        append("lifecycleEvents=$lifecycleEvents,")
        append("status=$status,")
        append("targetArn=$targetArn,")
        append("targetId=$targetId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = deploymentId?.hashCode() ?: 0
        result = 31 * result + (lambdaFunctionInfo?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedAt?.hashCode() ?: 0)
        result = 31 * result + (lifecycleEvents?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (targetArn?.hashCode() ?: 0)
        result = 31 * result + (targetId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LambdaTarget

        if (deploymentId != other.deploymentId) return false
        if (lambdaFunctionInfo != other.lambdaFunctionInfo) return false
        if (lastUpdatedAt != other.lastUpdatedAt) return false
        if (lifecycleEvents != other.lifecycleEvents) return false
        if (status != other.status) return false
        if (targetArn != other.targetArn) return false
        if (targetId != other.targetId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codedeploy.model.LambdaTarget = Builder(this).apply(block).build()

    class Builder {
        /**
         * The unique ID of a deployment.
         */
        var deploymentId: kotlin.String? = null
        /**
         * A LambdaFunctionInfo object that describes a target Lambda function.
         */
        var lambdaFunctionInfo: aws.sdk.kotlin.services.codedeploy.model.LambdaFunctionInfo? = null
        /**
         * The date and time when the target Lambda function was updated by a deployment.
         */
        var lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The lifecycle events of the deployment to this target Lambda function.
         */
        var lifecycleEvents: List<LifecycleEvent>? = null
        /**
         * The status an AWS Lambda deployment's target Lambda function.
         */
        var status: aws.sdk.kotlin.services.codedeploy.model.TargetStatus? = null
        /**
         * The Amazon Resource Name (ARN) of the target.
         */
        var targetArn: kotlin.String? = null
        /**
         * The unique ID of a deployment target that has a type of lambdaTarget.
         */
        var targetId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codedeploy.model.LambdaTarget) : this() {
            this.deploymentId = x.deploymentId
            this.lambdaFunctionInfo = x.lambdaFunctionInfo
            this.lastUpdatedAt = x.lastUpdatedAt
            this.lifecycleEvents = x.lifecycleEvents
            this.status = x.status
            this.targetArn = x.targetArn
            this.targetId = x.targetId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codedeploy.model.LambdaTarget = LambdaTarget(this)

        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.LambdaFunctionInfo] inside the given [block]
         */
        fun lambdaFunctionInfo(block: aws.sdk.kotlin.services.codedeploy.model.LambdaFunctionInfo.Builder.() -> kotlin.Unit) {
            this.lambdaFunctionInfo = aws.sdk.kotlin.services.codedeploy.model.LambdaFunctionInfo.invoke(block)
        }
    }
}
