// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.model



/**
 * Information about the Elastic Load Balancing load balancer or target group used in a
 * deployment.
 */
class LoadBalancerInfo private constructor(builder: Builder) {
    /**
     * An array that contains information about the load balancer to use for load balancing
     * in a deployment. In Elastic Load Balancing, load balancers are used with Classic Load
     * Balancers.
     *
     * Adding more than one load balancer to the array is not supported.
     */
    val elbInfoList: List<ElbInfo>? = builder.elbInfoList
    /**
     * An array that contains information about the target group to use for load balancing in
     * a deployment. In Elastic Load Balancing, target groups are used with Application Load
     * Balancers.
     *
     * Adding more than one target group to the array is not supported.
     */
    val targetGroupInfoList: List<TargetGroupInfo>? = builder.targetGroupInfoList
    /**
     * The target group pair information. This is an array of
     * TargeGroupPairInfo objects with a maximum size of one.
     */
    val targetGroupPairInfoList: List<TargetGroupPairInfo>? = builder.targetGroupPairInfoList

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codedeploy.model.LoadBalancerInfo = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LoadBalancerInfo(")
        append("elbInfoList=$elbInfoList,")
        append("targetGroupInfoList=$targetGroupInfoList,")
        append("targetGroupPairInfoList=$targetGroupPairInfoList)")
    }

    override fun hashCode(): kotlin.Int {
        var result = elbInfoList?.hashCode() ?: 0
        result = 31 * result + (targetGroupInfoList?.hashCode() ?: 0)
        result = 31 * result + (targetGroupPairInfoList?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LoadBalancerInfo

        if (elbInfoList != other.elbInfoList) return false
        if (targetGroupInfoList != other.targetGroupInfoList) return false
        if (targetGroupPairInfoList != other.targetGroupPairInfoList) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codedeploy.model.LoadBalancerInfo = Builder(this).apply(block).build()

    class Builder {
        /**
         * An array that contains information about the load balancer to use for load balancing
         * in a deployment. In Elastic Load Balancing, load balancers are used with Classic Load
         * Balancers.
         *
         * Adding more than one load balancer to the array is not supported.
         */
        var elbInfoList: List<ElbInfo>? = null
        /**
         * An array that contains information about the target group to use for load balancing in
         * a deployment. In Elastic Load Balancing, target groups are used with Application Load
         * Balancers.
         *
         * Adding more than one target group to the array is not supported.
         */
        var targetGroupInfoList: List<TargetGroupInfo>? = null
        /**
         * The target group pair information. This is an array of
         * TargeGroupPairInfo objects with a maximum size of one.
         */
        var targetGroupPairInfoList: List<TargetGroupPairInfo>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codedeploy.model.LoadBalancerInfo) : this() {
            this.elbInfoList = x.elbInfoList
            this.targetGroupInfoList = x.targetGroupInfoList
            this.targetGroupPairInfoList = x.targetGroupPairInfoList
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codedeploy.model.LoadBalancerInfo = LoadBalancerInfo(this)
    }
}
