// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.model



/**
 * Information about minimum healthy instance.
 */
class MinimumHealthyHosts private constructor(builder: Builder) {
    /**
     * The minimum healthy instance type:
     *
     *
     *
     * HOST_COUNT: The minimum number of healthy instances as an
     * absolute value.
     *
     *
     * FLEET_PERCENT: The minimum number of healthy instances as a
     * percentage of the total number of instances in the deployment.
     *
     *
     * In an example of nine instances, if a HOST_COUNT of six is specified, deploy to up to
     * three instances at a time. The deployment is successful if six or more instances are
     * deployed to successfully. Otherwise, the deployment fails. If a FLEET_PERCENT of 40 is
     * specified, deploy to up to five instances at a time. The deployment is successful if
     * four or more instances are deployed to successfully. Otherwise, the deployment
     * fails.
     *
     * In a call to the GetDeploymentConfig, CodeDeployDefault.OneAtATime
     * returns a minimum healthy instance type of MOST_CONCURRENCY and a value of 1. This
     * means a deployment to only one instance at a time. (You cannot set the type to
     * MOST_CONCURRENCY, only to HOST_COUNT or FLEET_PERCENT.) In addition, with
     * CodeDeployDefault.OneAtATime, AWS CodeDeploy attempts to ensure that all instances
     * but one are kept in a healthy state during the deployment. Although this allows one
     * instance at a time to be taken offline for a new deployment, it also means that if
     * the deployment to the last instance fails, the overall deployment is still
     * successful.
     *
     * For more information, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/instances-health.html">AWS CodeDeploy Instance
     * Health in the AWS CodeDeploy User Guide.
     */
    val type: aws.sdk.kotlin.services.codedeploy.model.MinimumHealthyHostsType? = builder.type
    /**
     * The minimum healthy instance value.
     */
    val value: kotlin.Int = builder.value

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codedeploy.model.MinimumHealthyHosts = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MinimumHealthyHosts(")
        append("type=$type,")
        append("value=$value)")
    }

    override fun hashCode(): kotlin.Int {
        var result = type?.hashCode() ?: 0
        result = 31 * result + (value)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MinimumHealthyHosts

        if (type != other.type) return false
        if (value != other.value) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codedeploy.model.MinimumHealthyHosts = Builder(this).apply(block).build()

    class Builder {
        /**
         * The minimum healthy instance type:
         *
         *
         *
         * HOST_COUNT: The minimum number of healthy instances as an
         * absolute value.
         *
         *
         * FLEET_PERCENT: The minimum number of healthy instances as a
         * percentage of the total number of instances in the deployment.
         *
         *
         * In an example of nine instances, if a HOST_COUNT of six is specified, deploy to up to
         * three instances at a time. The deployment is successful if six or more instances are
         * deployed to successfully. Otherwise, the deployment fails. If a FLEET_PERCENT of 40 is
         * specified, deploy to up to five instances at a time. The deployment is successful if
         * four or more instances are deployed to successfully. Otherwise, the deployment
         * fails.
         *
         * In a call to the GetDeploymentConfig, CodeDeployDefault.OneAtATime
         * returns a minimum healthy instance type of MOST_CONCURRENCY and a value of 1. This
         * means a deployment to only one instance at a time. (You cannot set the type to
         * MOST_CONCURRENCY, only to HOST_COUNT or FLEET_PERCENT.) In addition, with
         * CodeDeployDefault.OneAtATime, AWS CodeDeploy attempts to ensure that all instances
         * but one are kept in a healthy state during the deployment. Although this allows one
         * instance at a time to be taken offline for a new deployment, it also means that if
         * the deployment to the last instance fails, the overall deployment is still
         * successful.
         *
         * For more information, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/instances-health.html">AWS CodeDeploy Instance
         * Health in the AWS CodeDeploy User Guide.
         */
        var type: aws.sdk.kotlin.services.codedeploy.model.MinimumHealthyHostsType? = null
        /**
         * The minimum healthy instance value.
         */
        var value: kotlin.Int = 0

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codedeploy.model.MinimumHealthyHosts) : this() {
            this.type = x.type
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codedeploy.model.MinimumHealthyHosts = MinimumHealthyHosts(this)
    }
}
