// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.paginators

import aws.sdk.kotlin.services.codedeploy.CodeDeployClient
import aws.sdk.kotlin.services.codedeploy.model.ListApplicationRevisionsRequest
import aws.sdk.kotlin.services.codedeploy.model.ListApplicationRevisionsResponse
import aws.sdk.kotlin.services.codedeploy.model.ListApplicationsRequest
import aws.sdk.kotlin.services.codedeploy.model.ListApplicationsResponse
import aws.sdk.kotlin.services.codedeploy.model.ListDeploymentConfigsRequest
import aws.sdk.kotlin.services.codedeploy.model.ListDeploymentConfigsResponse
import aws.sdk.kotlin.services.codedeploy.model.ListDeploymentGroupsRequest
import aws.sdk.kotlin.services.codedeploy.model.ListDeploymentGroupsResponse
import aws.sdk.kotlin.services.codedeploy.model.ListDeploymentInstancesRequest
import aws.sdk.kotlin.services.codedeploy.model.ListDeploymentInstancesResponse
import aws.sdk.kotlin.services.codedeploy.model.ListDeploymentsRequest
import aws.sdk.kotlin.services.codedeploy.model.ListDeploymentsResponse
import aws.sdk.kotlin.services.codedeploy.model.RevisionLocation
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListApplicationRevisionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListApplicationRevisionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListApplicationRevisionsResponse]
 */
fun CodeDeployClient.listApplicationRevisionsPaginated(initialRequest: ListApplicationRevisionsRequest): Flow<ListApplicationRevisionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listApplicationRevisionsPaginated.listApplicationRevisions(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListApplicationRevisionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListApplicationRevisionsResponse]
 */
fun CodeDeployClient.listApplicationRevisionsPaginated(block: ListApplicationRevisionsRequest.Builder.() -> Unit): Flow<ListApplicationRevisionsResponse> =
    listApplicationRevisionsPaginated(ListApplicationRevisionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listApplicationRevisionsPaginated]
 * to access the nested member [RevisionLocation]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [RevisionLocation]
 */
@JvmName("listApplicationRevisionsResponseRevisionLocation")
fun Flow<ListApplicationRevisionsResponse>.revisions(): Flow<RevisionLocation> =
    transform() { response ->
        response.revisions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListApplicationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListApplicationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListApplicationsResponse]
 */
fun CodeDeployClient.listApplicationsPaginated(initialRequest: ListApplicationsRequest): Flow<ListApplicationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listApplicationsPaginated.listApplications(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListApplicationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListApplicationsResponse]
 */
fun CodeDeployClient.listApplicationsPaginated(block: ListApplicationsRequest.Builder.() -> Unit): Flow<ListApplicationsResponse> =
    listApplicationsPaginated(ListApplicationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listApplicationsPaginated]
 * to access the nested member [ApplicationName]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ApplicationName]
 */
@JvmName("listApplicationsResponseApplicationName")
fun Flow<ListApplicationsResponse>.applications(): Flow<String> =
    transform() { response ->
        response.applications?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListDeploymentConfigsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDeploymentConfigsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDeploymentConfigsResponse]
 */
fun CodeDeployClient.listDeploymentConfigsPaginated(initialRequest: ListDeploymentConfigsRequest): Flow<ListDeploymentConfigsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDeploymentConfigsPaginated.listDeploymentConfigs(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListDeploymentConfigsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDeploymentConfigsResponse]
 */
fun CodeDeployClient.listDeploymentConfigsPaginated(block: ListDeploymentConfigsRequest.Builder.() -> Unit): Flow<ListDeploymentConfigsResponse> =
    listDeploymentConfigsPaginated(ListDeploymentConfigsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listDeploymentConfigsPaginated]
 * to access the nested member [DeploymentConfigName]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DeploymentConfigName]
 */
@JvmName("listDeploymentConfigsResponseDeploymentConfigName")
fun Flow<ListDeploymentConfigsResponse>.deploymentConfigsList(): Flow<String> =
    transform() { response ->
        response.deploymentConfigsList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListDeploymentGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDeploymentGroupsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDeploymentGroupsResponse]
 */
fun CodeDeployClient.listDeploymentGroupsPaginated(initialRequest: ListDeploymentGroupsRequest): Flow<ListDeploymentGroupsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDeploymentGroupsPaginated.listDeploymentGroups(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListDeploymentGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDeploymentGroupsResponse]
 */
fun CodeDeployClient.listDeploymentGroupsPaginated(block: ListDeploymentGroupsRequest.Builder.() -> Unit): Flow<ListDeploymentGroupsResponse> =
    listDeploymentGroupsPaginated(ListDeploymentGroupsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listDeploymentGroupsPaginated]
 * to access the nested member [DeploymentGroupName]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DeploymentGroupName]
 */
@JvmName("listDeploymentGroupsResponseDeploymentGroupName")
fun Flow<ListDeploymentGroupsResponse>.deploymentGroups(): Flow<String> =
    transform() { response ->
        response.deploymentGroups?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListDeploymentInstancesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDeploymentInstancesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDeploymentInstancesResponse]
 */
fun CodeDeployClient.listDeploymentInstancesPaginated(initialRequest: ListDeploymentInstancesRequest): Flow<ListDeploymentInstancesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDeploymentInstancesPaginated.listDeploymentInstances(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListDeploymentInstancesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDeploymentInstancesResponse]
 */
fun CodeDeployClient.listDeploymentInstancesPaginated(block: ListDeploymentInstancesRequest.Builder.() -> Unit): Flow<ListDeploymentInstancesResponse> =
    listDeploymentInstancesPaginated(ListDeploymentInstancesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listDeploymentInstancesPaginated]
 * to access the nested member [InstanceId]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [InstanceId]
 */
@JvmName("listDeploymentInstancesResponseInstanceId")
fun Flow<ListDeploymentInstancesResponse>.instancesList(): Flow<String> =
    transform() { response ->
        response.instancesList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListDeploymentsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDeploymentsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDeploymentsResponse]
 */
fun CodeDeployClient.listDeploymentsPaginated(initialRequest: ListDeploymentsRequest): Flow<ListDeploymentsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDeploymentsPaginated.listDeployments(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListDeploymentsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDeploymentsResponse]
 */
fun CodeDeployClient.listDeploymentsPaginated(block: ListDeploymentsRequest.Builder.() -> Unit): Flow<ListDeploymentsResponse> =
    listDeploymentsPaginated(ListDeploymentsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listDeploymentsPaginated]
 * to access the nested member [DeploymentId]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DeploymentId]
 */
@JvmName("listDeploymentsResponseDeploymentId")
fun Flow<ListDeploymentsResponse>.deployments(): Flow<String> =
    transform() { response ->
        response.deployments?.forEach {
            emit(it)
        }
    }
