// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.model



/**
 * A revision for an AWS Lambda or Amazon ECS deployment that is a YAML-formatted or
 * JSON-formatted string. For AWS Lambda and Amazon ECS deployments, the revision is the
 * same as the AppSpec file. This method replaces the deprecated RawString
 * data type.
 */
class AppSpecContent private constructor(builder: Builder) {
    /**
     * The YAML-formatted or JSON-formatted revision string.
     * For an AWS Lambda deployment, the content includes a Lambda function name, the alias
     * for its original version, and the alias for its replacement version. The deployment
     * shifts traffic from the original version of the Lambda function to the replacement
     * version.
     * For an Amazon ECS deployment, the content includes the task name, information about
     * the load balancer that serves traffic to the container, and more.
     * For both types of deployments, the content can specify Lambda functions that run at
     * specified hooks, such as BeforeInstall, during a deployment.
     */
    val content: kotlin.String? = builder.content
    /**
     * The SHA256 hash value of the revision content.
     */
    val sha256: kotlin.String? = builder.sha256

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codedeploy.model.AppSpecContent = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AppSpecContent(")
        append("content=$content,")
        append("sha256=$sha256)")
    }

    override fun hashCode(): kotlin.Int {
        var result = content?.hashCode() ?: 0
        result = 31 * result + (sha256?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AppSpecContent

        if (content != other.content) return false
        if (sha256 != other.sha256) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codedeploy.model.AppSpecContent = Builder(this).apply(block).build()

    class Builder {
        /**
         * The YAML-formatted or JSON-formatted revision string.
         * For an AWS Lambda deployment, the content includes a Lambda function name, the alias
         * for its original version, and the alias for its replacement version. The deployment
         * shifts traffic from the original version of the Lambda function to the replacement
         * version.
         * For an Amazon ECS deployment, the content includes the task name, information about
         * the load balancer that serves traffic to the container, and more.
         * For both types of deployments, the content can specify Lambda functions that run at
         * specified hooks, such as BeforeInstall, during a deployment.
         */
        var content: kotlin.String? = null
        /**
         * The SHA256 hash value of the revision content.
         */
        var sha256: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codedeploy.model.AppSpecContent) : this() {
            this.content = x.content
            this.sha256 = x.sha256
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codedeploy.model.AppSpecContent = AppSpecContent(this)
    }
}
