// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about the target to be updated by an AWS CloudFormation blue/green
 * deployment. This target type is used for all deployments initiated by a CloudFormation
 * stack update.
 */
class CloudFormationTarget private constructor(builder: Builder) {
    /**
     * The unique ID of an AWS CloudFormation blue/green deployment.
     */
    val deploymentId: kotlin.String? = builder.deploymentId
    /**
     * The date and time when the target application was updated by an AWS CloudFormation
     * blue/green deployment.
     */
    val lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedAt
    /**
     * The lifecycle events of the AWS CloudFormation blue/green deployment to this target
     * application.
     */
    val lifecycleEvents: List<LifecycleEvent>? = builder.lifecycleEvents
    /**
     * The resource type for the AWS CloudFormation blue/green deployment.
     */
    val resourceType: kotlin.String? = builder.resourceType
    /**
     * The status of an AWS CloudFormation blue/green deployment's target application.
     */
    val status: aws.sdk.kotlin.services.codedeploy.model.TargetStatus? = builder.status
    /**
     * The unique ID of a deployment target that has a type
     * of CloudFormationTarget.
     */
    val targetId: kotlin.String? = builder.targetId
    /**
     * The percentage of production traffic that the target version of an AWS CloudFormation
     * blue/green deployment receives.
     */
    val targetVersionWeight: kotlin.Double = builder.targetVersionWeight

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codedeploy.model.CloudFormationTarget = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CloudFormationTarget(")
        append("deploymentId=$deploymentId,")
        append("lastUpdatedAt=$lastUpdatedAt,")
        append("lifecycleEvents=$lifecycleEvents,")
        append("resourceType=$resourceType,")
        append("status=$status,")
        append("targetId=$targetId,")
        append("targetVersionWeight=$targetVersionWeight)")
    }

    override fun hashCode(): kotlin.Int {
        var result = deploymentId?.hashCode() ?: 0
        result = 31 * result + (lastUpdatedAt?.hashCode() ?: 0)
        result = 31 * result + (lifecycleEvents?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (targetId?.hashCode() ?: 0)
        result = 31 * result + (targetVersionWeight.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CloudFormationTarget

        if (deploymentId != other.deploymentId) return false
        if (lastUpdatedAt != other.lastUpdatedAt) return false
        if (lifecycleEvents != other.lifecycleEvents) return false
        if (resourceType != other.resourceType) return false
        if (status != other.status) return false
        if (targetId != other.targetId) return false
        if (targetVersionWeight != other.targetVersionWeight) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codedeploy.model.CloudFormationTarget = Builder(this).apply(block).build()

    class Builder {
        /**
         * The unique ID of an AWS CloudFormation blue/green deployment.
         */
        var deploymentId: kotlin.String? = null
        /**
         * The date and time when the target application was updated by an AWS CloudFormation
         * blue/green deployment.
         */
        var lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The lifecycle events of the AWS CloudFormation blue/green deployment to this target
         * application.
         */
        var lifecycleEvents: List<LifecycleEvent>? = null
        /**
         * The resource type for the AWS CloudFormation blue/green deployment.
         */
        var resourceType: kotlin.String? = null
        /**
         * The status of an AWS CloudFormation blue/green deployment's target application.
         */
        var status: aws.sdk.kotlin.services.codedeploy.model.TargetStatus? = null
        /**
         * The unique ID of a deployment target that has a type
         * of CloudFormationTarget.
         */
        var targetId: kotlin.String? = null
        /**
         * The percentage of production traffic that the target version of an AWS CloudFormation
         * blue/green deployment receives.
         */
        var targetVersionWeight: kotlin.Double = 0.0

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codedeploy.model.CloudFormationTarget) : this() {
            this.deploymentId = x.deploymentId
            this.lastUpdatedAt = x.lastUpdatedAt
            this.lifecycleEvents = x.lifecycleEvents
            this.resourceType = x.resourceType
            this.status = x.status
            this.targetId = x.targetId
            this.targetVersionWeight = x.targetVersionWeight
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codedeploy.model.CloudFormationTarget = CloudFormationTarget(this)
    }
}
