// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about a deployment configuration.
 */
class DeploymentConfigInfo private constructor(builder: Builder) {
    /**
     * The destination platform type for the deployment (Lambda,
     * Server, or ECS).
     */
    val computePlatform: aws.sdk.kotlin.services.codedeploy.model.ComputePlatform? = builder.computePlatform
    /**
     * The time at which the deployment configuration was created.
     */
    val createTime: aws.smithy.kotlin.runtime.time.Instant? = builder.createTime
    /**
     * The deployment configuration ID.
     */
    val deploymentConfigId: kotlin.String? = builder.deploymentConfigId
    /**
     * The deployment configuration name.
     */
    val deploymentConfigName: kotlin.String? = builder.deploymentConfigName
    /**
     * Information about the number or percentage of minimum healthy instance.
     */
    val minimumHealthyHosts: aws.sdk.kotlin.services.codedeploy.model.MinimumHealthyHosts? = builder.minimumHealthyHosts
    /**
     * The configuration that specifies how the deployment traffic is routed. Used for
     * deployments with a Lambda or ECS compute platform only.
     */
    val trafficRoutingConfig: aws.sdk.kotlin.services.codedeploy.model.TrafficRoutingConfig? = builder.trafficRoutingConfig

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codedeploy.model.DeploymentConfigInfo = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeploymentConfigInfo(")
        append("computePlatform=$computePlatform,")
        append("createTime=$createTime,")
        append("deploymentConfigId=$deploymentConfigId,")
        append("deploymentConfigName=$deploymentConfigName,")
        append("minimumHealthyHosts=$minimumHealthyHosts,")
        append("trafficRoutingConfig=$trafficRoutingConfig)")
    }

    override fun hashCode(): kotlin.Int {
        var result = computePlatform?.hashCode() ?: 0
        result = 31 * result + (createTime?.hashCode() ?: 0)
        result = 31 * result + (deploymentConfigId?.hashCode() ?: 0)
        result = 31 * result + (deploymentConfigName?.hashCode() ?: 0)
        result = 31 * result + (minimumHealthyHosts?.hashCode() ?: 0)
        result = 31 * result + (trafficRoutingConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeploymentConfigInfo

        if (computePlatform != other.computePlatform) return false
        if (createTime != other.createTime) return false
        if (deploymentConfigId != other.deploymentConfigId) return false
        if (deploymentConfigName != other.deploymentConfigName) return false
        if (minimumHealthyHosts != other.minimumHealthyHosts) return false
        if (trafficRoutingConfig != other.trafficRoutingConfig) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codedeploy.model.DeploymentConfigInfo = Builder(this).apply(block).build()

    class Builder {
        /**
         * The destination platform type for the deployment (Lambda,
         * Server, or ECS).
         */
        var computePlatform: aws.sdk.kotlin.services.codedeploy.model.ComputePlatform? = null
        /**
         * The time at which the deployment configuration was created.
         */
        var createTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The deployment configuration ID.
         */
        var deploymentConfigId: kotlin.String? = null
        /**
         * The deployment configuration name.
         */
        var deploymentConfigName: kotlin.String? = null
        /**
         * Information about the number or percentage of minimum healthy instance.
         */
        var minimumHealthyHosts: aws.sdk.kotlin.services.codedeploy.model.MinimumHealthyHosts? = null
        /**
         * The configuration that specifies how the deployment traffic is routed. Used for
         * deployments with a Lambda or ECS compute platform only.
         */
        var trafficRoutingConfig: aws.sdk.kotlin.services.codedeploy.model.TrafficRoutingConfig? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codedeploy.model.DeploymentConfigInfo) : this() {
            this.computePlatform = x.computePlatform
            this.createTime = x.createTime
            this.deploymentConfigId = x.deploymentConfigId
            this.deploymentConfigName = x.deploymentConfigName
            this.minimumHealthyHosts = x.minimumHealthyHosts
            this.trafficRoutingConfig = x.trafficRoutingConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codedeploy.model.DeploymentConfigInfo = DeploymentConfigInfo(this)

        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.MinimumHealthyHosts] inside the given [block]
         */
        fun minimumHealthyHosts(block: aws.sdk.kotlin.services.codedeploy.model.MinimumHealthyHosts.Builder.() -> kotlin.Unit) {
            this.minimumHealthyHosts = aws.sdk.kotlin.services.codedeploy.model.MinimumHealthyHosts.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.TrafficRoutingConfig] inside the given [block]
         */
        fun trafficRoutingConfig(block: aws.sdk.kotlin.services.codedeploy.model.TrafficRoutingConfig.Builder.() -> kotlin.Unit) {
            this.trafficRoutingConfig = aws.sdk.kotlin.services.codedeploy.model.TrafficRoutingConfig.invoke(block)
        }
    }
}
